/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.connector;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.google.common.base.Joiner;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import com.nirima.jenkins.plugins.docker.utils.JenkinsUtils;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.JNLPLauncher;
import io.jenkins.docker.DockerTransientNode;
import io.jenkins.docker.client.DockerAPI;
import io.jenkins.docker.connector.DockerComputerConnector;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import jenkins.model.Jenkins;
import jenkins.slaves.JnlpAgentReceiver;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DockerComputerJNLPConnector
extends DockerComputerConnector {
    @CheckForNull
    private String user;
    @CheckForNull
    private String jenkinsUrl;
    @CheckForNull
    private String[] entryPointArguments;
    private static final String DEFAULT_ENTRY_POINT_ARGUMENTS = "-url\n${" + ArgumentVariables.JenkinsUrl.getName() + "}\n${" + ArgumentVariables.Secret.getName() + "}\n${" + ArgumentVariables.NodeName.getName() + "}";

    @DataBoundConstructor
    public DockerComputerJNLPConnector() {
    }

    @CheckForNull
    public String getUser() {
        return Util.fixEmptyAndTrim((String)this.user);
    }

    @DataBoundSetter
    public void setUser(String user) {
        this.user = Util.fixEmptyAndTrim((String)user);
    }

    @CheckForNull
    public String getJenkinsUrl() {
        return Util.fixEmptyAndTrim((String)this.jenkinsUrl);
    }

    @DataBoundSetter
    public void setJenkinsUrl(String jenkinsUrl) {
        this.jenkinsUrl = Util.fixEmptyAndTrim((String)jenkinsUrl);
    }

    @NonNull
    public String getEntryPointArgumentsString() {
        if (this.entryPointArguments == null) {
            return "";
        }
        return Joiner.on((String)"\n").join((Object[])this.entryPointArguments);
    }

    @DataBoundSetter
    public void setEntryPointArgumentsString(String entryPointArgumentsString) {
        this.setEntryPointArguments(JenkinsUtils.splitAndFilterEmpty(entryPointArgumentsString, "\n"));
    }

    private void setEntryPointArguments(String[] entryPointArguments) {
        this.entryPointArguments = JenkinsUtils.fixEmpty(entryPointArguments);
    }

    public DockerComputerJNLPConnector withUser(String value) {
        this.setUser(value);
        return this;
    }

    public DockerComputerJNLPConnector withJenkinsUrl(String value) {
        this.setJenkinsUrl(value);
        return this;
    }

    public DockerComputerJNLPConnector withEntryPointArguments(String ... args) {
        this.setEntryPointArguments(args);
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.entryPointArguments);
        result = 31 * result + Objects.hash(this.jenkinsUrl, this.user);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DockerComputerJNLPConnector other = (DockerComputerJNLPConnector)((Object)obj);
        return Arrays.equals(this.entryPointArguments, other.entryPointArguments) && Objects.equals(this.jenkinsUrl, other.jenkinsUrl) && Objects.equals(this.user, other.user);
    }

    public String toString() {
        StringBuilder sb = JenkinsUtils.startToString((Object)this);
        JenkinsUtils.bldToString(sb, "user", this.user);
        JenkinsUtils.bldToString(sb, "jenkinsUrl", this.jenkinsUrl);
        JenkinsUtils.bldToString(sb, "entryPointArguments", this.entryPointArguments);
        JenkinsUtils.endToString(sb);
        return sb.toString();
    }

    @Override
    protected ComputerLauncher createLauncher(DockerAPI api, String workdir, InspectContainerResponse inspect, TaskListener listener) throws IOException, InterruptedException {
        return new JNLPLauncher();
    }

    @Override
    public void beforeContainerCreated(DockerAPI api, String workdir, CreateContainerCmd cmd) throws IOException, InterruptedException {
        String effectiveJenkinsUrl = StringUtils.isEmpty((String)this.jenkinsUrl) ? Jenkins.get().getRootUrl() : this.jenkinsUrl;
        String nodeName = DockerTemplate.getNodeNameFromContainerConfig(cmd);
        String secret = JnlpAgentReceiver.SLAVE_SECRET.mac(nodeName);
        EnvVars knownVariables = DockerComputerJNLPConnector.calculateVariablesForVariableSubstitution(nodeName, secret, effectiveJenkinsUrl);
        String configuredArgString = this.getEntryPointArgumentsString();
        String effectiveConfiguredArgString = StringUtils.isNotBlank((String)configuredArgString) ? configuredArgString : DEFAULT_ENTRY_POINT_ARGUMENTS;
        String resolvedArgString = Util.replaceMacro((String)effectiveConfiguredArgString, (Map)knownVariables);
        String[] resolvedArgs = JenkinsUtils.splitAndFilterEmpty(resolvedArgString, "\n");
        cmd.withCmd(resolvedArgs);
        if (StringUtils.isNotBlank((String)this.user)) {
            cmd.withUser(this.user);
        }
    }

    @Override
    public void beforeContainerStarted(DockerAPI api, String workdir, DockerTransientNode node) throws IOException, InterruptedException {
        this.ensureNodeIsKnown(node);
    }

    private static EnvVars calculateVariablesForVariableSubstitution(String nodeName, String secret, String jenkinsUrl) throws IOException, InterruptedException {
        EnvVars knownVariables = new EnvVars();
        Jenkins j = Jenkins.get();
        DockerComputerJNLPConnector.addEnvVars(knownVariables, j.getGlobalNodeProperties());
        for (ArgumentVariables v : ArgumentVariables.values()) {
            DockerComputerJNLPConnector.addEnvVar(knownVariables, v.getName(), switch (v.ordinal()) {
                case 2 -> jenkinsUrl;
                case 1 -> secret;
                case 0 -> nodeName;
                default -> {
                    String msg = "Internal code error: Switch statement is missing \"case " + v.name() + " : argValue = ... ; break;\" code.";
                    throw new RuntimeException(msg);
                }
            });
        }
        return knownVariables;
    }

    @Restricted(value={NoExternalUse.class})
    static enum ArgumentVariables {
        NodeName("NODE_NAME", "The name assigned to this node"),
        Secret("JNLP_SECRET", "The secret that must be passed to agent.jar's -secret argument to pass JNLP authentication."),
        JenkinsUrl("JENKINS_URL", "The Jenkins root URL.");

        private final String name;
        private final String description;

        private ArgumentVariables(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }

    @Extension
    @Symbol(value={"jnlp"})
    public static final class DescriptorImpl
    extends Descriptor<DockerComputerConnector> {
        public Collection<ArgumentVariables> getEntryPointArgumentVariables() {
            return Arrays.asList(ArgumentVariables.values());
        }

        public Collection<String> getDefaultEntryPointArguments() {
            String[] args = JenkinsUtils.splitAndFilterEmpty(DEFAULT_ENTRY_POINT_ARGUMENTS, "\n");
            return Arrays.asList(args);
        }

        public String getDisplayName() {
            return "Connect with JNLP";
        }
    }
}

