/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.connector;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.thoughtworks.xstream.InitializationException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.remoting.Which;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProperty;
import hudson.util.LogTaskListener;
import io.jenkins.docker.DockerTransientNode;
import io.jenkins.docker.client.DockerAPI;
import io.jenkins.docker.connector.DockerDelegatingComputerLauncher;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class DockerComputerConnector
extends AbstractDescribableImpl<DockerComputerConnector> {
    private static final Logger LOGGER = Logger.getLogger(DockerComputerConnector.class.getName());
    private static final TaskListener LOGGER_LISTENER = new LogTaskListener(LOGGER, Level.FINER);
    protected static final File remoting;

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return ((Object)((Object)this)).getClass() == obj.getClass();
    }

    public void beforeContainerCreated(@NonNull DockerAPI api, @NonNull String workdir, @NonNull CreateContainerCmd cmd) throws IOException, InterruptedException {
    }

    public void beforeContainerStarted(@NonNull DockerAPI api, @NonNull String workdir, @NonNull DockerTransientNode node) throws IOException, InterruptedException {
    }

    public void afterContainerStarted(@NonNull DockerAPI api, @NonNull String workdir, @NonNull DockerTransientNode node) throws IOException, InterruptedException {
    }

    protected void ensureWaiting(@NonNull CreateContainerCmd cmd) {
        String[] cmdAlreadySet = cmd.getCmd();
        if (cmdAlreadySet == null || cmdAlreadySet.length == 0) {
            cmd.withCmd(new String[]{"/bin/sh"}).withTty(Boolean.valueOf(true)).withAttachStdin(Boolean.valueOf(false));
        }
    }

    protected void ensureNodeIsKnown(DockerTransientNode node) throws IOException {
        node.robustlyAddToJenkins();
    }

    protected String injectRemotingJar(@NonNull String containerId, @NonNull String workdir, @NonNull DockerClient client) {
        client.copyArchiveToContainerCmd(containerId).withHostResource(remoting.getAbsolutePath()).withRemotePath(workdir).exec();
        return workdir + "/" + remoting.getName();
    }

    @Restricted(value={NoExternalUse.class})
    protected static void addEnvVars(@NonNull EnvVars vars, @Nullable Iterable<? extends NodeProperty<?>> nodeProperties) throws IOException, InterruptedException {
        if (nodeProperties != null) {
            for (NodeProperty<?> nodeProperty : nodeProperties) {
                nodeProperty.buildEnvVars(vars, LOGGER_LISTENER);
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    protected static void addEnvVar(@NonNull EnvVars vars, @NonNull String name, @Nullable Object valueOrNull) {
        vars.put(name, valueOrNull == null ? "" : valueOrNull.toString());
    }

    @NonNull
    public final ComputerLauncher createLauncher(@NonNull DockerAPI api, @NonNull String containerId, @NonNull String workdir, @NonNull TaskListener listener) throws IOException, InterruptedException {
        InspectContainerResponse inspect;
        try (DockerClient client = api.getClient();){
            inspect = client.inspectContainerCmd(containerId).exec();
        }
        ComputerLauncher launcher = this.createLauncher(api, workdir, inspect, listener);
        Boolean running = inspect.getState().getRunning();
        if (Boolean.FALSE.equals(running)) {
            listener.error("Container {} is not running. {}", new Object[]{containerId, inspect.getState().getStatus()});
            throw new IOException("Container is not running.");
        }
        return new DockerDelegatingComputerLauncher(launcher, api, containerId);
    }

    @NonNull
    protected abstract ComputerLauncher createLauncher(@NonNull DockerAPI var1, @NonNull String var2, @NonNull InspectContainerResponse var3, @NonNull TaskListener var4) throws IOException, InterruptedException;

    public static DescriptorExtensionList<DockerComputerConnector, Descriptor<DockerComputerConnector>> all() {
        Jenkins j = Jenkins.get();
        return j.getDescriptorList(DockerComputerConnector.class);
    }

    static {
        try {
            remoting = Which.jarFile(Channel.class);
        }
        catch (IOException e) {
            throw new InitializationException("Failed to resolve path to remoting.jar", (Throwable)e);
        }
    }
}

