/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.connector;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.VersionCmd;
import com.github.dockerjava.api.model.Version;
import com.google.common.base.Joiner;
import com.nirima.jenkins.plugins.docker.utils.JenkinsUtils;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import io.jenkins.docker.DockerTransientNode;
import io.jenkins.docker.client.DockerAPI;
import io.jenkins.docker.client.DockerMultiplexedInputStream;
import io.jenkins.docker.connector.DockerComputerConnector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DockerComputerAttachConnector
extends DockerComputerConnector
implements Serializable {
    @CheckForNull
    private String user;
    @CheckForNull
    private String javaExe;
    @CheckForNull
    private String[] jvmArgs;
    @CheckForNull
    private String[] entryPointCmd;
    private static final String DEFAULT_JAVA_EXE = "java";
    private static final String DEFAULT_JVM_ARGS = "";
    private static final String DEFAULT_ENTRY_POINT_CMD_STRING = "${" + ArgumentVariables.JavaExe.getName() + "}\n${" + ArgumentVariables.JvmArgs.getName() + "}\n-jar\n${" + ArgumentVariables.RemoteFs.getName() + "}/${" + ArgumentVariables.JarName.getName() + "}\n-noReconnect\n-noKeepAlive\n-agentLog\n${" + ArgumentVariables.RemoteFs.getName() + "}/agent.log";

    @DataBoundConstructor
    public DockerComputerAttachConnector() {
    }

    public DockerComputerAttachConnector(String user) {
        this.user = user;
    }

    @CheckForNull
    public String getUser() {
        return Util.fixEmptyAndTrim((String)this.user);
    }

    @DataBoundSetter
    public void setUser(String user) {
        this.user = Util.fixEmptyAndTrim((String)user);
    }

    @CheckForNull
    public String getJavaExe() {
        return Util.fixEmptyAndTrim((String)this.javaExe);
    }

    @DataBoundSetter
    public void setJavaExe(String javaExe) {
        this.javaExe = Util.fixEmptyAndTrim((String)javaExe);
    }

    @NonNull
    public String getEntryPointCmdString() {
        if (this.entryPointCmd == null) {
            return DEFAULT_JVM_ARGS;
        }
        return Joiner.on((String)"\n").join((Object[])this.entryPointCmd);
    }

    @DataBoundSetter
    public void setEntryPointCmdString(String entryPointCmdString) {
        this.setEntryPointCmd(JenkinsUtils.splitAndFilterEmpty(entryPointCmdString, "\n"));
    }

    private void setEntryPointCmd(String[] entryPointCmd) {
        this.entryPointCmd = JenkinsUtils.fixEmpty(entryPointCmd);
    }

    @NonNull
    public String getJvmArgsString() {
        if (this.jvmArgs == null) {
            return DEFAULT_JVM_ARGS;
        }
        return Joiner.on((String)"\n").join((Object[])this.jvmArgs);
    }

    @DataBoundSetter
    public void setJvmArgsString(String jvmArgsString) {
        this.setJvmArgs(JenkinsUtils.splitAndFilterEmpty(jvmArgsString, "\n"));
    }

    private void setJvmArgs(String[] jvmArgs) {
        this.jvmArgs = JenkinsUtils.fixEmpty(jvmArgs);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.entryPointCmd);
        result = 31 * result + Arrays.hashCode(this.jvmArgs);
        result = 31 * result + Objects.hash(this.javaExe, this.user);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DockerComputerAttachConnector other = (DockerComputerAttachConnector)obj;
        return Arrays.equals(this.entryPointCmd, other.entryPointCmd) && Objects.equals(this.javaExe, other.javaExe) && Arrays.equals(this.jvmArgs, other.jvmArgs) && Objects.equals(this.user, other.user);
    }

    public String toString() {
        StringBuilder sb = JenkinsUtils.startToString(this);
        JenkinsUtils.bldToString(sb, "user", this.user);
        JenkinsUtils.bldToString(sb, "javaExe", this.javaExe);
        JenkinsUtils.bldToString(sb, "jvmArgs", this.jvmArgs);
        JenkinsUtils.bldToString(sb, "entryPointCmd", this.entryPointCmd);
        JenkinsUtils.endToString(sb);
        return sb.toString();
    }

    @Override
    public void beforeContainerCreated(DockerAPI api, String workdir, CreateContainerCmd cmd) throws IOException, InterruptedException {
        this.ensureWaiting(cmd);
    }

    @Override
    public void beforeContainerStarted(DockerAPI api, String workdir, DockerTransientNode node) throws IOException, InterruptedException {
        String containerId = node.getContainerId();
        try (DockerClient client = api.getClient();){
            this.injectRemotingJar(containerId, workdir, client);
        }
    }

    @Override
    protected ComputerLauncher createLauncher(DockerAPI api, String workdir, InspectContainerResponse inspect, TaskListener listener) throws IOException, InterruptedException {
        return new DockerAttachLauncher(api, inspect.getId(), this.getUser(), workdir, this.getJavaExe(), this.getJvmArgsString(), this.getEntryPointCmdString());
    }

    private static class DockerAttachLauncher
    extends ComputerLauncher {
        private final DockerAPI api;
        private final String containerId;
        private final String userOrNull;
        private final String remoteFs;
        private final String javaExeOrNull;
        private final String jvmArgsOrEmpty;
        private final String entryPointCmdOrEmpty;

        private DockerAttachLauncher(DockerAPI api, String containerId, String user, String remoteFs, String javaExe, String jvmArgs, String entryPointCmd) {
            this.api = api;
            this.containerId = containerId;
            this.userOrNull = user;
            this.remoteFs = remoteFs;
            this.javaExeOrNull = javaExe;
            this.jvmArgsOrEmpty = jvmArgs;
            this.entryPointCmdOrEmpty = entryPointCmd;
        }

        public void launch(SlaveComputer computer, TaskListener listener) throws IOException, InterruptedException {
            String actualApiVersion;
            String execId;
            PrintStream logger = computer.getListener().getLogger();
            String jenkinsUrl = Jenkins.get().getRootUrl();
            String effectiveJavaExe = StringUtils.isNotBlank((String)this.javaExeOrNull) ? this.javaExeOrNull : DockerComputerAttachConnector.DEFAULT_JAVA_EXE;
            String effectiveJvmArgs = StringUtils.isNotBlank((String)this.jvmArgsOrEmpty) ? this.jvmArgsOrEmpty : DockerComputerAttachConnector.DEFAULT_JVM_ARGS;
            EnvVars knownVariables = DockerAttachLauncher.calculateVariablesForVariableSubstitution(effectiveJavaExe, effectiveJvmArgs, DockerComputerConnector.remoting.getName(), this.remoteFs, jenkinsUrl);
            String effectiveEntryPointCmdString = StringUtils.isNotBlank((String)this.entryPointCmdOrEmpty) ? this.entryPointCmdOrEmpty : DEFAULT_ENTRY_POINT_CMD_STRING;
            String resolvedEntryPointCmdString = Util.replaceMacro((String)effectiveEntryPointCmdString, (Map)knownVariables);
            Object[] resolvedEntryPointCmd = JenkinsUtils.splitAndFilterEmpty(resolvedEntryPointCmdString, "\n");
            logger.println("Connecting to docker container " + this.containerId + ", running command " + Joiner.on((String)" ").join(resolvedEntryPointCmd));
            try (DockerClient client = this.api.getClient();){
                ExecCreateCmd execCmd = client.execCreateCmd(this.containerId).withAttachStdin(Boolean.valueOf(true)).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withTty(Boolean.valueOf(false)).withCmd((String[])resolvedEntryPointCmd);
                if (StringUtils.isNotBlank((String)this.userOrNull)) {
                    execCmd.withUser(this.userOrNull);
                }
                ExecCreateCmdResponse execResponse = (ExecCreateCmdResponse)execCmd.exec();
                execId = execResponse.getId();
                VersionCmd versionCmd = client.versionCmd();
                Version version = (Version)versionCmd.exec();
                actualApiVersion = version.getApiVersion();
            }
            String js = "{ \"Detach\": false, \"Tty\": false }";
            Socket socket = this.api.getSocket();
            OutputStream out = socket.getOutputStream();
            InputStream in = socket.getInputStream();
            PrintWriter w = new PrintWriter(new OutputStreamWriter(out, StandardCharsets.US_ASCII));
            w.println("POST /v" + actualApiVersion + "/exec/" + execId + "/start HTTP/1.1");
            w.println("Host: docker.sock");
            w.println("Content-Type: application/json");
            w.println("Upgrade: tcp");
            w.println("Connection: Upgrade");
            w.println("Content-Length: " + "{ \"Detach\": false, \"Tty\": false }".length());
            w.println();
            w.println("{ \"Detach\": false, \"Tty\": false }");
            w.flush();
            String line = DockerAttachLauncher.readLine(in);
            logger.println(line);
            if (!line.startsWith("HTTP/1.1 101 ")) {
                throw new IOException("Unexpected HTTP response status line " + line);
            }
            while ((line = DockerAttachLauncher.readLine(in)).length() > 0 && line.length() != 0) {
                logger.println(line);
            }
            DockerMultiplexedInputStream demux = new DockerMultiplexedInputStream(in, computer.getDisplayName() + " (" + this.containerId + ")");
            computer.setChannel((InputStream)demux, out, listener, new Channel.Listener(){

                public void onClosed(Channel channel, IOException cause) {
                }
            });
        }

        private static EnvVars calculateVariablesForVariableSubstitution(@NonNull String javaExe, @NonNull String jvmArgs, @NonNull String jarName, @NonNull String remoteFs, @NonNull String jenkinsUrl) throws IOException, InterruptedException {
            EnvVars knownVariables = new EnvVars();
            Jenkins j = Jenkins.get();
            DockerComputerConnector.addEnvVars(knownVariables, j.getGlobalNodeProperties());
            for (ArgumentVariables v : ArgumentVariables.values()) {
                DockerComputerConnector.addEnvVar(knownVariables, v.getName(), switch (v.ordinal()) {
                    case 0 -> javaExe;
                    case 1 -> jvmArgs;
                    case 2 -> jarName;
                    case 3 -> remoteFs;
                    case 4 -> jenkinsUrl;
                    default -> {
                        String msg = "Internal code error: Switch statement is missing \"case " + v.name() + " : argValue = ... ; break;\" code.";
                        throw new RuntimeException(msg);
                    }
                });
            }
            return knownVariables;
        }

        private static String readLine(InputStream in) throws IOException {
            int c;
            StringBuilder s = new StringBuilder();
            while ((c = in.read()) > 0 && c != 13) {
                s.append((char)c);
            }
            in.read();
            return s.toString();
        }
    }

    @Restricted(value={NoExternalUse.class})
    static enum ArgumentVariables {
        JavaExe("JAVA_EXE", "The Java Executable, e.g. java, /usr/bin/java etc."),
        JvmArgs("JVM_ARGS", "Any arguments for the JVM itself, e.g. -Xmx250m."),
        JarName("JAR_NAME", "The name of the jar file the node must run, e.g. agent.jar."),
        RemoteFs("FS_DIR", "The filesystem folder in which the agent process is to be run."),
        JenkinsUrl("JENKINS_URL", "The Jenkins root URL.");

        private final String name;
        private final String description;

        private ArgumentVariables(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }

    @Extension(ordinal=100.0)
    @Symbol(value={"attach"})
    public static class DescriptorImpl
    extends Descriptor<DockerComputerConnector> {
        public String getDefaultJavaExe() {
            return DockerComputerAttachConnector.DEFAULT_JAVA_EXE;
        }

        public String getJavaExeVariableName() {
            return ArgumentVariables.JavaExe.getName();
        }

        public String getDefaultJvmArgs() {
            return DockerComputerAttachConnector.DEFAULT_JVM_ARGS;
        }

        public String getJvmArgsVariableName() {
            return ArgumentVariables.JvmArgs.getName();
        }

        public Collection<ArgumentVariables> getEntryPointCmdVariables() {
            return Arrays.asList(ArgumentVariables.values());
        }

        public Collection<String> getDefaultEntryPointCmd() {
            String[] args = JenkinsUtils.splitAndFilterEmpty(DEFAULT_ENTRY_POINT_CMD_STRING, "\n");
            return Arrays.asList(args);
        }

        public String getDisplayName() {
            return "Attach Docker container";
        }
    }
}

