/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class UsageTrackingCache<K, V> {
    private final Map<K, CacheEntry<K, V>> activeCacheByKey = new HashMap<K, CacheEntry<K, V>>();
    private final Map<V, CacheEntry<K, V>> activeCacheByValue = new IdentityHashMap<V, CacheEntry<K, V>>();
    private final Cache<K, CacheEntry<K, V>> durationCache;

    UsageTrackingCache(long duration, @NonNull TimeUnit unit, final @NonNull ExpiryHandler<K, V> expiryHandler) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        cacheBuilder = cacheBuilder.expireAfterAccess(duration, unit);
        RemovalListener removalHandler = new RemovalListener<K, CacheEntry<K, V>>(){

            public void onRemoval(RemovalNotification<K, CacheEntry<K, V>> notification) {
                Object key = notification.getKey();
                if (!UsageTrackingCache.this.activeCacheByKey.containsKey(key)) {
                    CacheEntry record = (CacheEntry)notification.getValue();
                    Object value = record.getValue();
                    expiryHandler.entryDroppedFromCache(key, value);
                }
            }
        };
        cacheBuilder = cacheBuilder.removalListener(removalHandler);
        this.durationCache = cacheBuilder.build();
    }

    @CheckForNull
    public V getAndIncrementUsage(@NonNull K key) {
        CacheEntry<K, V> activeRecord = this.activeCacheByKey.get(key);
        if (activeRecord != null) {
            activeRecord.incrementUsageCount();
            V value = activeRecord.getValue();
            this.durationCache.cleanUp();
            return value;
        }
        CacheEntry durationRecord = (CacheEntry)this.durationCache.getIfPresent(key);
        if (durationRecord != null) {
            Object value = durationRecord.getValue();
            durationRecord.incrementUsageCount();
            this.activeCacheByKey.put(key, durationRecord);
            this.activeCacheByValue.put((CacheEntry)value, durationRecord);
            this.durationCache.invalidate(key);
            this.durationCache.cleanUp();
            return value;
        }
        this.durationCache.cleanUp();
        return null;
    }

    public void cacheAndIncrementUsage(@NonNull K key, @NonNull V entry) {
        CacheEntry<K, V> record = new CacheEntry<K, V>(key, entry, 1);
        CacheEntry<K, V> oldKeyRecord = this.activeCacheByKey.put(key, record);
        CacheEntry<K, V> oldValueRecord = this.activeCacheByValue.put((CacheEntry<K, V>)entry, (CacheEntry<V, CacheEntry<K, V>>)record);
        if (oldKeyRecord != null || oldValueRecord != null) {
            CacheEntry<K, V> oldRecord = oldKeyRecord != null ? oldKeyRecord : oldValueRecord;
            this.activeCacheByKey.put(key, oldRecord);
            this.activeCacheByValue.put((CacheEntry<K, V>)entry, (CacheEntry<V, CacheEntry<K, V>>)oldRecord);
            throw new IllegalStateException("Cannot cache " + String.valueOf(record) + " because there's already a record " + String.valueOf(oldRecord) + " present in the activeCache.");
        }
    }

    public void decrementUsage(@NonNull V entry) {
        this.durationCache.cleanUp();
        CacheEntry<K, V> record = this.activeCacheByValue.get(entry);
        if (record == null) {
            throw new IllegalStateException("No active record for entry " + String.valueOf(entry));
        }
        boolean stillActive = record.decrementUsageCount();
        if (stillActive) {
            return;
        }
        K key = record.getKey();
        this.activeCacheByKey.remove(key);
        this.activeCacheByValue.remove(entry);
        this.durationCache.put(key, record);
        this.durationCache.cleanUp();
    }

    public static interface ExpiryHandler<K, V> {
        public void entryDroppedFromCache(K var1, V var2);
    }

    private static class CacheEntry<K, V> {
        private final K mKey;
        private final V mValue;
        private int mUsageCount;

        CacheEntry(K key, V value, int usageCount) {
            this.mKey = key;
            this.mValue = value;
            this.mUsageCount = usageCount;
        }

        void incrementUsageCount() {
            ++this.mUsageCount;
        }

        boolean decrementUsageCount() {
            --this.mUsageCount;
            return this.mUsageCount > 0;
        }

        K getKey() {
            return this.mKey;
        }

        V getValue() {
            return this.mValue;
        }

        public String toString() {
            return "CacheEntry[key=" + String.valueOf(this.mKey) + ", value=" + String.valueOf(this.mValue) + ", usageCount=" + this.mUsageCount + "]";
        }
    }
}

