/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.client;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerMultiplexedInputStream
extends InputStream {
    private final InputStream multiplexed;
    private final String name;
    private int next;
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerMultiplexedInputStream.class);

    public DockerMultiplexedInputStream(InputStream in, String streamName) {
        this.multiplexed = in;
        this.name = streamName;
        this.next = 0;
    }

    @Override
    public int read() throws IOException {
        if (!this.readInternal()) {
            return -1;
        }
        int nextByte = this.multiplexed.read();
        if (nextByte >= 0) {
            --this.next;
        }
        return nextByte;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.readInternal()) {
            return -1;
        }
        int bytesRead = this.multiplexed.read(b, off, Math.min(this.next, len));
        if (bytesRead >= 0) {
            this.next -= bytesRead;
        }
        return bytesRead;
    }

    private boolean readInternal() throws IOException {
        block4: while (this.next == 0) {
            int i;
            byte[] header = new byte[8];
            for (int todo = 8; todo > 0; todo -= i) {
                i = this.multiplexed.read(header, 8 - todo, todo);
                if (i >= 0) continue;
                return false;
            }
            int size = ((header[4] & 0xFF) << 24) + ((header[5] & 0xFF) << 16) + ((header[6] & 0xFF) << 8) + (header[7] & 0xFF);
            switch (header[0]) {
                case 1: {
                    this.next = size;
                    break;
                }
                case 2: {
                    String dataAsString;
                    String dataAsTrimmedString;
                    int received;
                    int i2;
                    byte[] payload = new byte[size];
                    for (received = 0; received < size && (i2 = this.multiplexed.read(payload, received, size - received)) >= 0; received += i2) {
                    }
                    if (!LOGGER.isInfoEnabled() || (dataAsTrimmedString = (dataAsString = new String(payload, 0, received, StandardCharsets.UTF_8)).replaceAll("\\s*$", "")).isEmpty()) continue block4;
                    LOGGER.info("stderr from {}: {}", (Object)this.name, (Object)dataAsTrimmedString);
                    break;
                }
                default: {
                    throw new IOException("Unexpected application/vnd.docker.raw-stream frame type " + Arrays.toString(header));
                }
            }
        }
        return true;
    }
}

