/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.client;

import com.github.dockerjava.api.command.CreateContainerCmd;
import java.util.ArrayList;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class DockerEnvUtils {
    private DockerEnvUtils() {
    }

    @Restricted(value={NoExternalUse.class})
    public static void addEnvToCmd(String envName, String envValue, CreateContainerCmd cmd) {
        String[] oldEnvsOrNull = cmd.getEnv();
        String[] oldEnvs = oldEnvsOrNull == null ? new String[]{} : oldEnvsOrNull;
        ArrayList<Object> envs = new ArrayList<Object>(oldEnvs.length);
        for (String oldEnv : oldEnvs) {
            int equalsIndex = oldEnv.indexOf(61);
            if (equalsIndex < 0) {
                envs.add(oldEnv);
                continue;
            }
            String oldEnvName = oldEnv.substring(0, equalsIndex);
            if (oldEnvName.equals(envName)) continue;
            envs.add(oldEnv);
        }
        envs.add(envName + "=" + envValue);
        String[] newEnvs = envs.toArray(new String[0]);
        cmd.withEnv(newEnvs);
    }
}

