/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.client;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.VersionCmd;
import com.github.dockerjava.api.model.Version;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.SSLConfig;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.nirima.jenkins.plugins.docker.utils.JenkinsUtils;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.docker.client.DockerClientParameters;
import io.jenkins.docker.client.DockerServerCredentialsSSLConfig;
import io.jenkins.docker.client.UsageTrackingCache;
import io.jenkins.dockerjavaapi.client.DelegatingDockerClient;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerCredentials;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerEndpoint;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerAPI
extends AbstractDescribableImpl<DockerAPI> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerAPI.class);
    private DockerServerEndpoint dockerHost;
    private int connectTimeout;
    private int readTimeout;
    private String apiVersion;
    private String hostname;
    private transient Boolean _isSwarm;
    private static final UsageTrackingCache<DockerClientParameters, SharableDockerClient> CLIENT_CACHE;

    @DataBoundConstructor
    public DockerAPI(DockerServerEndpoint dockerHost) {
        this.dockerHost = dockerHost;
    }

    public DockerAPI(DockerServerEndpoint dockerHost, int connectTimeout, int readTimeout, String apiVersion, String hostname) {
        this.dockerHost = dockerHost;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.apiVersion = apiVersion;
        this.hostname = hostname;
    }

    public DockerServerEndpoint getDockerHost() {
        return this.dockerHost;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @DataBoundSetter
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    @DataBoundSetter
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    @DataBoundSetter
    public void setApiVersion(String apiVersion) {
        this.apiVersion = StringUtils.trimToNull((String)apiVersion);
    }

    public String getHostname() {
        return this.hostname;
    }

    @DataBoundSetter
    public void setHostname(String hostname) {
        this.hostname = StringUtils.trimToNull((String)hostname);
    }

    public boolean isSwarm() {
        if (this._isSwarm == null) {
            try (DockerClient client = this.getClient();){
                Version remoteVersion = (Version)client.versionCmd().exec();
                this._isSwarm = remoteVersion.getVersion().startsWith("swarm");
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return this._isSwarm;
    }

    public DockerClient getClient() {
        return this.getClient(this.readTimeout);
    }

    public DockerClient getClient(int activityTimeoutInSeconds) {
        return DockerAPI.getOrMakeClient(this.dockerHost.getUri(), this.dockerHost.getCredentialsId(), activityTimeoutInSeconds, this.connectTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DockerClient getOrMakeClient(String dockerUri, String credentialsId, int readTimeout, int connectTimeout) {
        Integer readTimeoutInMillisecondsOrNull = readTimeout > 0 ? Integer.valueOf(readTimeout * 1000) : null;
        Integer connectTimeoutInMillisecondsOrNull = connectTimeout > 0 ? Integer.valueOf(connectTimeout * 1000) : null;
        DockerClientParameters cacheKey = new DockerClientParameters(dockerUri, credentialsId, readTimeoutInMillisecondsOrNull, connectTimeoutInMillisecondsOrNull);
        UsageTrackingCache<DockerClientParameters, SharableDockerClient> usageTrackingCache = CLIENT_CACHE;
        synchronized (usageTrackingCache) {
            SharableDockerClient client = CLIENT_CACHE.getAndIncrementUsage(cacheKey);
            if (client == null) {
                client = DockerAPI.makeClient(dockerUri, credentialsId, readTimeoutInMillisecondsOrNull, connectTimeoutInMillisecondsOrNull);
                LOGGER.info("Cached connection {} to {}", (Object)client, (Object)cacheKey);
                CLIENT_CACHE.cacheAndIncrementUsage(cacheKey, client);
            }
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SharableDockerClient makeClient(String dockerUri, String credentialsId, Integer readTimeoutInMillisecondsOrNull, Integer connectTimeoutInMillisecondsOrNull) {
        SharableDockerClient sharableDockerClient;
        ApacheDockerHttpClient httpClient = null;
        DockerClient actualClient = null;
        try {
            httpClient = new ApacheDockerHttpClient.Builder().dockerHost(URI.create(dockerUri)).sslConfig((com.github.dockerjava.transport.SSLConfig)DockerAPI.toSSlConfig(credentialsId)).connectionTimeout(connectTimeoutInMillisecondsOrNull != null ? Duration.ofMillis(connectTimeoutInMillisecondsOrNull.intValue()) : null).responseTimeout(readTimeoutInMillisecondsOrNull != null ? Duration.ofMillis(readTimeoutInMillisecondsOrNull.intValue()) : null).build();
            actualClient = DockerClientBuilder.getInstance().withDockerHttpClient((DockerHttpClient)httpClient).build();
            SharableDockerClient multiUsageClient = new SharableDockerClient(actualClient);
            httpClient = null;
            actualClient = null;
            sharableDockerClient = multiUsageClient;
        }
        catch (Throwable throwable) {
            DockerAPI.closeAndLogAnyExceptions(httpClient);
            DockerAPI.closeAndLogAnyExceptions(actualClient);
            throw throwable;
        }
        DockerAPI.closeAndLogAnyExceptions((Closeable)httpClient);
        DockerAPI.closeAndLogAnyExceptions((Closeable)actualClient);
        return sharableDockerClient;
    }

    private static void closeAndLogAnyExceptions(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (Exception ex) {
                LOGGER.error("Unable to close {}", (Object)resource.toString(), (Object)ex);
            }
        }
    }

    private static SSLConfig toSSlConfig(String credentialsId) {
        if (credentialsId == null) {
            return null;
        }
        DockerServerCredentials credentials = (DockerServerCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(DockerServerCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, List.of()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        return credentials == null ? null : new DockerServerCredentialsSSLConfig(credentials);
    }

    public Socket getSocket() throws IOException {
        try {
            URI uri = new URI(this.dockerHost.getUri());
            if ("unix".equals(uri.getScheme())) {
                String socketFileName = uri.getPath();
                AFUNIXSocketAddress unix = AFUNIXSocketAddress.of((File)new File(socketFileName));
                AFUNIXSocket socket = AFUNIXSocket.newInstance();
                socket.connect((SocketAddress)unix);
                return socket;
            }
            SSLConfig sslConfig = DockerAPI.toSSlConfig(this.dockerHost.getCredentialsId());
            if (sslConfig != null) {
                return sslConfig.getSSLContext().getSocketFactory().createSocket(uri.getHost(), uri.getPort());
            }
            return new Socket(uri.getHost(), uri.getPort());
        }
        catch (Exception e) {
            throw new IOException("Failed to create a Socker for docker URI " + this.dockerHost.getUri(), e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DockerAPI dockerAPI = (DockerAPI)((Object)o);
        if (this.connectTimeout != dockerAPI.connectTimeout) {
            return false;
        }
        if (this.readTimeout != dockerAPI.readTimeout) {
            return false;
        }
        if (!Objects.equals(this.dockerHost, dockerAPI.dockerHost)) {
            return false;
        }
        if (!Objects.equals(this.apiVersion, dockerAPI.apiVersion)) {
            return false;
        }
        return Objects.equals(this.hostname, dockerAPI.hostname);
    }

    public int hashCode() {
        int result = this.dockerHost != null ? this.dockerHost.hashCode() : 0;
        result = 31 * result + this.connectTimeout;
        result = 31 * result + this.readTimeout;
        result = 31 * result + (this.apiVersion != null ? this.apiVersion.hashCode() : 0);
        result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = JenkinsUtils.startToString((Object)this);
        JenkinsUtils.bldToString(sb, "dockerHost", this.dockerHost);
        JenkinsUtils.bldToString(sb, "connectTimeout", this.connectTimeout);
        JenkinsUtils.bldToString(sb, "readTimeout", this.readTimeout);
        JenkinsUtils.bldToString(sb, "apiVersion", this.apiVersion);
        JenkinsUtils.bldToString(sb, "hostname", this.hostname);
        JenkinsUtils.endToString(sb);
        return sb.toString();
    }

    static {
        UsageTrackingCache.ExpiryHandler<DockerClientParameters, SharableDockerClient> expiryHandler = new UsageTrackingCache.ExpiryHandler<DockerClientParameters, SharableDockerClient>(){

            @Override
            public void entryDroppedFromCache(DockerClientParameters cacheKey, SharableDockerClient client) {
                try {
                    client.reallyClose();
                    LOGGER.info("Dropped connection {} to {}", (Object)client, (Object)cacheKey);
                }
                catch (IOException ex) {
                    LOGGER.error("Dropped connection " + String.valueOf((Object)client) + " to " + String.valueOf(cacheKey) + " but failed to close it:", (Throwable)ex);
                }
            }
        };
        CLIENT_CACHE = new UsageTrackingCache<DockerClientParameters, SharableDockerClient>(5L, TimeUnit.MINUTES, expiryHandler);
    }

    private static class SharableDockerClient
    extends DelegatingDockerClient {
        public SharableDockerClient(DockerClient delegate) {
            super(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            UsageTrackingCache<DockerClientParameters, SharableDockerClient> usageTrackingCache = CLIENT_CACHE;
            synchronized (usageTrackingCache) {
                CLIENT_CACHE.decrementUsage(this);
            }
        }

        public void reallyClose() throws IOException {
            this.getDelegate().close();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DockerAPI> {
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String uri) {
            DockerServerEndpoint.DescriptorImpl descriptor = (DockerServerEndpoint.DescriptorImpl)Jenkins.get().getDescriptorOrDie(DockerServerEndpoint.class);
            return descriptor.doFillCredentialsIdItems(context, uri);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item context, @QueryParameter String uri, @QueryParameter String value) {
            String credentialsOrNull = StringUtils.trimToNull((String)value);
            if (credentialsOrNull == null || this.credentialsAreValid(context, uri, credentialsOrNull)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)("Invalid credentials for URI " + uri));
        }

        public FormValidation doCheckConnectionTimeout(@QueryParameter String value) {
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        public FormValidation doCheckReadTimeout(@QueryParameter String value) {
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        @RequirePOST
        public FormValidation doTestConnection(@AncestorInPath Item context, @QueryParameter String uri, @QueryParameter String credentialsId, @QueryParameter String apiVersion, @QueryParameter int connectTimeout, @QueryParameter int readTimeout) {
            FormValidation formValidation;
            block9: {
                DescriptorImpl.throwIfNoPermission(context);
                FormValidation credentialsIdCheckResult = this.doCheckCredentialsId(context, uri, credentialsId);
                if (credentialsIdCheckResult != FormValidation.ok()) {
                    return FormValidation.error((String)"Invalid credentials");
                }
                DockerServerEndpoint dsep = new DockerServerEndpoint(uri, credentialsId);
                DockerAPI dapi = new DockerAPI(dsep, connectTimeout, readTimeout, apiVersion, null);
                DockerClient dc = dapi.getClient();
                try {
                    VersionCmd vc = dc.versionCmd();
                    Version v = (Version)vc.exec();
                    String actualVersion = v.getVersion();
                    String actualApiVersion = v.getApiVersion();
                    formValidation = FormValidation.ok((String)("Version = " + actualVersion + ", API Version = " + actualApiVersion));
                    if (dc == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (dc != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        return FormValidation.error((Throwable)e, (String)e.getMessage());
                    }
                }
                dc.close();
            }
            return formValidation;
        }

        private boolean credentialsAreValid(Item context, String uri, String credentialsId) {
            ListBoxModel availableCredentials = this.doFillCredentialsIdItems(context, uri);
            return DescriptorImpl.optionIsAvailable(credentialsId, availableCredentials);
        }

        private static boolean optionIsAvailable(String optionValue, ListBoxModel available) {
            for (ListBoxModel.Option o : available) {
                if (!(o.value == null ? optionValue == null : optionValue != null && optionValue.equals(o.value))) continue;
                return true;
            }
            return false;
        }

        private static void throwIfNoPermission(Item context) {
            if (context != null) {
                context.checkPermission(Item.CONFIGURE);
            } else {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            }
        }
    }
}

