/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker;

import com.nirima.jenkins.plugins.docker.DockerCloud;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Label;
import hudson.model.LoadStatistics;
import hudson.model.Queue;
import hudson.model.queue.QueueListener;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class FastNodeProvisionerStrategy
extends NodeProvisioner.Strategy {
    private static final Logger LOGGER = Logger.getLogger(FastNodeProvisionerStrategy.class.getName());

    @NonNull
    public NodeProvisioner.StrategyDecision apply(@NonNull NodeProvisioner.StrategyState state) {
        if (Jenkins.get().isQuietingDown()) {
            return NodeProvisioner.StrategyDecision.CONSULT_REMAINING_STRATEGIES;
        }
        for (Cloud cloud : Jenkins.get().clouds) {
            NodeProvisioner.StrategyDecision decision;
            if (!(cloud instanceof DockerCloud) || (decision = this.applyToCloud(state, (DockerCloud)cloud)) != NodeProvisioner.StrategyDecision.PROVISIONING_COMPLETED) continue;
            return decision;
        }
        return NodeProvisioner.StrategyDecision.CONSULT_REMAINING_STRATEGIES;
    }

    private NodeProvisioner.StrategyDecision applyToCloud(@NonNull NodeProvisioner.StrategyState state, DockerCloud cloud) {
        Label label = state.getLabel();
        if (!cloud.canProvision(label)) {
            return NodeProvisioner.StrategyDecision.CONSULT_REMAINING_STRATEGIES;
        }
        LoadStatistics.LoadStatisticsSnapshot snapshot = state.getSnapshot();
        LOGGER.log(Level.FINEST, "Available executors={0}, connecting={1}, planned={2}", new Object[]{snapshot.getAvailableExecutors(), snapshot.getConnectingExecutors(), state.getPlannedCapacitySnapshot()});
        int availableCapacity = snapshot.getAvailableExecutors() + snapshot.getConnectingExecutors() + state.getPlannedCapacitySnapshot();
        int currentDemand = snapshot.getQueueLength();
        LOGGER.log(Level.FINE, "Available capacity={0}, currentDemand={1}", new Object[]{availableCapacity, currentDemand});
        if (availableCapacity < currentDemand) {
            Collection<NodeProvisioner.PlannedNode> plannedNodes = cloud.provision(label, currentDemand - availableCapacity);
            LOGGER.log(Level.FINE, "Planned {0} new nodes", plannedNodes.size());
            state.recordPendingLaunches(plannedNodes);
            LOGGER.log(Level.FINE, "After provisioning, available capacity={0}, currentDemand={1}", new Object[]{availableCapacity += plannedNodes.size(), currentDemand});
        }
        if (availableCapacity >= currentDemand) {
            LOGGER.log(Level.FINE, "Provisioning completed");
            return NodeProvisioner.StrategyDecision.PROVISIONING_COMPLETED;
        }
        LOGGER.log(Level.FINE, "Provisioning not complete, consulting remaining strategies");
        return NodeProvisioner.StrategyDecision.CONSULT_REMAINING_STRATEGIES;
    }

    @Extension
    public static class FastProvisionning
    extends QueueListener {
        public void onEnterBuildable(Queue.BuildableItem item) {
            Jenkins jenkins = Jenkins.get();
            Label label = item.getAssignedLabel();
            for (Cloud cloud : jenkins.clouds) {
                if (!(cloud instanceof DockerCloud) || !cloud.canProvision(label)) continue;
                NodeProvisioner provisioner = label == null ? jenkins.unlabeledNodeProvisioner : label.nodeProvisioner;
                provisioner.suggestReviewNow();
            }
        }
    }
}

