/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.exception.ConflictException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.exception.NotModifiedException;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerOfflineCause;
import com.nirima.jenkins.plugins.docker.strategy.DockerOnceRetentionStrategy;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.OfflineCause;
import io.jenkins.docker.DockerComputer;
import io.jenkins.docker.client.DockerAPI;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedItem;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerTransientNode
extends AbstractCloudSlave
implements TrackedItem {
    private static final long serialVersionUID = 1349729340506926183L;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DockerTransientNode.class.getName());
    private final String containerId;
    private transient DockerAPI dockerAPI;
    private boolean removeVolumes;
    private int stopTimeout = 10;
    private String cloudId;
    private ProvisioningActivity.Id provisioningId;
    private AtomicBoolean acceptingTasks = new AtomicBoolean(true);
    private transient boolean containerStopped;
    private transient boolean containerRemoved;

    @Deprecated
    public DockerTransientNode(@NonNull String nodeName, @NonNull String containerId, String workdir, ComputerLauncher launcher) throws Descriptor.FormException, IOException {
        this(nodeName, containerId, workdir);
        this.setLauncher(launcher);
    }

    public DockerTransientNode(@NonNull String nodeName, @NonNull String containerId, String workdir) throws Descriptor.FormException, IOException {
        super(nodeName, workdir, null);
        this.containerId = containerId;
        this.setNumExecutors(1);
        this.setMode(Node.Mode.EXCLUSIVE);
        this.setRetentionStrategy(new DockerOnceRetentionStrategy(10));
    }

    public boolean isAcceptingTasks() {
        return this.acceptingTasks == null || this.acceptingTasks.get();
    }

    public void setAcceptingTasks(boolean acceptingTasks) {
        this.acceptingTasks.set(acceptingTasks);
    }

    @NonNull
    public String getContainerId() {
        return this.containerId;
    }

    public void setDockerAPI(DockerAPI dockerAPI) {
        this.dockerAPI = dockerAPI;
    }

    public DockerAPI getDockerAPI() {
        DockerCloud cloud;
        if (this.dockerAPI == null && (cloud = this.getCloud()) != null) {
            this.dockerAPI = cloud.getDockerApi();
        }
        return this.dockerAPI;
    }

    public String getDisplayName() {
        if (this.cloudId != null) {
            return this.getNodeName() + " on " + this.cloudId;
        }
        return this.getNodeName();
    }

    public boolean isRemoveVolumes() {
        return this.removeVolumes;
    }

    public void setRemoveVolumes(boolean removeVolumes) {
        this.removeVolumes = removeVolumes;
    }

    public int getStopTimeout() {
        return this.stopTimeout;
    }

    public void setStopTimeout(int timeout) {
        this.stopTimeout = timeout;
    }

    public String getCloudId() {
        return this.cloudId;
    }

    public void setCloudId(String cloudId) {
        this.cloudId = cloudId;
    }

    public ProvisioningActivity.Id getProvisioningId() {
        return this.provisioningId;
    }

    public void setProvisioningId(ProvisioningActivity.Id provisioningId) {
        this.provisioningId = provisioningId.named(this.getNodeName());
    }

    public DockerComputer createComputer() {
        return new DockerComputer(this);
    }

    @Nullable
    public ProvisioningActivity.Id getId() {
        return this.provisioningId;
    }

    @Restricted(value={NoExternalUse.class})
    public void _terminate(TaskListener listener) {
        ILogger tl = DockerTransientNode.createILoggerForTaskListener(listener);
        try {
            this.terminate(tl);
        }
        catch (Throwable ex) {
            tl.error("Failure while terminating '" + this.name + "':", ex);
        }
    }

    private static ILogger createILoggerForTaskListener(final TaskListener listener) {
        ILogger tl = new ILogger(){

            @Override
            public void println(String msg) {
                listener.getLogger().println(msg);
                LOGGER.info(msg);
            }

            @Override
            public void error(String msg, Throwable ex) {
                listener.error(msg, new Object[]{ex});
                LOGGER.error(msg, ex);
            }
        };
        return tl;
    }

    @Restricted(value={NoExternalUse.class})
    public void terminate(Logger logger) {
        ILogger tl = DockerTransientNode.createILoggerForSLF4JLogger(logger);
        try {
            this.terminate(tl);
        }
        catch (Throwable ex) {
            tl.error("Failure while terminating '" + this.name + "':", ex);
        }
    }

    private static ILogger createILoggerForSLF4JLogger(final Logger logger) {
        ILogger tl = new ILogger(){

            @Override
            public void println(String msg) {
                logger.info(msg);
            }

            @Override
            public void error(String msg, Throwable ex) {
                logger.error(msg, ex);
            }
        };
        return tl;
    }

    private void terminate(ILogger logger) {
        try {
            Computer computer = this.toComputer();
            if (computer != null && !(computer.getOfflineCause() instanceof DockerOfflineCause)) {
                computer.disconnect((OfflineCause)new DockerOfflineCause());
                logger.println("Disconnected computer for node '" + this.name + "'.");
            }
        }
        catch (Exception ex) {
            logger.error("Can't disconnect computer for node '" + this.name + "' due to exception:", ex);
        }
        String ourContainerId = this.getContainerId();
        Computer.threadPoolForRemoting.submit(() -> {
            DockerTransientNode dockerTransientNode = this;
            synchronized (dockerTransientNode) {
                DockerAPI api;
                if (this.containerRemoved) {
                    return;
                }
                try {
                    api = this.getDockerAPI();
                }
                catch (RuntimeException ex) {
                    logger.error("Unable to stop and remove container '" + ourContainerId + "' for node '" + this.name + "' due to exception:", ex);
                    return;
                }
                boolean[] newValues = DockerTransientNode.stopAndRemoveContainer(api, logger, "for node '" + this.name + "'", this.removeVolumes, this.stopTimeout, ourContainerId, this.containerStopped);
                this.containerStopped = newValues[0];
                this.containerRemoved = newValues[1];
            }
        });
        try {
            Jenkins.get().removeNode((Node)this);
            logger.println("Removed Node for node '" + this.name + "'.");
        }
        catch (IOException ex) {
            logger.error("Failed to remove Node for node '" + this.name + "' due to exception:", ex);
        }
    }

    private static boolean[] stopAndRemoveContainer(DockerAPI api, ILogger logger, String containerDescription, boolean removeVolumes, int stopTimeout, String containerId, boolean containerAlreadyStopped) {
        DockerClient client;
        boolean containerNowStopped = containerAlreadyStopped;
        boolean containerNowRemoved = false;
        try {
            client = api.getClient();
            try {
                if (!containerNowStopped) {
                    client.stopContainerCmd(containerId).withTimeout(Integer.valueOf(stopTimeout > 0 ? stopTimeout : 10)).exec();
                    containerNowStopped = true;
                    logger.println("Stopped container '" + containerId + "' " + containerDescription + ".");
                }
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        catch (NotFoundException handledByCode) {
            logger.println("Can't stop container '" + containerId + "' " + containerDescription + " as it does not exist.");
            containerNowStopped = true;
            containerNowRemoved = true;
        }
        catch (NotModifiedException handledByCode) {
            logger.println("Container '" + containerId + "' already stopped" + containerDescription + ".");
            containerNowStopped = true;
        }
        catch (Exception ex) {
            logger.error("Failed to stop container '" + containerId + "' " + containerDescription + " due to exception:", ex);
        }
        try {
            client = api.getClient();
            try {
                if (!containerNowRemoved) {
                    client.removeContainerCmd(containerId).withRemoveVolumes(Boolean.valueOf(removeVolumes)).exec();
                    containerNowRemoved = true;
                    logger.println("Removed container '" + containerId + "' " + containerDescription + ".");
                }
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        catch (NotFoundException handledByCode) {
            logger.println("Container '" + containerId + "' already gone " + containerDescription + ".");
            containerNowRemoved = true;
        }
        catch (ConflictException handledByCode) {
            logger.println("Container '" + containerId + "' removal already in progress.");
            containerNowRemoved = true;
        }
        catch (Exception ex) {
            logger.error("Failed to remove container '" + containerId + "' " + containerDescription + " due to exception:", ex);
        }
        return new boolean[]{containerNowStopped, containerNowRemoved};
    }

    @Restricted(value={NoExternalUse.class})
    public static boolean stopAndRemoveContainer(DockerAPI api, Logger logger, String containerDescription, boolean removeVolumes, String containerId, boolean containerAlreadyStopped) {
        ILogger tl = DockerTransientNode.createILoggerForSLF4JLogger(logger);
        boolean[] containerState = DockerTransientNode.stopAndRemoveContainer(api, tl, containerDescription, removeVolumes, 10, containerId, containerAlreadyStopped);
        return containerState[1];
    }

    public DockerCloud getCloud() {
        if (this.cloudId == null) {
            return null;
        }
        Cloud cloud = Jenkins.get().getCloud(this.cloudId);
        if (cloud == null) {
            throw new RuntimeException("Failed to retrieve Cloud " + this.cloudId);
        }
        if (!(cloud instanceof DockerCloud)) {
            throw new RuntimeException(this.cloudId + " is not a DockerCloud, it's a " + cloud.getClass().toString());
        }
        return (DockerCloud)cloud;
    }

    @Restricted(value={NoExternalUse.class})
    public void robustlyAddToJenkins() throws IOException {
        Jenkins jenkins = Jenkins.get();
        int maxAttempts = 10;
        int attempt = 1;
        while (true) {
            try {
                jenkins.addNode((Node)this);
                return;
            }
            catch (IOException | RuntimeException ex) {
                if (attempt > 10) {
                    throw ex;
                }
                long delayInMilliseconds = 10L * (long)attempt;
                try {
                    Thread.sleep(delayInMilliseconds);
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                ++attempt;
                continue;
            }
            break;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public void robustlyRemoveFromJenkins() throws IOException {
        Jenkins jenkins = Jenkins.get();
        jenkins.removeNode((Node)this);
    }

    private static interface ILogger {
        public void println(String var1);

        public void error(String var1, Throwable var2);
    }

    @Extension
    public static final class DockerTransientNodeDescriptor
    extends Slave.SlaveDescriptor {
        public String getDisplayName() {
            return "Docker Agent";
        }

        public boolean isInstantiable() {
            return false;
        }
    }
}

