/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker;

import com.nirima.jenkins.plugins.docker.DockerCloud;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.EnvVars;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import io.jenkins.docker.DockerTransientNode;
import io.jenkins.docker.client.DockerAPI;
import java.io.IOException;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedItem;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerEndpoint;

public class DockerComputer
extends AbstractCloudComputer<DockerTransientNode>
implements TrackedItem {
    public DockerComputer(DockerTransientNode node) {
        super((AbstractCloudSlave)node);
    }

    @CheckForNull
    public DockerCloud getCloud() {
        DockerTransientNode nodeOrNull = (DockerTransientNode)this.getNode();
        return nodeOrNull == null ? null : nodeOrNull.getCloud();
    }

    @CheckForNull
    public String getContainerId() {
        DockerTransientNode nodeOrNull = (DockerTransientNode)this.getNode();
        return nodeOrNull == null ? null : nodeOrNull.getContainerId();
    }

    @CheckForNull
    public String getCloudId() {
        DockerTransientNode nodeOrNull = (DockerTransientNode)this.getNode();
        return nodeOrNull == null ? null : nodeOrNull.getCloudId();
    }

    public EnvVars getEnvironment() throws IOException, InterruptedException {
        DockerCloud cloudOrNull;
        EnvVars variables = super.getEnvironment();
        String containerIdOrNull = this.getContainerId();
        if (containerIdOrNull != null) {
            variables.put("DOCKER_CONTAINER_ID", containerIdOrNull);
        }
        if ((cloudOrNull = this.getCloud()) != null && cloudOrNull.isExposeDockerHost()) {
            variables.put("JENKINS_CLOUD_ID", cloudOrNull.name);
            DockerAPI dockerApi = cloudOrNull.getDockerApi();
            DockerServerEndpoint dockerHost = dockerApi.getDockerHost();
            String dockerHostUriOrNull = dockerHost.getUri();
            if (dockerHostUriOrNull != null) {
                variables.put("DOCKER_HOST", dockerHostUriOrNull);
            }
        }
        return variables;
    }

    public String toString() {
        return "DockerComputer{name='" + super.getName() + "', node='" + this.nodeName + "'}";
    }

    @Nullable
    public ProvisioningActivity.Id getId() {
        DockerTransientNode nodeOrNull = (DockerTransientNode)this.getNode();
        return nodeOrNull == null ? null : nodeOrNull.getId();
    }
}

