/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.utils;

import com.trilead.ssh2.Connection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PortUtils.class);

    public static ConnectionCheck connectionCheck(String host, int port) {
        return new ConnectionCheck(host, port);
    }

    public static ConnectionCheck connectionCheck(InetSocketAddress address) {
        return new ConnectionCheck(address.getHostString(), address.getPort());
    }

    @Restricted(value={NoExternalUse.class})
    public static class ConnectionCheck {
        private final String host;
        private final int port;
        protected static final int DEFAULT_RETRIES = 10;
        private int retries = 10;
        protected static final int DEFAULT_RETRY_DELAY_SECONDS = 2;
        private long retryDelay = TimeUnit.SECONDS.toMillis(2L);

        private ConnectionCheck(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public ConnectionCheck withRetries(int numberOfRetries) {
            this.retries = numberOfRetries;
            return this;
        }

        public ConnectionCheck withEveryRetryWaitFor(int time, TimeUnit units) {
            this.retryDelay = units.toMillis(time);
            return this;
        }

        public ConnectionCheckSSH useSSH() {
            return new ConnectionCheckSSH(this);
        }

        public boolean executeOnce() {
            boolean bl;
            Socket ignored = new Socket(this.host, this.port);
            try {
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException handledByCode) {
                    return false;
                }
            }
            ignored.close();
            return bl;
        }

        public boolean execute() throws InterruptedException {
            LOGGER.trace("Testing connectivity to {} port {}", (Object)this.host, (Object)this.port);
            for (int i = 1; i <= this.retries; ++i) {
                if (this.executeOnce()) {
                    return true;
                }
                Thread.sleep(this.retryDelay);
            }
            if (this.executeOnce()) {
                return true;
            }
            LOGGER.warn("Could not connect to {} port {}. Are you sure this location is contactable from Jenkins?", (Object)this.host, (Object)this.port);
            return false;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static class ConnectionCheckSSH {
        private final ConnectionCheck parent;
        private int sshTimeoutMillis = (int)TimeUnit.SECONDS.toMillis(2L);

        ConnectionCheckSSH(ConnectionCheck connectionCheck) {
            this.parent = connectionCheck;
        }

        public ConnectionCheckSSH withSSHTimeout(int time, TimeUnit units) {
            this.sshTimeoutMillis = (int)units.toMillis(time);
            return this;
        }

        public boolean execute() throws InterruptedException {
            int thisTryNumber;
            if (!this.parent.execute()) {
                throw new IllegalStateException(String.format("Port %d is not opened to connect to", this.parent.port));
            }
            int retries = Math.max(0, this.parent.retries);
            long retryDelay = this.parent.retryDelay;
            int totalTriesIntended = retries + 1;
            for (thisTryNumber = 1; thisTryNumber <= retries; ++thisTryNumber) {
                if (this.executeOnce(thisTryNumber, totalTriesIntended)) {
                    return true;
                }
                Thread.sleep(retryDelay);
            }
            return this.executeOnce(thisTryNumber, totalTriesIntended);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeOnce(int thisTryNumber, int totalTriesIntended) {
            try (Connection sshConnection = new Connection(this.parent.host, this.parent.port);){
                sshConnection.connect(null, this.sshTimeoutMillis, this.sshTimeoutMillis, this.sshTimeoutMillis);
                LOGGER.info("SSH port is open on {}:{}", (Object)this.parent.host, (Object)this.parent.port);
                boolean bl = true;
                return bl;
            }
        }
    }
}

