/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.utils;

import com.google.common.base.Splitter;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Node;
import hudson.model.Run;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import io.jenkins.docker.DockerTransientNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.main.modules.instance_identity.InstanceIdentity;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(value={NoExternalUse.class})
public class JenkinsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JenkinsUtils.class);
    private static String _id;

    @Restricted(value={NoExternalUse.class})
    public static Optional<DockerCloud> getCloudForBuild(AbstractBuild build) {
        Node node = build.getBuiltOn();
        if (node instanceof DockerTransientNode) {
            return Optional.of(((DockerTransientNode)node).getCloud());
        }
        return Optional.empty();
    }

    @Restricted(value={NoExternalUse.class})
    public static Optional<DockerCloud> getCloudForChannel(VirtualChannel channel) {
        if (channel instanceof Channel) {
            Channel c = (Channel)channel;
            Node node = Jenkins.get().getNode(c.getName());
            if (node instanceof DockerTransientNode) {
                return Optional.of(((DockerTransientNode)node).getCloud());
            }
        }
        return Optional.empty();
    }

    @Restricted(value={NoExternalUse.class})
    public static Optional<DockerCloud> getCloudThatWeBuiltOn(Run<?, ?> build, Launcher launcher) {
        Optional<DockerCloud> cloud = build instanceof AbstractBuild ? JenkinsUtils.getCloudForBuild((AbstractBuild)build) : JenkinsUtils.getCloudForChannel(launcher.getChannel());
        return cloud;
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public static DockerCloud getCloudByNameOrThrow(String serverName) {
        try {
            DockerCloud resultOrNull = DockerCloud.getCloudByName(serverName);
            if (resultOrNull != null) {
                return resultOrNull;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        throw new IllegalArgumentException("No " + DockerCloud.class.getSimpleName() + " with name '" + serverName + "'.  Known names are " + String.valueOf(JenkinsUtils.getServerNames()));
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public static List<String> getServerNames() {
        return DockerCloud.instances().stream().map(cloud -> cloud == null ? "" : cloud.getDisplayName()).collect(Collectors.toList());
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public static String getInstanceId() {
        try {
            if (_id == null) {
                _id = Util.getDigestOf((InputStream)new ByteArrayInputStream(InstanceIdentity.get().getPublic().getEncoded()));
            }
        }
        catch (IOException e) {
            LOG.error("Could not get Jenkins instance ID.", (Throwable)e);
            _id = "";
        }
        return _id;
    }

    @Restricted(value={NoExternalUse.class})
    public static void setTestInstanceId(String id) {
        _id = id;
    }

    @Restricted(value={NoExternalUse.class})
    public static String getSystemPropertyString(String key, String defaultValue) {
        String value = System.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Restricted(value={NoExternalUse.class})
    public static Long getSystemPropertyLong(String key, Long defaultValue) {
        String value = JenkinsUtils.getSystemPropertyString(key, null);
        if (value == null) {
            return defaultValue;
        }
        Long longValue = null;
        try {
            longValue = Long.decode(value);
        }
        catch (NumberFormatException e) {
            LOG.warn("System property {} is attempted to be read as type Long, but value '{}' cannot be parsed as a number", new Object[]{key, value, e});
            return defaultValue;
        }
        return longValue;
    }

    @Restricted(value={NoExternalUse.class})
    public static boolean getSystemPropertyBoolean(String key, boolean defaultValue) {
        String value = JenkinsUtils.getSystemPropertyString(key, null);
        if (value == null) {
            return defaultValue;
        }
        boolean booleanValue = false;
        booleanValue = Boolean.parseBoolean(value);
        return booleanValue;
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public static <T> T[] fixEmpty(@Nullable T[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        return array;
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public static <C extends Collection> C fixEmpty(@Nullable C collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return collection;
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public static <C extends Map<?, ?>> C fixEmpty(@Nullable C map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        return map;
    }

    @Restricted(value={NoExternalUse.class})
    public static StringBuilder startToString(Object subjectOfToString) {
        return new StringBuilder(subjectOfToString.getClass().getSimpleName());
    }

    @Restricted(value={NoExternalUse.class})
    public static void endToString(StringBuilder sb) {
        if (sb.indexOf("{") >= 0) {
            sb.append("}");
        } else {
            sb.append("{}");
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static <T> void bldToString(StringBuilder sb, String attributeName, @Nullable T[] value) {
        if (value == null) {
            return;
        }
        if (sb.indexOf("{") >= 0) {
            sb.append(", ");
        } else {
            sb.append("{");
        }
        sb.append(attributeName);
        sb.append("=");
        sb.append(Arrays.toString(value));
    }

    @Restricted(value={NoExternalUse.class})
    public static void bldToString(StringBuilder sb, String attributeName, int value) {
        if (sb.indexOf("{") >= 0) {
            sb.append(", ");
        } else {
            sb.append("{");
        }
        sb.append(attributeName);
        sb.append("=");
        sb.append(value);
    }

    @Restricted(value={NoExternalUse.class})
    public static void bldToString(StringBuilder sb, String attributeName, @Nullable Object value) {
        if (value == null) {
            return;
        }
        if (sb.indexOf("{") >= 0) {
            sb.append(", ");
        } else {
            sb.append("{");
        }
        sb.append(attributeName);
        sb.append("=");
        if (value instanceof String) {
            sb.append('\'').append(value).append('\'');
        } else {
            sb.append(value);
        }
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public static String[] splitAndFilterEmpty(@Nullable String s, String separator) {
        if (s == null) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String o : Splitter.on((String)separator).omitEmptyStrings().split((CharSequence)s)) {
            result.add(o);
        }
        return result.toArray(new String[0]);
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public static List<String> splitAndFilterEmptyList(@Nullable String s, String separator) {
        ArrayList<String> result = new ArrayList<String>();
        if (s != null) {
            for (String o : Splitter.on((String)separator).omitEmptyStrings().split((CharSequence)s)) {
                result.add(o);
            }
        }
        return result;
    }

    public static List<String> splitAndTrimFilterEmptyList(String s, String separator) {
        ArrayList<String> result = new ArrayList<String>();
        if (s != null) {
            for (String o : Splitter.on((String)separator).omitEmptyStrings().trimResults().split((CharSequence)s)) {
                result.add(o);
            }
        }
        return result;
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public static Map<String, String> splitAndFilterEmptyMap(@Nullable String s, String separator) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (s != null) {
            for (String o : Splitter.on((String)separator).omitEmptyStrings().split((CharSequence)s)) {
                String[] parts = o.trim().split("=", 2);
                if (parts.length != 2) continue;
                result.put(parts[0].trim(), parts[1].trim());
            }
        }
        return result;
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public static String[] filterStringArray(@Nullable String[] arr) {
        ArrayList<String> strings = new ArrayList<String>();
        if (arr != null) {
            for (String s : arr) {
                if ((s = StringUtils.stripToNull((String)s)) == null) continue;
                strings.add(s);
            }
        }
        return strings.toArray(new String[0]);
    }

    @Restricted(value={NoExternalUse.class})
    public static <T> List<T> makeCopyOfList(@Nullable List<? extends T> listOrNull) {
        if (listOrNull == null) {
            return null;
        }
        ArrayList<T> copyList = new ArrayList<T>(listOrNull.size());
        for (T originalElement : listOrNull) {
            T copyOfElement = JenkinsUtils.makeCopy(originalElement);
            copyList.add(copyOfElement);
        }
        return copyList;
    }

    @Restricted(value={NoExternalUse.class})
    public static <T> T makeCopy(@Nullable T original) {
        if (original == null) {
            return null;
        }
        String xml = Jenkins.XSTREAM.toXML(original);
        Object copy = Jenkins.XSTREAM.fromXML(xml);
        return (T)copy;
    }
}

