/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.strategy;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.ExecutorListener;
import hudson.model.OneOffExecutor;
import hudson.model.Queue;
import hudson.slaves.RetentionStrategy;
import hudson.util.FormValidation;
import io.jenkins.docker.DockerComputer;
import io.jenkins.docker.DockerTransientNode;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.durabletask.executors.ContinuableExecutable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class DockerOnceRetentionStrategy
extends RetentionStrategy<DockerComputer>
implements ExecutorListener {
    private static final Logger LOGGER = Logger.getLogger(DockerOnceRetentionStrategy.class.getName());
    private static int DEFAULT_IDLEMINUTES = 10;
    private static long ONE_MILLISECOND_LESS_THAN_A_MINUTE = TimeUnit.MINUTES.toMillis(1L) - 1L;
    private int idleMinutes = DEFAULT_IDLEMINUTES;
    private Boolean terminateOnceDone;
    private Integer numberOfTasksInProgress;

    @DataBoundConstructor
    public DockerOnceRetentionStrategy(int idleMinutes) {
        this.idleMinutes = idleMinutes;
        this.terminateOnceDone = null;
        this.numberOfTasksInProgress = null;
    }

    @DataBoundSetter
    public void setTerminateOnceDone(Boolean terminateOnceDone) {
        this.terminateOnceDone = terminateOnceDone != null && terminateOnceDone != false ? Boolean.TRUE : null;
    }

    @DataBoundSetter
    public void setNumberOfTasksInProgress(Integer numberOfTasksInProgress) {
        this.numberOfTasksInProgress = numberOfTasksInProgress != null && numberOfTasksInProgress != 0 ? numberOfTasksInProgress : null;
    }

    public int getIdleMinutes() {
        if (this.idleMinutes < 1) {
            this.idleMinutes = DEFAULT_IDLEMINUTES;
        }
        return this.idleMinutes;
    }

    public boolean getTerminateOnceDone() {
        return this.terminateOnceDone != null && this.terminateOnceDone != false;
    }

    public int getNumberOfTasksInProgress() {
        return this.numberOfTasksInProgress == null ? 0 : this.numberOfTasksInProgress;
    }

    public long check(@NonNull DockerComputer c) {
        long maxIdleMilliseconds;
        int maxIdleMinutes = this.getIdleMinutes();
        if (!this.computerIsIdle(c)) {
            return maxIdleMinutes;
        }
        long idleMilliseconds = this.currentMilliseconds() - this.computerIdleStartMilliseconds(c);
        long excessIdleMilliseconds = idleMilliseconds - (maxIdleMilliseconds = TimeUnit.MINUTES.toMillis(maxIdleMinutes));
        if (excessIdleMilliseconds < 0L) {
            long insufficientIdleMilliseconds = -excessIdleMilliseconds;
            long insufficientIdleMinutesRoundedUp = TimeUnit.MILLISECONDS.toMinutes(insufficientIdleMilliseconds + ONE_MILLISECOND_LESS_THAN_A_MINUTE);
            return insufficientIdleMinutesRoundedUp;
        }
        LOGGER.log(Level.FINE, "Disconnecting {0} as it's been idle for {1}ms which is {2}ms more than the configured max of {3} minutes", new Object[]{this.computerName(c), idleMilliseconds, excessIdleMilliseconds, maxIdleMinutes});
        this.terminateContainer(c);
        return 1L;
    }

    public void start(DockerComputer c) {
        c.connect(false);
    }

    public synchronized void taskAccepted(Executor executor, Queue.Task task) {
        int oldNumberOfTasksInProgress = this.getNumberOfTasksInProgress();
        int newNumberOfTasksInProgress = oldNumberOfTasksInProgress + 1;
        this.setNumberOfTasksInProgress(newNumberOfTasksInProgress);
        if (task instanceof Queue.FlyweightTask || executor instanceof OneOffExecutor) {
            LOGGER.log(Level.FINER, "Node {0} has started FlyweightTask {1}. Tasks in progress now={2}", new Object[]{executor.getOwner().getName(), task, newNumberOfTasksInProgress});
            return;
        }
        if (executor instanceof ContinuableExecutable && ((ContinuableExecutable)executor).willContinue()) {
            LOGGER.log(Level.FINER, "Node {0} has started non-FlyweightTask {1}. Tasks in progress now={2}. This is-a ContinuableExecutable where willContinue()=true so we leave ourselves open to the follow-on task(s).", new Object[]{executor.getOwner().getName(), task, newNumberOfTasksInProgress});
            return;
        }
        this.setTerminateOnceDone(true);
        LOGGER.log(Level.FINER, "Node {0} has started non-FlyweightTask {1}. Tasks in progress now={2}. Container will be terminated once idle.", new Object[]{executor.getOwner().getName(), task, newNumberOfTasksInProgress});
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        this.done(executor, task);
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        this.done(executor, task);
    }

    private synchronized void done(Executor executor, Queue.Task task) {
        int oldNumberOfTasksInProgress = this.getNumberOfTasksInProgress();
        int newNumberOfTasksInProgress = oldNumberOfTasksInProgress - 1;
        this.setNumberOfTasksInProgress(newNumberOfTasksInProgress);
        if (newNumberOfTasksInProgress != 0) {
            LOGGER.log(Level.FINER, "Node {0} has completed Task {1}. Tasks in progress now={2}", new Object[]{executor.getOwner().getName(), task, newNumberOfTasksInProgress});
            return;
        }
        boolean shouldTerminateOnceDone = this.getTerminateOnceDone();
        if (!shouldTerminateOnceDone) {
            LOGGER.log(Level.FINER, "Node {0} has completed Task {1}. Tasks in progress now={2}. Not terminating yet as only trivial work has been done.", new Object[]{executor.getOwner().getName(), task, newNumberOfTasksInProgress});
            return;
        }
        DockerComputer c = (DockerComputer)executor.getOwner();
        LOGGER.log(Level.FINE, "Node {0} has completed Task {1}. Tasks in progress now={2}. Terminating as non-trivial work has been done.", new Object[]{executor.getOwner().getName(), task, newNumberOfTasksInProgress});
        this.terminateContainer(c);
    }

    @Restricted(value={NoExternalUse.class})
    protected boolean computerIsIdle(DockerComputer c) {
        return c.isIdle();
    }

    @Restricted(value={NoExternalUse.class})
    protected long computerIdleStartMilliseconds(DockerComputer c) {
        return c.getIdleStartMilliseconds();
    }

    @Restricted(value={NoExternalUse.class})
    protected long currentMilliseconds() {
        return System.currentTimeMillis();
    }

    @Restricted(value={NoExternalUse.class})
    protected String computerName(DockerComputer c) {
        return c.getName();
    }

    @Restricted(value={NoExternalUse.class})
    protected void terminateContainer(DockerComputer c) {
        c.setAcceptingTasks(false);
        Computer.threadPoolForRemoting.submit(() -> Queue.withLock(() -> {
            DockerTransientNode node = (DockerTransientNode)c.getNode();
            if (node != null) {
                node._terminate(c.getListener());
            }
        }));
    }

    public synchronized boolean isAcceptingTasks(DockerComputer c) {
        return !this.getTerminateOnceDone();
    }

    public int hashCode() {
        return Objects.hash(this.idleMinutes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DockerOnceRetentionStrategy that = (DockerOnceRetentionStrategy)((Object)o);
        return this.idleMinutes == that.idleMinutes;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<RetentionStrategy<?>> {
        public String getDisplayName() {
            return "Use docker container only once";
        }

        public FormValidation doCheckIdleMinutes(@QueryParameter String value) {
            return FormValidation.validatePositiveInteger((String)value);
        }
    }
}

