/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.listener;

import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerJobProperty;
import com.nirima.jenkins.plugins.docker.DockerJobTemplateProperty;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.Label;
import hudson.model.Project;
import hudson.model.Queue;
import hudson.model.labels.LabelAssignmentAction;
import hudson.model.labels.LabelAtom;
import hudson.model.queue.QueueListener;
import hudson.model.queue.SubTask;
import java.util.UUID;

@Extension
public class DockerQueueListener
extends QueueListener {
    public void onEnterWaiting(Queue.WaitingItem wi) {
        DockerCloud cloud;
        DockerJobTemplateProperty jobTemplate = DockerQueueListener.getJobTemplate((Queue.Item)wi);
        if (jobTemplate != null && (cloud = DockerCloud.getCloudByName(jobTemplate.getCloudname())) != null) {
            String uuid = UUID.randomUUID().toString();
            DockerTemplate template = jobTemplate.getTemplate().cloneWithLabel(uuid);
            cloud.addJobTemplate(wi.getId(), template);
            wi.addAction((Action)new DockerTemplateLabelAssignmentAction(uuid));
        }
    }

    public void onLeft(Queue.LeftItem li) {
        DockerCloud cloud;
        DockerJobTemplateProperty jobTemplate = DockerQueueListener.getJobTemplate((Queue.Item)li);
        if (jobTemplate != null && (cloud = DockerCloud.getCloudByName(jobTemplate.getCloudname())) != null) {
            cloud.removeJobTemplate(li.getId());
        }
    }

    @CheckForNull
    private static DockerJobTemplateProperty getJobTemplate(Queue.Item item) {
        if (item.task instanceof Project) {
            Project project = (Project)item.task;
            DockerJobTemplateProperty p = (DockerJobTemplateProperty)project.getProperty(DockerJobTemplateProperty.class);
            if (p != null) {
                return p;
            }
            DockerJobProperty property = (DockerJobProperty)project.getProperty(DockerJobProperty.class);
            if (property != null) {
                return property.getDockerJobTemplate();
            }
        }
        return null;
    }

    private static class DockerTemplateLabelAssignmentAction
    extends InvisibleAction
    implements LabelAssignmentAction {
        private final String uuid;

        private DockerTemplateLabelAssignmentAction(String uuid) {
            this.uuid = uuid;
        }

        public Label getAssignedLabel(@NonNull SubTask task) {
            return new LabelAtom(this.uuid);
        }
    }
}

