/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.builder;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.BuildImageResultCallback;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.api.model.Identifier;
import com.github.dockerjava.api.model.PushResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import com.github.dockerjava.core.NameParser;
import com.github.dockerjava.core.command.PushImageResultCallback;
import com.github.dockerjava.core.dockerfile.Dockerfile;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.action.DockerBuildImageAction;
import com.nirima.jenkins.plugins.docker.utils.JenkinsUtils;
import com.nirima.jenkins.plugins.docker.utils.LogUtils;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.remoting.RemoteInputStream;
import hudson.remoting.VirtualChannel;
import hudson.slaves.Cloud;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.docker.DockerTransientNode;
import io.jenkins.docker.client.DockerAPI;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerBuilderPublisher
extends Builder
implements SimpleBuildStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerBuilderPublisher.class);
    private static final String TAG_REGEX = "[a-zA-Z0-9-_.]+";
    private static final String NAME_COMPONENT_REGEX = "[a-z0-9-_.]+";
    private static final String REGISTRY_HOSTNAME_REGEX = "[a-zA-Z0-9-.]+(:[0-9]+)?";
    private static final String IMAGE_NAME_REGEX = "([a-zA-Z0-9-.]+(:[0-9]+)?/)?[a-z0-9-_.]+(/[a-z0-9-_.]+)*";
    private static final String VALID_REPO_REGEX = "^([a-zA-Z0-9-.]+(:[0-9]+)?/)?[a-z0-9-_.]+(/[a-z0-9-_.]+)*(:[a-zA-Z0-9-_.]+)?$";
    private static final Pattern VALID_REPO_PATTERN = Pattern.compile("^([a-zA-Z0-9-.]+(:[0-9]+)?/)?[a-z0-9-_.]+(/[a-z0-9-_.]+)*(:[a-zA-Z0-9-_.]+)?$");
    public final String dockerFileDirectory;
    @Deprecated
    private transient String pullCredentialsId;
    @CheckForNull
    private DockerRegistryEndpoint fromRegistry;
    @Deprecated
    public String tag;
    @CheckForNull
    private List<String> tags;
    @CheckForNull
    private Map<String, String> buildArgs;
    public final boolean pushOnSuccess;
    @CheckForNull
    private String pushCredentialsId;
    @Deprecated
    private transient DockerRegistryEndpoint registry;
    public final boolean cleanImages;
    public final boolean cleanupWithJenkinsJobDelete;
    @CheckForNull
    public final String cloud;
    public boolean noCache;
    public boolean pull;

    @DataBoundConstructor
    public DockerBuilderPublisher(String dockerFileDirectory, @Nullable DockerRegistryEndpoint fromRegistry, @Nullable String cloud, @Nullable String tagsString, boolean pushOnSuccess, @Nullable String pushCredentialsId, boolean cleanImages, boolean cleanupWithJenkinsJobDelete) {
        this.dockerFileDirectory = dockerFileDirectory;
        this.fromRegistry = fromRegistry;
        this.setTagsString(tagsString);
        this.tag = null;
        this.cloud = cloud;
        this.pushOnSuccess = pushOnSuccess;
        this.pushCredentialsId = pushCredentialsId;
        this.cleanImages = cleanImages;
        this.cleanupWithJenkinsJobDelete = cleanupWithJenkinsJobDelete;
    }

    @Deprecated
    public DockerRegistryEndpoint getRegistry(Identifier identifier) {
        if (this.registry == null) {
            this.registry = new DockerRegistryEndpoint(null, this.pushCredentialsId);
        }
        return this.registry;
    }

    @Deprecated
    @CheckForNull
    public String getPullCredentialsId() {
        return this.pullCredentialsId;
    }

    @CheckForNull
    public String getPushCredentialsId() {
        return this.pushCredentialsId;
    }

    @CheckForNull
    public List<String> getTags() {
        return JenkinsUtils.fixEmpty(this.tags);
    }

    public void setTags(List<String> tags) {
        this.tags = JenkinsUtils.fixEmpty(tags);
    }

    @NonNull
    public String getTagsString() {
        List<String> tagsOrNull = this.getTags();
        return tagsOrNull == null ? "" : Joiner.on((String)"\n").join(tagsOrNull);
    }

    public void setTagsString(String tagsString) {
        this.setTags(JenkinsUtils.splitAndTrimFilterEmptyList(tagsString, "\n"));
    }

    @CheckForNull
    public Map<String, String> getBuildArgs() {
        return JenkinsUtils.fixEmpty(this.buildArgs);
    }

    @DataBoundSetter
    public void setBuildArgs(Map<String, String> buildArgs) {
        this.buildArgs = JenkinsUtils.fixEmpty(buildArgs);
    }

    @NonNull
    public String getBuildArgsString() {
        Map<String, String> buildArgsOrNull = this.getBuildArgs();
        return buildArgsOrNull == null ? "" : Joiner.on((String)"\n").withKeyValueSeparator("=").join(buildArgsOrNull);
    }

    @DataBoundSetter
    public void setBuildArgsString(String buildArgsString) {
        this.setBuildArgs(JenkinsUtils.splitAndFilterEmptyMap(buildArgsString, "\n"));
    }

    @CheckForNull
    public DockerRegistryEndpoint getFromRegistry() {
        return this.fromRegistry;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    @DataBoundSetter
    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }

    public boolean isPull() {
        return this.pull;
    }

    @DataBoundSetter
    public void setPull(boolean pull) {
        this.pull = pull;
    }

    @Restricted(value={NoExternalUse.class})
    static void verifyTags(String tagsString) {
        List<String> verifyTags = JenkinsUtils.splitAndTrimFilterEmptyList(tagsString, "\n");
        for (String verifyTag : verifyTags) {
            String expandedTag = verifyTag.replaceAll("\\$\\{[^}]*NUMBER\\}", "1234").replaceAll("\\$\\{[^}]*\\}", "xyz");
            if (VALID_REPO_PATTERN.matcher(expandedTag).matches()) continue;
            throw new IllegalArgumentException("Tag " + verifyTag + " doesn't match ^([a-zA-Z0-9-.]+(:[0-9]+)?/)?[a-z0-9-_.]+(/[a-z0-9-_.]+)*(:[a-zA-Z0-9-_.]+)?$");
        }
    }

    protected DockerAPI getDockerAPI(Launcher launcher) {
        DockerCloud theCloud;
        VirtualChannel channel = launcher.getChannel();
        if (!Strings.isNullOrEmpty((String)this.cloud)) {
            theCloud = JenkinsUtils.getCloudByNameOrThrow(this.cloud);
        } else {
            Node node;
            if (channel instanceof Channel && (node = Jenkins.get().getNode(((Channel)channel).getName())) instanceof DockerTransientNode) {
                return ((DockerTransientNode)node).getDockerAPI();
            }
            Optional<DockerCloud> cloudForChannel = JenkinsUtils.getCloudForChannel(channel);
            if (cloudForChannel.isEmpty()) {
                throw new RuntimeException("Could not find the cloud this project was built on");
            }
            theCloud = cloudForChannel.get();
        }
        if (theCloud.isTriton()) {
            LOGGER.warn("Selected cloud for build does not support this feature. Finding an alternative");
            for (DockerCloud dc : DockerCloud.instances()) {
                if (dc.isTriton()) continue;
                LOGGER.warn("Picked {} cloud instead", (Object)dc.getDisplayName());
                theCloud = dc;
                break;
            }
        }
        return theCloud.getDockerApi();
    }

    public void perform(hudson.model.Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        List<String> expandedTags = this.expandTags(run, workspace, listener);
        Map buildArgsToUse = Optional.ofNullable(this.getBuildArgs()).orElseGet(Collections::emptyMap);
        String expandedDockerFileDirectory = this.dockerFileDirectory;
        try {
            expandedDockerFileDirectory = TokenMacro.expandAll(run, (FilePath)workspace, (TaskListener)listener, (String)this.dockerFileDirectory);
        }
        catch (MacroEvaluationException e) {
            listener.getLogger().println("Couldn't macro expand docker file directory " + this.dockerFileDirectory);
            e.printStackTrace(listener.getLogger());
        }
        new Run(run, listener, new FilePath(workspace, expandedDockerFileDirectory), expandedTags, buildArgsToUse, this.getDockerAPI(launcher)).run();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private List<String> expandTags(hudson.model.Run<?, ?> build, FilePath workspace, TaskListener listener) {
        ArrayList<String> result;
        List<String> tagsOrNull = this.getTags();
        if (tagsOrNull == null) {
            result = new ArrayList<String>(0);
        } else {
            result = new ArrayList(tagsOrNull.size());
            for (String thisTag : tagsOrNull) {
                try {
                    String expandedTag = TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)thisTag);
                    result.add(expandedTag);
                }
                catch (IOException | InterruptedException | MacroEvaluationException e) {
                    listener.getLogger().println("Couldn't macro expand tag " + thisTag);
                    e.printStackTrace(listener.getLogger());
                }
            }
        }
        return result;
    }

    private Object readResolve() {
        if (this.pushCredentialsId == null && this.registry != null) {
            this.pushCredentialsId = this.registry.getCredentialsId();
        }
        if (this.pullCredentialsId != null) {
            this.fromRegistry = new DockerRegistryEndpoint(null, this.pullCredentialsId);
        }
        return this;
    }

    private class Run {
        private final TaskListener listener;
        private final FilePath fpChild;
        private final List<String> tagsToUse;
        @NonNull
        private final Map<String, String> buildArgsToUse;
        private final DockerAPI dockerApi;
        private final hudson.model.Run<?, ?> run;

        private Run(hudson.model.Run<?, ?> run, TaskListener listener, FilePath fpChild, @NonNull List<String> tagsToUse, Map<String, String> buildArgsToUse, DockerAPI dockerApi) {
            this.run = run;
            this.listener = listener;
            this.fpChild = fpChild;
            this.tagsToUse = tagsToUse;
            this.buildArgsToUse = buildArgsToUse;
            this.dockerApi = dockerApi;
        }

        private DockerAPI getDockerAPI() {
            Validate.notNull((Object)((Object)this.dockerApi), (String)"Could not get client because we could not find the cloud that the project was built on. Was this build run on Docker?");
            return this.dockerApi;
        }

        private DockerClient getClientWithNoTimeout() {
            return this.getDockerAPI().getClient(0);
        }

        private DockerClient getClient() {
            return this.getDockerAPI().getClient();
        }

        boolean run() throws IOException, InterruptedException {
            this.log("Docker Build");
            String imageId = this.buildImage();
            this.log("Docker Build Response : " + imageId);
            DockerBuildImageAction action = new DockerBuildImageAction(this.dockerApi.getDockerHost().getUri(), imageId, this.tagsToUse, DockerBuilderPublisher.this.cleanupWithJenkinsJobDelete, DockerBuilderPublisher.this.pushOnSuccess, DockerBuilderPublisher.this.noCache, DockerBuilderPublisher.this.pull);
            this.run.addAction((Action)action);
            this.run.save();
            if (DockerBuilderPublisher.this.pushOnSuccess) {
                this.log("Pushing " + String.valueOf(this.tagsToUse));
                this.pushImages();
            }
            if (DockerBuilderPublisher.this.cleanImages) {
                this.log("Cleaning local images [" + imageId + "]");
                try {
                    this.cleanImages(imageId);
                }
                catch (Exception ex) {
                    this.log("Error attempting to clean images", ex);
                }
            }
            this.log("Docker Build Done");
            return true;
        }

        private void cleanImages(String id) throws IOException {
            try (DockerClient client = this.getClient();){
                client.removeImageCmd(id).withForce(Boolean.valueOf(true)).exec();
            }
        }

        @NonNull
        private String buildImage() throws IOException, InterruptedException {
            String imageId;
            AuthConfigurations auths = new AuthConfigurations();
            DockerRegistryEndpoint pullRegistry = DockerBuilderPublisher.this.getFromRegistry();
            if (pullRegistry != null && pullRegistry.getCredentialsId() != null) {
                auths.addConfig(DockerCloud.getAuthConfig(pullRegistry, this.run.getParent().getParent()));
            }
            this.log("Docker Build: building image at path " + this.fpChild.getRemote());
            InputStream tar = (InputStream)this.fpChild.act((FilePath.FileCallable)new DockerBuildCallable());
            BuildImageResultCallback resultCallback = new BuildImageResultCallback(){

                public void onNext(BuildResponseItem item) {
                    String text = item.getStream();
                    if (text != null) {
                        Run.this.listener.getLogger().println(text);
                    }
                    super.onNext(item);
                }
            };
            try (DockerClient client = this.getClientWithNoTimeout();){
                BuildImageCmd cmd = client.buildImageCmd(tar).withNoCache(Boolean.valueOf(DockerBuilderPublisher.this.noCache)).withPull(Boolean.valueOf(DockerBuilderPublisher.this.pull)).withBuildAuthConfigs(auths);
                this.buildArgsToUse.forEach((arg_0, arg_1) -> ((BuildImageCmd)cmd).withBuildArg(arg_0, arg_1));
                imageId = ((BuildImageResultCallback)cmd.exec((ResultCallback)resultCallback)).awaitImageId();
                if (imageId == null) {
                    throw new AbortException("Built image id is null. Some error occured");
                }
                for (String thisTag : this.tagsToUse) {
                    NameParser.ReposTag reposTag = NameParser.parseRepositoryTag((String)thisTag);
                    String commitTag = StringUtils.isEmpty((String)reposTag.tag) ? "latest" : reposTag.tag;
                    this.log("Tagging built image with " + reposTag.repos + ":" + commitTag);
                    client.tagImageCmd(imageId, reposTag.repos, commitTag).withForce().exec();
                }
            }
            return imageId;
        }

        protected void log(String s) {
            this.listener.getLogger().println(s);
        }

        protected void log(Throwable ex) {
            ex.printStackTrace(this.listener.getLogger());
        }

        protected void log(String s, Throwable ex) {
            this.log(s);
            this.log(ex);
        }

        private void pushImages() throws IOException {
            for (String tagToUse : this.tagsToUse) {
                Identifier identifier = Identifier.fromCompoundString((String)tagToUse);
                PushImageResultCallback resultCallback = new PushImageResultCallback(){

                    public void onNext(PushResponseItem item) {
                        if (item == null) {
                            Run.this.log("Received NULL Push Response. Ignoring");
                            return;
                        }
                        LogUtils.printResponseItemToListener(Run.this.listener, (ResponseItem)item);
                        super.onNext(item);
                    }
                };
                try {
                    DockerClient client = this.getClientWithNoTimeout();
                    try {
                        PushImageCmd cmd = client.pushImageCmd(identifier);
                        int i = identifier.repository.name.indexOf(47);
                        String regName = i >= 0 ? identifier.repository.name.substring(0, i) : null;
                        DockerCloud.setRegistryAuthentication(cmd, new DockerRegistryEndpoint(regName, DockerBuilderPublisher.this.getPushCredentialsId()), this.run.getParent().getParent());
                        ((PushImageResultCallback)cmd.exec((ResultCallback)resultCallback)).awaitSuccess();
                    }
                    finally {
                        if (client == null) continue;
                        client.close();
                    }
                }
                catch (DockerException ex) {
                    this.log("Exception pushing docker image. Check that the destination registry is running.");
                    throw ex;
                }
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckTagsString(@QueryParameter String tagsString) {
            try {
                DockerBuilderPublisher.verifyTags(tagsString);
            }
            catch (Throwable t) {
                return FormValidation.error((String)t.getMessage());
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillPullCredentialsIdItems(@AncestorInPath Item item) {
            return this.doFillRegistryCredentialsIdItems(item);
        }

        public ListBoxModel doFillPushCredentialsIdItems(@AncestorInPath Item item) {
            return this.doFillRegistryCredentialsIdItems(item);
        }

        private ListBoxModel doFillRegistryCredentialsIdItems(@AncestorInPath Item item) {
            DockerRegistryEndpoint.DescriptorImpl descriptor = (DockerRegistryEndpoint.DescriptorImpl)Jenkins.get().getDescriptorOrDie(DockerRegistryEndpoint.class);
            return descriptor.doFillCredentialsIdItems(item);
        }

        public ListBoxModel doFillCloudItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("Cloud this build is running on", "");
            for (Cloud cloud : DockerCloud.instances()) {
                model.add(cloud.name);
            }
            return model;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Build / Publish Docker Image";
        }
    }

    private static class DockerBuildCallable
    extends MasterToSlaveFileCallable<InputStream> {
        private DockerBuildCallable() {
        }

        public InputStream invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            return new RemoteInputStream(new Dockerfile(new File(f, "Dockerfile"), f).parse().buildDockerFolderTar(), RemoteInputStream.Flag.GREEDY);
        }
    }
}

