/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.builder;

import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.slaves.Cloud;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.io.PrintStream;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerBuilderNewTemplate
extends Builder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerBuilderNewTemplate.class);
    private DockerTemplate dockerTemplate;
    private int version = 1;

    @DataBoundConstructor
    public DockerBuilderNewTemplate(DockerTemplate dockerTemplate) {
        this.dockerTemplate = dockerTemplate;
    }

    public DockerTemplate getDockerTemplate() {
        return this.dockerTemplate;
    }

    public void setDockerTemplate(DockerTemplate dockerTemplate) {
        this.dockerTemplate = dockerTemplate;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream llogger = listener.getLogger();
        String dockerImage = this.dockerTemplate.getDockerTemplateBase().getImage();
        build.getACL().checkPermission(Jenkins.ADMINISTER);
        for (Cloud c : Jenkins.get().clouds) {
            DockerCloud dockerCloud;
            if (!(c instanceof DockerCloud) || dockerImage == null || (dockerCloud = (DockerCloud)c).getTemplate(dockerImage) != null) continue;
            LOGGER.info("Adding new template: '{}', to cloud: '{}'", (Object)dockerImage, (Object)dockerCloud.name);
            llogger.println("Adding new template: '" + dockerImage + "', to cloud: '" + dockerCloud.name + "'");
            dockerCloud.addTemplate(this.dockerTemplate);
        }
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Add a new template to all docker clouds";
        }
    }
}

