/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.builder;

import com.github.dockerjava.api.exception.ConflictException;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.nirima.jenkins.plugins.docker.action.DockerLaunchAction;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlOption;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.PrintStream;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerBuilderControlOptionStopAll
extends DockerBuilderControlOption {
    private static final Logger LOG = LoggerFactory.getLogger(DockerBuilderControlOptionStopAll.class);
    public final boolean remove;

    @DataBoundConstructor
    public DockerBuilderControlOptionStopAll(boolean remove) {
        this.remove = remove;
    }

    @Override
    public void execute(Run<?, ?> build, Launcher launcher, TaskListener listener) throws DockerException {
        PrintStream llog = listener.getLogger();
        LOG.info("Stopping all containers");
        llog.println("Stopping all containers");
        for (DockerLaunchAction.Item containerItem : this.getLaunchAction(build).getRunning()) {
            String containerId = containerItem.id;
            LOG.info("Stopping container {}", (Object)containerId);
            llog.println("Stopping container " + containerId);
            containerItem.client.stopContainerCmd(containerId).exec();
            if (!this.remove) continue;
            LOG.info("Removing container {}", (Object)containerId);
            llog.println("Removing container " + containerId);
            try {
                containerItem.client.removeContainerCmd(containerId).exec();
            }
            catch (NotFoundException handledByCode) {
                llog.println("Container '" + containerId + "' already gone.");
            }
            catch (ConflictException handledByCode) {
                llog.println("Container '" + containerId + "' removal already in progress.");
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends DockerBuilderControlOption.DockerBuilderControlOptionDescriptor {
        public String getDisplayName() {
            return "Stop All Containers";
        }
    }
}

