/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.builder;

import com.google.common.base.Strings;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlOption;
import com.nirima.jenkins.plugins.docker.utils.JenkinsUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Launcher;
import hudson.model.Run;
import java.util.Optional;
import jenkins.model.Jenkins;

public abstract class DockerBuilderControlCloudOption
extends DockerBuilderControlOption {
    public final String cloudName;

    protected DockerBuilderControlCloudOption(String cloudName) {
        this.cloudName = cloudName;
    }

    public String getCloudName() {
        return this.cloudName;
    }

    @NonNull
    protected DockerCloud getCloud(Run<?, ?> build, Launcher launcher) {
        if (!Strings.isNullOrEmpty((String)this.cloudName)) {
            DockerCloud specifiedCloud = (DockerCloud)Jenkins.get().getCloud(this.cloudName);
            if (specifiedCloud == null) {
                throw new IllegalStateException("Could not find a cloud named " + this.cloudName);
            }
            return specifiedCloud;
        }
        Optional<DockerCloud> cloud = JenkinsUtils.getCloudThatWeBuiltOn(build, launcher);
        if (cloud.isEmpty()) {
            throw new IllegalStateException("Cannot list cloud for docker action");
        }
        return cloud.get();
    }
}

