/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.BindOptions;
import com.github.dockerjava.api.model.BindPropagation;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Mount;
import com.github.dockerjava.api.model.MountType;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.PropagationMode;
import com.github.dockerjava.api.model.TmpfsOptions;
import com.github.dockerjava.api.model.VolumesFrom;
import com.github.dockerjava.core.NameParser;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.nirima.jenkins.plugins.docker.DockerContainerLabelKeys;
import com.nirima.jenkins.plugins.docker.utils.JenkinsUtils;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class DockerTemplateBase
implements Describable<DockerTemplateBase>,
Serializable {
    private static final long serialVersionUID = 1838584884066776725L;
    @NonNull
    private final String image;
    @CheckForNull
    private String pullCredentialsId;
    @CheckForNull
    private transient DockerRegistryEndpoint registry;
    @CheckForNull
    private String dockerCommand;
    @CheckForNull
    public String hostname;
    @CheckForNull
    private String user;
    @CheckForNull
    private List<String> extraGroups;
    @CheckForNull
    public String[] dnsHosts;
    @CheckForNull
    public String[] dnsSearch;
    @CheckForNull
    public String network;
    @Deprecated
    @CheckForNull
    public String[] volumes;
    @CheckForNull
    public String[] mounts;
    @Deprecated
    @CheckForNull
    public String volumesFrom;
    @CheckForNull
    public String[] volumesFrom2;
    @CheckForNull
    public String[] devices;
    @CheckForNull
    public String[] environment;
    @CheckForNull
    public String bindPorts;
    public boolean bindAllPorts;
    @CheckForNull
    public Integer memoryLimit;
    @CheckForNull
    public Integer memorySwap;
    @CheckForNull
    public String cgroupParent;
    @CheckForNull
    public String cpus;
    @CheckForNull
    public Long cpuPeriod;
    @CheckForNull
    public Long cpuQuota;
    @CheckForNull
    public Integer cpuShares;
    @CheckForNull
    public Integer shmSize;
    public boolean privileged;
    public boolean tty;
    @CheckForNull
    private String macAddress;
    @CheckForNull
    private List<String> extraHosts;
    @CheckForNull
    private List<String> securityOpts;
    @CheckForNull
    private List<String> capabilitiesToAdd;
    @CheckForNull
    private List<String> capabilitiesToDrop;
    @CheckForNull
    private Map<String, String> extraDockerLabels;

    @DataBoundConstructor
    public DockerTemplateBase(String image) {
        if (image == null) {
            throw new IllegalArgumentException("Image can't be null");
        }
        this.image = image.trim();
    }

    @Deprecated
    public DockerTemplateBase(String image, String pullCredentialsId, String dnsString, String dnsSearchString, String network, String dockerCommand, String mountsString, String volumesFromString, String environmentsString, String hostname, String user, String extraGroupsString, Integer memoryLimit, Integer memorySwap, Long cpuPeriod, Long cpuQuota, Integer cpuShares, Integer shmSize, String bindPorts, boolean bindAllPorts, boolean privileged, boolean tty, String macAddress, String extraHostsString) {
        this(image);
        this.setPullCredentialsId(pullCredentialsId);
        this.setDnsString(dnsString);
        this.setDnsSearchString(dnsSearchString);
        this.setNetwork(network);
        this.setDockerCommand(dockerCommand);
        this.setMountsString(mountsString);
        this.setVolumesFromString(volumesFromString);
        this.setEnvironmentsString(environmentsString);
        this.setHostname(hostname);
        this.setUser(user);
        this.setExtraGroupsString(extraGroupsString);
        this.setMemoryLimit(memoryLimit);
        this.setMemorySwap(memorySwap);
        this.setCpuPeriod(cpuPeriod);
        this.setCpuQuota(cpuQuota);
        this.setCpuShares(cpuShares);
        this.setShmSize(shmSize);
        this.setBindPorts(bindPorts);
        this.setBindAllPorts(bindAllPorts);
        this.setPrivileged(privileged);
        this.setTty(tty);
        this.setMacAddress(macAddress);
        this.setExtraHostsString(extraHostsString);
    }

    protected Object readResolve() {
        if (this.volumesFrom != null) {
            if (StringUtils.isNotBlank((String)this.volumesFrom)) {
                this.setVolumesFrom2(new String[]{this.volumesFrom});
            }
            this.volumesFrom = null;
        }
        if (this.volumes != null && this.volumes.length > 0) {
            this.setMounts(DockerTemplateBase.convertVolumes(this.volumes));
            this.volumes = null;
        }
        if (this.pullCredentialsId == null && this.registry != null) {
            this.pullCredentialsId = this.registry.getCredentialsId();
        }
        return this;
    }

    @NonNull
    public String getImage() {
        return this.image.trim();
    }

    @CheckForNull
    public String getPullCredentialsId() {
        return Util.fixEmpty((String)this.pullCredentialsId);
    }

    @DataBoundSetter
    public void setPullCredentialsId(String pullCredentialsId) {
        this.pullCredentialsId = Util.fixEmpty((String)pullCredentialsId);
    }

    @CheckForNull
    public String getDockerCommand() {
        return Util.fixEmpty((String)this.dockerCommand);
    }

    @DataBoundSetter
    public void setDockerCommand(String dockerCommand) {
        this.dockerCommand = Util.fixEmpty((String)dockerCommand);
    }

    @CheckForNull
    public String getHostname() {
        return Util.fixEmpty((String)this.hostname);
    }

    @DataBoundSetter
    public void setHostname(String hostname) {
        this.hostname = Util.fixEmpty((String)hostname);
    }

    @CheckForNull
    public String getUser() {
        return Util.fixEmpty((String)this.user);
    }

    @DataBoundSetter
    public void setUser(String user) {
        this.user = Util.fixEmpty((String)user);
    }

    @CheckForNull
    public List<String> getExtraGroups() {
        return JenkinsUtils.fixEmpty(this.extraGroups);
    }

    public void setExtraGroups(List<String> extraGroups) {
        this.extraGroups = JenkinsUtils.fixEmpty(extraGroups);
    }

    @DataBoundSetter
    public void setExtraGroupsString(String extraGroupsString) {
        this.setExtraGroups(JenkinsUtils.splitAndFilterEmptyList(extraGroupsString, "\n"));
    }

    @NonNull
    public String getExtraGroupsString() {
        if (this.extraGroups == null) {
            return "";
        }
        return Joiner.on((String)"\n").join(this.extraGroups);
    }

    @CheckForNull
    public String[] getDnsHosts() {
        return JenkinsUtils.fixEmpty(this.dnsHosts);
    }

    @NonNull
    public String getDnsString() {
        if (this.dnsHosts == null) {
            return "";
        }
        return Joiner.on((String)" ").join((Object[])this.dnsHosts);
    }

    public void setDnsHosts(String[] dnsHosts) {
        this.dnsHosts = JenkinsUtils.fixEmpty(dnsHosts);
    }

    @DataBoundSetter
    public void setDnsString(String dnsString) {
        this.setDnsHosts(JenkinsUtils.splitAndFilterEmpty(dnsString, " "));
    }

    @CheckForNull
    public String[] getDnsSearch() {
        return JenkinsUtils.fixEmpty(this.dnsSearch);
    }

    @NonNull
    public String getDnsSearchString() {
        if (this.dnsSearch == null) {
            return "";
        }
        return Joiner.on((String)" ").join((Object[])this.dnsSearch);
    }

    public void setDnsSearch(String[] dnsSearch) {
        this.dnsSearch = JenkinsUtils.fixEmpty(dnsSearch);
    }

    @DataBoundSetter
    public void setDnsSearchString(String dnsSearchString) {
        this.setDnsSearch(JenkinsUtils.splitAndFilterEmpty(dnsSearchString, " "));
    }

    @CheckForNull
    public String getNetwork() {
        return Util.fixEmpty((String)this.network);
    }

    @DataBoundSetter
    public void setNetwork(String network) {
        this.network = Util.fixEmpty((String)network);
    }

    @CheckForNull
    public String[] getMounts() {
        return JenkinsUtils.fixEmpty(JenkinsUtils.filterStringArray(this.mounts));
    }

    public void setMounts(String[] mounts) {
        this.mounts = JenkinsUtils.fixEmpty(mounts);
    }

    @NonNull
    public String getMountsString() {
        if (this.mounts == null) {
            return "";
        }
        return Joiner.on((String)"\n").join((Object[])this.mounts);
    }

    @DataBoundSetter
    public void setMountsString(String mountsString) {
        this.setMounts(JenkinsUtils.splitAndFilterEmpty(mountsString, "\n"));
    }

    @NonNull
    public String getVolumesFromString() {
        Object[] volumesFrom2OrNull = this.getVolumesFrom2();
        return volumesFrom2OrNull == null ? "" : Joiner.on((String)"\n").join(volumesFrom2OrNull);
    }

    @DataBoundSetter
    public void setVolumesFromString(String volumesFromString) {
        this.setVolumesFrom2(JenkinsUtils.splitAndFilterEmpty(volumesFromString, "\n"));
    }

    @CheckForNull
    public String[] getDevices() {
        return JenkinsUtils.fixEmpty(JenkinsUtils.filterStringArray(this.devices));
    }

    @NonNull
    public String getDevicesString() {
        if (this.devices == null) {
            return "";
        }
        return Joiner.on((String)"\n").join((Object[])this.devices);
    }

    public void setDevices(String[] devices) {
        this.devices = JenkinsUtils.fixEmpty(devices);
    }

    @DataBoundSetter
    public void setDevicesString(String devicesString) {
        this.setDevices(JenkinsUtils.splitAndFilterEmpty(devicesString, "\n"));
    }

    @CheckForNull
    public String[] getEnvironment() {
        return JenkinsUtils.fixEmpty(this.environment);
    }

    @NonNull
    public String getEnvironmentsString() {
        if (this.environment == null) {
            return "";
        }
        return Joiner.on((String)"\n").join((Object[])this.environment);
    }

    public void setEnvironment(String[] environment) {
        this.environment = JenkinsUtils.fixEmpty(environment);
    }

    @DataBoundSetter
    public void setEnvironmentsString(String environmentsString) {
        this.setEnvironment(JenkinsUtils.splitAndFilterEmpty(environmentsString, "\n"));
    }

    @CheckForNull
    public String getBindPorts() {
        return Util.fixEmpty((String)this.bindPorts);
    }

    @DataBoundSetter
    public void setBindPorts(String bindPorts) {
        this.bindPorts = Util.fixEmpty((String)bindPorts);
    }

    public boolean isBindAllPorts() {
        return this.bindAllPorts;
    }

    @DataBoundSetter
    public void setBindAllPorts(boolean bindAllPorts) {
        this.bindAllPorts = bindAllPorts;
    }

    @CheckForNull
    public Integer getMemoryLimit() {
        return this.memoryLimit;
    }

    @DataBoundSetter
    public void setMemoryLimit(Integer memoryLimit) {
        this.memoryLimit = memoryLimit;
    }

    @CheckForNull
    public Integer getMemorySwap() {
        return this.memorySwap;
    }

    @DataBoundSetter
    public void setMemorySwap(Integer memorySwap) {
        this.memorySwap = memorySwap;
    }

    @CheckForNull
    public String getCgroupParent() {
        return Util.fixEmpty((String)this.cgroupParent);
    }

    @DataBoundSetter
    public void setCgroupParent(String cgroupParent) {
        this.cgroupParent = Util.fixEmpty((String)cgroupParent);
    }

    @CheckForNull
    public String getCpus() {
        return Util.fixEmpty((String)this.cpus);
    }

    @DataBoundSetter
    public void setCpus(String cpus) {
        this.cpus = Util.fixEmpty((String)cpus);
    }

    @CheckForNull
    public Long getCpuPeriod() {
        return this.cpuPeriod;
    }

    @DataBoundSetter
    public void setCpuPeriod(Long cpuPeriod) {
        this.cpuPeriod = cpuPeriod;
    }

    @CheckForNull
    public Long getCpuQuota() {
        return this.cpuQuota;
    }

    @DataBoundSetter
    public void setCpuQuota(Long cpuQuota) {
        this.cpuQuota = cpuQuota;
    }

    @CheckForNull
    public Integer getCpuShares() {
        return this.cpuShares;
    }

    @DataBoundSetter
    public void setCpuShares(Integer cpuShares) {
        this.cpuShares = cpuShares;
    }

    @CheckForNull
    public Integer getShmSize() {
        return this.shmSize;
    }

    @DataBoundSetter
    public void setShmSize(Integer shmSize) {
        this.shmSize = shmSize;
    }

    public boolean isPrivileged() {
        return this.privileged;
    }

    @DataBoundSetter
    public void setPrivileged(boolean privileged) {
        this.privileged = privileged;
    }

    public boolean isTty() {
        return this.tty;
    }

    @DataBoundSetter
    public void setTty(boolean tty) {
        this.tty = tty;
    }

    @CheckForNull
    public String getMacAddress() {
        return StringUtils.trimToNull((String)this.macAddress);
    }

    @DataBoundSetter
    public void setMacAddress(String macAddress) {
        this.macAddress = StringUtils.trimToNull((String)macAddress);
    }

    @CheckForNull
    public List<String> getExtraHosts() {
        return JenkinsUtils.fixEmpty(this.extraHosts);
    }

    @NonNull
    public String getExtraHostsString() {
        if (this.extraHosts == null) {
            return "";
        }
        return Joiner.on((String)"\n").join(this.extraHosts);
    }

    public void setExtraHosts(List<String> extraHosts) {
        this.extraHosts = JenkinsUtils.fixEmpty(extraHosts);
    }

    @DataBoundSetter
    public void setExtraHostsString(String extraHostsString) {
        this.setExtraHosts(JenkinsUtils.splitAndFilterEmptyList(extraHostsString, "\n"));
    }

    @CheckForNull
    public List<String> getSecurityOpts() {
        return JenkinsUtils.fixEmpty(this.securityOpts);
    }

    @NonNull
    public String getSecurityOptsString() {
        return this.securityOpts == null ? "" : Joiner.on((String)"\n").join(this.securityOpts);
    }

    public void setSecurityOpts(List<String> securityOpts) {
        this.securityOpts = JenkinsUtils.fixEmpty(securityOpts);
    }

    @DataBoundSetter
    public void setSecurityOptsString(String securityOpts) {
        this.setSecurityOpts(JenkinsUtils.splitAndFilterEmptyList(securityOpts, "\n"));
    }

    @CheckForNull
    public List<String> getCapabilitiesToAdd() {
        return JenkinsUtils.fixEmpty(this.capabilitiesToAdd);
    }

    @NonNull
    public String getCapabilitiesToAddString() {
        if (this.capabilitiesToAdd == null) {
            return "";
        }
        return Joiner.on((String)"\n").join(this.capabilitiesToAdd);
    }

    public void setCapabilitiesToAdd(List<String> capabilitiesToAdd) {
        this.capabilitiesToAdd = JenkinsUtils.fixEmpty(capabilitiesToAdd);
    }

    @DataBoundSetter
    public void setCapabilitiesToAddString(String capabilitiesToAddString) {
        this.setCapabilitiesToAdd(JenkinsUtils.splitAndFilterEmptyList(capabilitiesToAddString, "\n"));
    }

    @CheckForNull
    public List<String> getCapabilitiesToDrop() {
        return JenkinsUtils.fixEmpty(this.capabilitiesToDrop);
    }

    @NonNull
    public String getCapabilitiesToDropString() {
        if (this.capabilitiesToDrop == null) {
            return "";
        }
        return Joiner.on((String)"\n").join(this.capabilitiesToDrop);
    }

    public void setCapabilitiesToDrop(List<String> capabilitiesToDrop) {
        this.capabilitiesToDrop = JenkinsUtils.fixEmpty(capabilitiesToDrop);
    }

    @DataBoundSetter
    public void setCapabilitiesToDropString(String capabilitiesToDropString) {
        this.setCapabilitiesToDrop(JenkinsUtils.splitAndFilterEmptyList(capabilitiesToDropString, "\n"));
    }

    @CheckForNull
    public Map<String, String> getExtraDockerLabels() {
        return JenkinsUtils.fixEmpty(this.extraDockerLabels);
    }

    @NonNull
    public String getExtraDockerLabelsString() {
        if (this.extraDockerLabels == null) {
            return "";
        }
        return Joiner.on((String)"\n").withKeyValueSeparator("=").join(this.extraDockerLabels);
    }

    public void setExtraDockerLabels(Map<String, String> extraDockerLabels) {
        this.extraDockerLabels = JenkinsUtils.fixEmpty(extraDockerLabels);
    }

    @DataBoundSetter
    public void setExtraDockerLabelsString(String extraDockerLabelsString) {
        this.setExtraDockerLabels(JenkinsUtils.splitAndFilterEmptyMap(extraDockerLabelsString, "\n"));
    }

    public DockerRegistryEndpoint getRegistry() {
        if (this.registry == null) {
            this.registry = DockerRegistryEndpoint.fromImageName((String)this.getImage(), (String)this.pullCredentialsId);
        }
        return this.registry;
    }

    @Deprecated
    public String getVolumesFrom() {
        return this.volumesFrom;
    }

    @CheckForNull
    public String[] getVolumesFrom2() {
        return JenkinsUtils.fixEmpty(JenkinsUtils.filterStringArray(this.volumesFrom2));
    }

    public void setVolumesFrom2(String[] volumesFrom) {
        this.volumesFrom2 = JenkinsUtils.fixEmpty(volumesFrom);
    }

    @Deprecated
    public void setVolumes(String[] vols) {
        String[] fixed = JenkinsUtils.fixEmpty(vols);
        this.mounts = fixed != null && fixed.length > 0 ? DockerTemplateBase.convertVolumes(fixed) : new String[]{};
    }

    @Deprecated
    @CheckForNull
    public String[] getVolumes() {
        return this.getMounts();
    }

    @Deprecated
    public void setVolumesString(String volumesString) {
        this.setMounts(DockerTemplateBase.convertVolumes(JenkinsUtils.splitAndFilterEmpty(volumesString, "\n")));
    }

    @Deprecated
    @NonNull
    public String getVolumesString() {
        return this.getMountsString();
    }

    public String getDisplayName() {
        return "Image of " + this.getImage();
    }

    @CheckForNull
    public String[] getDockerCommandArray() {
        String[] dockerCommandArray = new String[]{};
        if (this.dockerCommand != null && !this.dockerCommand.isEmpty()) {
            dockerCommandArray = this.dockerCommand.split(" ");
        }
        return JenkinsUtils.fixEmpty(dockerCommandArray);
    }

    @NonNull
    public Iterable<PortBinding> getPortMappings() {
        if (Strings.isNullOrEmpty((String)this.bindPorts)) {
            return Collections.emptyList();
        }
        return Splitter.on((char)' ').trimResults().omitEmptyStrings().splitToStream((CharSequence)this.bindPorts).map(PortBinding::parse).collect(Collectors.toList());
    }

    public CreateContainerCmd fillContainerConfig(CreateContainerCmd containerConfig) {
        List<String> capabilitiesToDropOrNull;
        List<String> capabilitiesToAddOrNull;
        List<String> securityOptionsOrNull;
        Integer shmSizeOrNull;
        List<String> extraHostsOrNull;
        String macAddressOrNull;
        String[] devicesOrNull;
        String[] volumesFrom2OrNull;
        String[] mountsOrNull;
        String networkOrNull;
        String[] dnsSearchOrNull;
        String[] dnsHostsOrNull;
        String cgroupParentOrNull;
        Integer memorySwapOrNullOrNegative;
        Integer memoryLimitOrNull;
        Integer cpuSharesOrNull;
        Long cpuQuotaOrNull;
        Long cpuPeriodOrNull;
        HashMap<String, String> labels;
        String[] cmdOrNull;
        List<String> extraGroupsOrNull;
        String userOrNull;
        String hostnameOrNull = this.getHostname();
        if (hostnameOrNull != null && !hostnameOrNull.isEmpty()) {
            containerConfig.withHostName(hostnameOrNull);
        }
        if ((userOrNull = this.getUser()) != null && !userOrNull.isEmpty()) {
            containerConfig.withUser(userOrNull);
        }
        if (CollectionUtils.isNotEmpty(extraGroupsOrNull = this.getExtraGroups())) {
            DockerTemplateBase.hostConfig(containerConfig).withGroupAdd(extraGroupsOrNull);
        }
        if ((cmdOrNull = this.getDockerCommandArray()) != null && cmdOrNull.length > 0) {
            containerConfig.withCmd(cmdOrNull);
        }
        DockerTemplateBase.hostConfig(containerConfig).withPortBindings((PortBinding[])Iterables.toArray(this.getPortMappings(), PortBinding.class));
        DockerTemplateBase.hostConfig(containerConfig).withPublishAllPorts(Boolean.valueOf(this.bindAllPorts));
        DockerTemplateBase.hostConfig(containerConfig).withPrivileged(Boolean.valueOf(this.privileged));
        HashMap<String, String> existingLabelsOrNull = containerConfig.getLabels();
        if (existingLabelsOrNull == null) {
            labels = new HashMap<String, String>();
            containerConfig.withLabels(labels);
        } else {
            labels = existingLabelsOrNull;
        }
        Map<String, String> extraDockerLabelsOrNull = this.getExtraDockerLabels();
        if (extraDockerLabelsOrNull != null && !extraDockerLabelsOrNull.isEmpty()) {
            labels.putAll(extraDockerLabelsOrNull);
        }
        labels.put(DockerContainerLabelKeys.JENKINS_INSTANCE_ID, DockerTemplateBase.getJenkinsInstanceIdForContainerLabel());
        labels.put(DockerContainerLabelKeys.JENKINS_URL, DockerTemplateBase.getJenkinsUrlForContainerLabel());
        labels.put(DockerContainerLabelKeys.CONTAINER_IMAGE, this.getImage());
        String cpusOrNull = this.getCpus();
        if (cpusOrNull != null && !cpusOrNull.isEmpty()) {
            Double cpu_double = Double.parseDouble(cpusOrNull) * 1.0E9;
            Long nanoCpus = cpu_double.longValue();
            DockerTemplateBase.hostConfig(containerConfig).withNanoCPUs(nanoCpus);
        }
        if ((cpuPeriodOrNull = this.getCpuPeriod()) != null && cpuPeriodOrNull > 0L) {
            DockerTemplateBase.hostConfig(containerConfig).withCpuPeriod(cpuPeriodOrNull);
        }
        if ((cpuQuotaOrNull = this.getCpuQuota()) != null && cpuQuotaOrNull > 0L) {
            DockerTemplateBase.hostConfig(containerConfig).withCpuQuota(cpuQuotaOrNull);
        }
        if ((cpuSharesOrNull = this.getCpuShares()) != null && cpuSharesOrNull > 0) {
            DockerTemplateBase.hostConfig(containerConfig).withCpuShares(cpuSharesOrNull);
        }
        if ((memoryLimitOrNull = this.getMemoryLimit()) != null && memoryLimitOrNull > 0) {
            long memoryInByte = memoryLimitOrNull.longValue() * 1024L * 1024L;
            DockerTemplateBase.hostConfig(containerConfig).withMemory(Long.valueOf(memoryInByte));
        }
        if ((memorySwapOrNullOrNegative = this.getMemorySwap()) != null) {
            long memorySwapOrNegative = memorySwapOrNullOrNegative.longValue();
            if (memorySwapOrNegative > 0L) {
                long memorySwapInByte = memorySwapOrNegative * 1024L * 1024L;
                DockerTemplateBase.hostConfig(containerConfig).withMemorySwap(Long.valueOf(memorySwapInByte));
            } else {
                DockerTemplateBase.hostConfig(containerConfig).withMemorySwap(Long.valueOf(memorySwapOrNegative));
            }
        }
        if ((cgroupParentOrNull = this.getCgroupParent()) != null && !Strings.isNullOrEmpty((String)cgroupParentOrNull)) {
            DockerTemplateBase.hostConfig(containerConfig).withCgroupParent(cgroupParentOrNull);
        }
        if ((dnsHostsOrNull = this.getDnsHosts()) != null && dnsHostsOrNull.length > 0) {
            DockerTemplateBase.hostConfig(containerConfig).withDns(dnsHostsOrNull);
        }
        if ((dnsSearchOrNull = this.getDnsSearch()) != null && dnsSearchOrNull.length > 0) {
            DockerTemplateBase.hostConfig(containerConfig).withDnsSearch(dnsSearchOrNull);
        }
        if ((networkOrNull = this.getNetwork()) != null && networkOrNull.length() > 0) {
            containerConfig.withNetworkDisabled(Boolean.valueOf(false));
            DockerTemplateBase.hostConfig(containerConfig).withNetworkMode(networkOrNull);
        }
        if ((mountsOrNull = this.getMounts()) != null && mountsOrNull.length > 0) {
            ArrayList<Mount> mnts = new ArrayList<Mount>();
            DockerTemplateBase.parseMountsStrings(mountsOrNull, mnts);
            DockerTemplateBase.hostConfig(containerConfig).withMounts(mnts);
        }
        if ((volumesFrom2OrNull = this.getVolumesFrom2()) != null && volumesFrom2OrNull.length > 0) {
            ArrayList<VolumesFrom> volFrom = new ArrayList<VolumesFrom>();
            for (String volFromStr : volumesFrom2OrNull) {
                volFrom.add(VolumesFrom.parse((String)volFromStr));
            }
            DockerTemplateBase.hostConfig(containerConfig).withVolumesFrom(volFrom.toArray(new VolumesFrom[0]));
        }
        if ((devicesOrNull = this.getDevices()) != null && devicesOrNull.length > 0) {
            ArrayList<Device> list = new ArrayList<Device>();
            for (String deviceStr : devicesOrNull) {
                list.add(Device.parse((String)deviceStr));
            }
            DockerTemplateBase.hostConfig(containerConfig).withDevices(list);
        }
        containerConfig.withTty(Boolean.valueOf(this.tty));
        String[] environmentOrNull = this.getEnvironment();
        if (environmentOrNull != null && environmentOrNull.length > 0) {
            containerConfig.withEnv(environmentOrNull);
        }
        if ((macAddressOrNull = this.getMacAddress()) != null && !macAddressOrNull.isEmpty()) {
            containerConfig.withMacAddress(macAddressOrNull);
        }
        if (CollectionUtils.isNotEmpty(extraHostsOrNull = this.getExtraHosts())) {
            DockerTemplateBase.hostConfig(containerConfig).withExtraHosts(extraHostsOrNull.toArray(new String[0]));
        }
        if ((shmSizeOrNull = this.getShmSize()) != null && shmSizeOrNull > 0) {
            long shmSizeInByte = shmSizeOrNull.longValue() * 1024L * 1024L;
            DockerTemplateBase.hostConfig(containerConfig).withShmSize(Long.valueOf(shmSizeInByte));
        }
        if (CollectionUtils.isNotEmpty(securityOptionsOrNull = this.getSecurityOpts())) {
            DockerTemplateBase.hostConfig(containerConfig).withSecurityOpts(securityOptionsOrNull);
        }
        if (CollectionUtils.isNotEmpty(capabilitiesToAddOrNull = this.getCapabilitiesToAdd())) {
            DockerTemplateBase.hostConfig(containerConfig).withCapAdd(DockerTemplateBase.toCapabilities(capabilitiesToAddOrNull));
        }
        if (CollectionUtils.isNotEmpty(capabilitiesToDropOrNull = this.getCapabilitiesToDrop())) {
            DockerTemplateBase.hostConfig(containerConfig).withCapDrop(DockerTemplateBase.toCapabilities(capabilitiesToDropOrNull));
        }
        return containerConfig;
    }

    private static void parseMountsStrings(String[] mounts, List<Mount> mountListResult) {
        for (String mnt : mounts) {
            DockerTemplateBase.parseMountsString(mnt, mountListResult);
        }
    }

    private static void parseMountsString(String mnt, List<Mount> mountListResult) {
        String[] tokens;
        Mount mount = new Mount().withType(MountType.VOLUME);
        BindOptions bindOptions = null;
        TmpfsOptions tmpfsOptions = null;
        block22: for (String token : tokens = mnt.split(",")) {
            String[] parts = token.split("=");
            if (parts.length != 2 && (parts.length != 1 || !"ro".equals(parts[0]) && !"readonly".equals(parts[0]))) {
                throw new IllegalArgumentException("Invalid mount: expected key=value comma separated pairs, or 'ro' / 'readonly' keywords");
            }
            switch (parts[0]) {
                case "type": {
                    mount.withType(MountType.valueOf((String)parts[1].toUpperCase()));
                    continue block22;
                }
                case "src": 
                case "source": {
                    mount.withSource(parts[1]);
                    continue block22;
                }
                case "target": 
                case "destination": 
                case "dst": {
                    mount.withTarget(parts[1]);
                    continue block22;
                }
                case "ro": 
                case "readonly": {
                    String value;
                    String string = value = parts.length == 2 && parts[1] != null ? parts[1].trim() : "";
                    if (value.isEmpty() || "true".equalsIgnoreCase(value) || "1".equals(value)) {
                        mount.withReadOnly(Boolean.valueOf(true));
                        continue block22;
                    }
                    if (!"false".equalsIgnoreCase(value) && !"0".equals(value)) continue block22;
                    mount.withReadOnly(Boolean.valueOf(false));
                    continue block22;
                }
                case "bind-propagation": {
                    bindOptions = new BindOptions().withPropagation(BindPropagation.valueOf((String)((String)(parts[1].startsWith("r") ? "R_" + parts[1].substring(1) : parts[1])).toUpperCase()));
                    continue block22;
                }
                case "tmpfs-mode": {
                    if (tmpfsOptions == null) {
                        tmpfsOptions = new TmpfsOptions();
                    }
                    tmpfsOptions.withMode(Integer.valueOf(Integer.parseInt(parts[1], 8)));
                    continue block22;
                }
                case "tmpfs-size": {
                    if (tmpfsOptions == null) {
                        tmpfsOptions = new TmpfsOptions();
                    }
                    tmpfsOptions.withSizeBytes(Long.valueOf(Long.parseLong(parts[1])));
                    continue block22;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported keyword: " + parts[0]);
                }
            }
        }
        String target = mount.getTarget();
        if (target == null || target.isEmpty()) {
            throw new IllegalArgumentException("Invalid mount: target/destination must be set");
        }
        if (bindOptions != null) {
            mount.withBindOptions(bindOptions);
        }
        if (tmpfsOptions != null) {
            mount.withTmpfsOptions(tmpfsOptions);
        }
        mountListResult.add(mount);
    }

    private static String[] convertVolumes(String[] vols) {
        ArrayList<Object> mnts = new ArrayList<Object>();
        for (String vol : vols) {
            if (!vol.contains(":")) {
                mnts.add("type=volume,destination=" + vol);
                continue;
            }
            StringBuilder builder = new StringBuilder();
            if (vol.startsWith("/")) {
                Bind bind = Bind.parse((String)vol);
                builder.append("type=bind,source=");
                builder.append(bind.getPath());
                builder.append(",destination=");
                builder.append(bind.getVolume().getPath());
                if (bind.getAccessMode() == AccessMode.ro) {
                    builder.append(",readonly");
                }
                if (bind.getPropagationMode() != PropagationMode.DEFAULT) {
                    builder.append(",bind-propagation=");
                    builder.append(bind.getPropagationMode().toString());
                }
            } else {
                String[] parts = vol.split(":");
                builder.append("type=volume,source=");
                builder.append(parts[0]);
                builder.append(",destination=");
                builder.append(parts[1]);
                if (parts.length == 3 && ("readonly".equalsIgnoreCase(parts[2]) || "ro".equalsIgnoreCase(parts[2]))) {
                    builder.append(",readonly");
                }
            }
            mnts.add(builder.toString());
        }
        return mnts.toArray(new String[0]);
    }

    @NonNull
    private static HostConfig hostConfig(CreateContainerCmd containerConfig) {
        HostConfig hc = containerConfig.getHostConfig();
        if (hc == null) {
            throw new IllegalStateException("Can't find " + HostConfig.class.getCanonicalName() + " within " + CreateContainerCmd.class.getCanonicalName() + " " + String.valueOf(containerConfig));
        }
        return hc;
    }

    private static Capability[] toCapabilities(List<String> capabilitiesString) {
        ArrayList<Capability> res = new ArrayList<Capability>();
        for (String capability : capabilitiesString) {
            try {
                res.add(Capability.valueOf((String)capability));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid capability name : " + capability, e);
            }
        }
        return res.toArray(new Capability[0]);
    }

    @NonNull
    static String getJenkinsUrlForContainerLabel() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        String rootUrl = jenkins == null ? null : jenkins.getRootUrl();
        return Util.fixNull((String)rootUrl);
    }

    @NonNull
    static String getJenkinsInstanceIdForContainerLabel() {
        return JenkinsUtils.getInstanceId();
    }

    public Descriptor<DockerTemplateBase> getDescriptor() {
        return Jenkins.get().getDescriptor(DockerTemplateBase.class);
    }

    public String getFullImageId() {
        NameParser.ReposTag repostag = NameParser.parseRepositoryTag((String)this.image);
        if (repostag.tag.isEmpty()) {
            if (repostag.repos.contains("@sha256:")) {
                return repostag.repos;
            }
            return repostag.repos + ":latest";
        }
        return repostag.repos + ":" + repostag.tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerTemplateBase that = (DockerTemplateBase)o;
        if (this.bindAllPorts != that.bindAllPorts) {
            return false;
        }
        if (this.privileged != that.privileged) {
            return false;
        }
        if (this.tty != that.tty) {
            return false;
        }
        if (!this.image.equals(that.image)) {
            return false;
        }
        if (!Objects.equals(this.pullCredentialsId, that.pullCredentialsId)) {
            return false;
        }
        if (!Objects.equals(this.dockerCommand, that.dockerCommand)) {
            return false;
        }
        if (!Objects.equals(this.hostname, that.hostname)) {
            return false;
        }
        if (!Objects.equals(this.user, that.user)) {
            return false;
        }
        if (!Objects.equals(this.extraGroups, that.extraGroups)) {
            return false;
        }
        if (!Arrays.equals(this.dnsHosts, that.dnsHosts)) {
            return false;
        }
        if (!Arrays.equals(this.dnsSearch, that.dnsSearch)) {
            return false;
        }
        if (!Objects.equals(this.network, that.network)) {
            return false;
        }
        if (!Arrays.equals(this.mounts, that.mounts)) {
            return false;
        }
        if (!Arrays.equals(this.volumesFrom2, that.volumesFrom2)) {
            return false;
        }
        if (!Arrays.equals(this.devices, that.devices)) {
            return false;
        }
        if (!Arrays.equals(this.environment, that.environment)) {
            return false;
        }
        if (!Objects.equals(this.bindPorts, that.bindPorts)) {
            return false;
        }
        if (!Objects.equals(this.memoryLimit, that.memoryLimit)) {
            return false;
        }
        if (!Objects.equals(this.memorySwap, that.memorySwap)) {
            return false;
        }
        if (!Objects.equals(this.cgroupParent, that.cgroupParent)) {
            return false;
        }
        if (!Objects.equals(this.cpus, that.cpus)) {
            return false;
        }
        if (!Objects.equals(this.cpuPeriod, that.cpuPeriod)) {
            return false;
        }
        if (!Objects.equals(this.cpuQuota, that.cpuQuota)) {
            return false;
        }
        if (!Objects.equals(this.cpuShares, that.cpuShares)) {
            return false;
        }
        if (!Objects.equals(this.shmSize, that.shmSize)) {
            return false;
        }
        if (!Objects.equals(this.macAddress, that.macAddress)) {
            return false;
        }
        if (!Objects.equals(this.securityOpts, that.securityOpts)) {
            return false;
        }
        if (!Objects.equals(this.capabilitiesToAdd, that.capabilitiesToAdd)) {
            return false;
        }
        if (!Objects.equals(this.capabilitiesToDrop, that.capabilitiesToDrop)) {
            return false;
        }
        if (!Objects.equals(this.extraHosts, that.extraHosts)) {
            return false;
        }
        return Objects.equals(this.extraDockerLabels, that.extraDockerLabels);
    }

    public int hashCode() {
        int result = this.image.hashCode();
        result = 31 * result + (this.pullCredentialsId != null ? this.pullCredentialsId.hashCode() : 0);
        result = 31 * result + (this.dockerCommand != null ? this.dockerCommand.hashCode() : 0);
        result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.extraGroups != null ? this.extraGroups.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.dnsHosts);
        result = 31 * result + Arrays.hashCode(this.dnsSearch);
        result = 31 * result + (this.network != null ? this.network.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.mounts);
        result = 31 * result + Arrays.hashCode(this.volumesFrom2);
        result = 31 * result + Arrays.hashCode(this.devices);
        result = 31 * result + Arrays.hashCode(this.environment);
        result = 31 * result + (this.bindPorts != null ? this.bindPorts.hashCode() : 0);
        result = 31 * result + (this.bindAllPorts ? 1 : 0);
        result = 31 * result + (this.memoryLimit != null ? this.memoryLimit.hashCode() : 0);
        result = 31 * result + (this.memorySwap != null ? this.memorySwap.hashCode() : 0);
        result = 31 * result + (this.cgroupParent != null ? this.cgroupParent.hashCode() : 0);
        result = 31 * result + (this.cpus != null ? this.cpus.hashCode() : 0);
        result = 31 * result + (this.cpuPeriod != null ? this.cpuPeriod.hashCode() : 0);
        result = 31 * result + (this.cpuQuota != null ? this.cpuQuota.hashCode() : 0);
        result = 31 * result + (this.cpuShares != null ? this.cpuShares.hashCode() : 0);
        result = 31 * result + (this.shmSize != null ? this.shmSize.hashCode() : 0);
        result = 31 * result + (this.privileged ? 1 : 0);
        result = 31 * result + (this.securityOpts != null ? this.securityOpts.hashCode() : 0);
        result = 31 * result + (this.capabilitiesToAdd != null ? this.capabilitiesToAdd.hashCode() : 0);
        result = 31 * result + (this.capabilitiesToDrop != null ? this.capabilitiesToDrop.hashCode() : 0);
        result = 31 * result + (this.tty ? 1 : 0);
        result = 31 * result + (this.macAddress != null ? this.macAddress.hashCode() : 0);
        result = 31 * result + (this.extraHosts != null ? this.extraHosts.hashCode() : 0);
        result = 31 * result + (this.extraDockerLabels != null ? this.extraDockerLabels.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = JenkinsUtils.startToString(this);
        JenkinsUtils.bldToString(sb, "image", this.image);
        JenkinsUtils.bldToString(sb, "pullCredentialsId", this.pullCredentialsId);
        JenkinsUtils.bldToString(sb, "dockerCommand", this.dockerCommand);
        JenkinsUtils.bldToString(sb, "hostname", this.hostname);
        JenkinsUtils.bldToString(sb, "user", this.user);
        JenkinsUtils.bldToString(sb, "extraGroups", this.extraGroups);
        JenkinsUtils.bldToString(sb, "dnsHosts", this.dnsHosts);
        JenkinsUtils.bldToString(sb, "dnsSearch", this.dnsSearch);
        JenkinsUtils.bldToString(sb, "network'", this.network);
        JenkinsUtils.bldToString(sb, "mounts", this.mounts);
        JenkinsUtils.bldToString(sb, "volumesFrom2", this.volumesFrom2);
        JenkinsUtils.bldToString(sb, "devices", this.devices);
        JenkinsUtils.bldToString(sb, "environment", this.environment);
        JenkinsUtils.bldToString(sb, "bindPorts'", this.bindPorts);
        JenkinsUtils.bldToString(sb, "bindAllPorts", this.bindAllPorts);
        JenkinsUtils.bldToString(sb, "memoryLimit", this.memoryLimit);
        JenkinsUtils.bldToString(sb, "memorySwap", this.memorySwap);
        JenkinsUtils.bldToString(sb, "cgroupParent", this.cgroupParent);
        JenkinsUtils.bldToString(sb, "cpus", this.cpus);
        JenkinsUtils.bldToString(sb, "cpuPeriod", this.cpuPeriod);
        JenkinsUtils.bldToString(sb, "cpuQuota", this.cpuQuota);
        JenkinsUtils.bldToString(sb, "cpuShares", this.cpuShares);
        JenkinsUtils.bldToString(sb, "shmSize", this.shmSize);
        JenkinsUtils.bldToString(sb, "privileged", this.privileged);
        JenkinsUtils.bldToString(sb, "tty", this.tty);
        JenkinsUtils.bldToString(sb, "macAddress'", this.macAddress);
        JenkinsUtils.bldToString(sb, "extraHosts", this.extraHosts);
        JenkinsUtils.bldToString(sb, "securityOpts", this.securityOpts);
        JenkinsUtils.bldToString(sb, "capabilitiesToAdd", this.capabilitiesToAdd);
        JenkinsUtils.bldToString(sb, "capabilitiesToDrop", this.capabilitiesToDrop);
        JenkinsUtils.bldToString(sb, "extraDockerLabels", this.extraDockerLabels);
        JenkinsUtils.endToString(sb);
        return sb.toString();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DockerTemplateBase> {
        public FormValidation doCheckMountsString(@QueryParameter String mountsString) {
            try {
                String[] mounts = JenkinsUtils.splitAndFilterEmpty(mountsString, "\n");
                DockerTemplateBase.parseMountsStrings(mounts, new ArrayList<Mount>());
            }
            catch (Throwable t) {
                return FormValidation.error((String)t.getMessage());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVolumesFromString(@QueryParameter String volumesFromString) {
            try {
                String[] strings;
                for (String volFrom : strings = JenkinsUtils.splitAndFilterEmpty(volumesFromString, "\n")) {
                    VolumesFrom.parse((String)volFrom);
                }
            }
            catch (Throwable t) {
                return FormValidation.error((String)t.getMessage());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCpus(@QueryParameter String cpus) {
            try {
                if (cpus == null || cpus.isEmpty()) {
                    return FormValidation.ok();
                }
                Pattern pat = Pattern.compile("^(\\d+(\\.\\d+)?)$");
                if (!pat.matcher(cpus.trim()).matches()) {
                    return FormValidation.error((String)"Wrong cpus format: '%s' (floating point number expected) ", (Object[])new Object[]{cpus});
                }
            }
            catch (Throwable t) {
                return FormValidation.error((String)t.getMessage());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckExtraHostsString(@QueryParameter String extraHostsString) {
            List<String> extraHosts = JenkinsUtils.splitAndFilterEmptyList(extraHostsString, "\n");
            for (String extraHost : extraHosts) {
                if (extraHost.trim().split(":").length >= 2) continue;
                return FormValidation.error((String)"Wrong extraHost format: '%s'", (Object[])new Object[]{extraHost});
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSecurityOptsString(@QueryParameter String securityOptsString) {
            List<String> securityOpts = JenkinsUtils.splitAndFilterEmptyList(securityOptsString, "\n");
            for (String securityOpt : securityOpts) {
                if (securityOpt.trim().split("=").length == 2 || securityOpt.trim().startsWith("no-new-privileges")) continue;
                return FormValidation.warning((String)"Security option may be incorrect. Please double check syntax: '%s'", (Object[])new Object[]{securityOpt});
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCapabilitiesToAddString(@QueryParameter String capabilitiesToAddString) {
            return DescriptorImpl.doCheckCapabilitiesString(capabilitiesToAddString);
        }

        public FormValidation doCheckCapabilitiesToDropString(@QueryParameter String capabilitiesToDropString) {
            return DescriptorImpl.doCheckCapabilitiesString(capabilitiesToDropString);
        }

        private static FormValidation doCheckCapabilitiesString(String capabilitiesString) {
            List<String> capabilities = JenkinsUtils.splitAndFilterEmptyList(capabilitiesString, "\n");
            for (String capability : capabilities) {
                try {
                    Capability.valueOf((String)capability);
                }
                catch (IllegalArgumentException handledByCode) {
                    return FormValidation.error((String)"Wrong capability : %s", (Object[])new Object[]{capability});
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckExtraDockerLabelsString(@QueryParameter String extraDockerLabelsString) {
            List<String> extraDockerLabels = JenkinsUtils.splitAndFilterEmptyList(extraDockerLabelsString, "\n");
            for (String extraDockerLabel : extraDockerLabels) {
                if (extraDockerLabel.trim().split("=").length >= 2) continue;
                return FormValidation.error((String)"Invalid extraDockerLabel \"%s\" will be ignored", (Object[])new Object[]{extraDockerLabel});
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckExtraGroupsString(@QueryParameter String extraGroupsString) {
            List<String> extraGroups = JenkinsUtils.splitAndFilterEmptyList(extraGroupsString, "\n");
            Pattern pat = Pattern.compile("^(\\d+|[a-z_][a-z0-9_-]*[$]?)$");
            for (String extraGroup : extraGroups) {
                if (pat.matcher(extraGroup.trim()).matches()) continue;
                return FormValidation.error((String)"Wrong extraGroup format: '%s'", (Object[])new Object[]{extraGroup});
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillPullCredentialsIdItems(@AncestorInPath Item context) {
            DockerRegistryEndpoint.DescriptorImpl descriptor = (DockerRegistryEndpoint.DescriptorImpl)Jenkins.get().getDescriptorOrDie(DockerRegistryEndpoint.class);
            return descriptor.doFillCredentialsIdItems(context);
        }

        public String getDisplayName() {
            return "Docker template base";
        }
    }
}

