/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.ContainerConfig;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.PullResponseItem;
import com.google.common.base.Strings;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerContainerLabelKeys;
import com.nirima.jenkins.plugins.docker.DockerDisabled;
import com.nirima.jenkins.plugins.docker.DockerImagePullStrategy;
import com.nirima.jenkins.plugins.docker.DockerTemplateBase;
import com.nirima.jenkins.plugins.docker.launcher.DockerComputerLauncher;
import com.nirima.jenkins.plugins.docker.strategy.DockerOnceRetentionStrategy;
import com.nirima.jenkins.plugins.docker.utils.JenkinsUtils;
import com.nirima.jenkins.plugins.docker.utils.UniqueIdGenerator;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.slaves.RetentionStrategy;
import hudson.util.FormValidation;
import io.jenkins.docker.DockerTransientNode;
import io.jenkins.docker.client.DockerAPI;
import io.jenkins.docker.connector.DockerComputerConnector;
import io.jenkins.docker.connector.DockerComputerJNLPConnector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerTemplate
implements Describable<DockerTemplate> {
    public static final int DEFAULT_STOP_TIMEOUT = 10;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DockerTemplate.class.getName());
    private static final UniqueIdGenerator ID_GENERATOR = new UniqueIdGenerator(36);
    private static final String DEFAULT_NAME = "docker";
    private int configVersion = 2;
    @CheckForNull
    private final String labelString;
    @NonNull
    private DockerComputerConnector connector;
    @Deprecated
    private transient DockerComputerLauncher launcher;
    @CheckForNull
    public String remoteFs;
    public final int instanceCap;
    private Node.Mode mode = Node.Mode.NORMAL;
    private RetentionStrategy retentionStrategy = new DockerOnceRetentionStrategy(10);
    @NonNull
    private DockerTemplateBase dockerTemplateBase;
    private boolean removeVolumes;
    private int stopTimeout = 10;
    @NonNull
    private transient Set<LabelAtom> labelSet;
    @CheckForNull
    private DockerImagePullStrategy pullStrategy;
    private int pullTimeout;
    @CheckForNull
    private List<? extends NodeProperty<?>> nodeProperties;
    @CheckForNull
    private DockerDisabled disabled;
    @CheckForNull
    private String name;

    @Deprecated
    public DockerTemplate() {
        this(new DockerTemplateBase(""), new DockerComputerJNLPConnector(), null, "1");
    }

    public DockerTemplate(@NonNull DockerTemplateBase dockerTemplateBase, @NonNull DockerComputerConnector connector, String labelString, String remoteFs, String instanceCapStr) {
        this(dockerTemplateBase, connector, labelString, instanceCapStr);
        this.setRemoteFs(remoteFs);
    }

    @DataBoundConstructor
    public DockerTemplate(@NonNull DockerTemplateBase dockerTemplateBase, @NonNull DockerComputerConnector connector, String labelString, String instanceCapStr) {
        this.dockerTemplateBase = dockerTemplateBase;
        this.connector = connector;
        this.labelString = Util.fixEmpty((String)labelString);
        this.instanceCap = Strings.isNullOrEmpty((String)instanceCapStr) ? Integer.MAX_VALUE : Integer.parseInt(instanceCapStr);
        this.labelSet = Label.parse((String)labelString);
    }

    public String getImage() {
        return this.dockerTemplateBase.getImage();
    }

    public String getDnsString() {
        return this.dockerTemplateBase.getDnsString();
    }

    public String getDnsSearchString() {
        return this.dockerTemplateBase.getDnsSearchString();
    }

    @CheckForNull
    public String[] getMounts() {
        return this.dockerTemplateBase.getMounts();
    }

    public String getMountsString() {
        return this.dockerTemplateBase.getMountsString();
    }

    @Deprecated
    public String getVolumesFrom() {
        return this.dockerTemplateBase.getVolumesFrom();
    }

    public String[] getVolumesFrom2() {
        return this.dockerTemplateBase.getVolumesFrom2();
    }

    public String getVolumesFromString() {
        return this.dockerTemplateBase.getVolumesFromString();
    }

    @CheckForNull
    public String getMacAddress() {
        return this.dockerTemplateBase.getMacAddress();
    }

    public String getDisplayName() {
        return this.dockerTemplateBase.getDisplayName();
    }

    public Integer getMemoryLimit() {
        return this.dockerTemplateBase.getMemoryLimit();
    }

    public Integer getMemorySwap() {
        return this.dockerTemplateBase.getMemorySwap();
    }

    public String getCgroupParent() {
        return this.dockerTemplateBase.getCgroupParent();
    }

    public String getCpus() {
        return this.dockerTemplateBase.getCpus();
    }

    public Long getCpuPeriod() {
        return this.dockerTemplateBase.getCpuPeriod();
    }

    public Long getCpuQuota() {
        return this.dockerTemplateBase.getCpuQuota();
    }

    public Integer getCpuShares() {
        return this.dockerTemplateBase.getCpuShares();
    }

    public Integer getShmSize() {
        return this.dockerTemplateBase.getShmSize();
    }

    public String[] getDockerCommandArray() {
        return this.dockerTemplateBase.getDockerCommandArray();
    }

    public Iterable<PortBinding> getPortMappings() {
        return this.dockerTemplateBase.getPortMappings();
    }

    public String getEnvironmentsString() {
        return this.dockerTemplateBase.getEnvironmentsString();
    }

    @CheckForNull
    public List<String> getExtraHosts() {
        return this.dockerTemplateBase.getExtraHosts();
    }

    public String getExtraHostsString() {
        return this.dockerTemplateBase.getExtraHostsString();
    }

    @CheckForNull
    public List<String> getSecurityOpts() {
        return this.dockerTemplateBase.getSecurityOpts();
    }

    public String getSecurityOptsString() {
        return this.dockerTemplateBase.getSecurityOptsString();
    }

    @CheckForNull
    public List<String> getCapabilitiesToAdd() {
        return this.dockerTemplateBase.getCapabilitiesToAdd();
    }

    public String getCapabilitiesToAddString() {
        return this.dockerTemplateBase.getCapabilitiesToAddString();
    }

    @CheckForNull
    public List<String> getCapabilitiesToDrop() {
        return this.dockerTemplateBase.getCapabilitiesToDrop();
    }

    public String getCapabilitiesToDropString() {
        return this.dockerTemplateBase.getCapabilitiesToDropString();
    }

    public DockerRegistryEndpoint getRegistry() {
        return this.dockerTemplateBase.getRegistry();
    }

    public CreateContainerCmd fillContainerConfig(CreateContainerCmd containerConfig) {
        HashMap<String, String> labels;
        CreateContainerCmd result = this.dockerTemplateBase.fillContainerConfig(containerConfig);
        String templateName = this.getName();
        HashMap<String, String> existingLabels = containerConfig.getLabels();
        if (existingLabels == null) {
            labels = new HashMap<String, String>();
            containerConfig.withLabels(labels);
        } else {
            labels = existingLabels;
        }
        labels.put(DockerContainerLabelKeys.REMOVE_VOLUMES, Boolean.toString(this.isRemoveVolumes()));
        labels.put(DockerContainerLabelKeys.TEMPLATE_NAME, templateName);
        containerConfig.withLabels(labels);
        String nodeName = DockerTemplate.calcUnusedNodeName(templateName);
        DockerTemplate.setNodeNameInContainerConfig(result, nodeName);
        return result;
    }

    @Restricted(value={NoExternalUse.class})
    public static void setNodeNameInContainerConfig(CreateContainerCmd containerConfig, String nodeName) {
        HashMap<String, String> labels;
        HashMap<String, String> existingLabels = containerConfig.getLabels();
        if (existingLabels == null) {
            labels = new HashMap<String, String>();
            containerConfig.withLabels(labels);
        } else {
            labels = existingLabels;
        }
        labels.put(DockerContainerLabelKeys.NODE_NAME, nodeName);
    }

    @NonNull
    public static String getNodeNameFromContainerConfig(CreateContainerCmd containerConfig) {
        String result;
        Map labels = containerConfig.getLabels();
        String string = result = labels == null ? null : (String)labels.get(DockerContainerLabelKeys.NODE_NAME);
        if (result == null) {
            throw new IllegalStateException("Internal Error: containerConfig does not have a label " + DockerContainerLabelKeys.NODE_NAME + " set");
        }
        return result;
    }

    public String getFullImageId() {
        return this.dockerTemplateBase.getFullImageId();
    }

    public DockerTemplateBase getDockerTemplateBase() {
        return this.dockerTemplateBase;
    }

    public boolean isRemoveVolumes() {
        return this.removeVolumes;
    }

    @DataBoundSetter
    public void setRemoveVolumes(boolean removeVolumes) {
        this.removeVolumes = removeVolumes;
    }

    public int getStopTimeout() {
        return this.stopTimeout;
    }

    @DataBoundSetter
    public void setStopTimeout(int timeout) {
        this.stopTimeout = timeout;
    }

    @CheckForNull
    public String getLabelString() {
        return this.labelString;
    }

    @DataBoundSetter
    public void setMode(Node.Mode mode) {
        this.mode = mode;
    }

    public Node.Mode getMode() {
        return this.mode;
    }

    public int getNumExecutors() {
        return 1;
    }

    @DataBoundSetter
    public void setRetentionStrategy(DockerOnceRetentionStrategy retentionStrategy) {
        this.retentionStrategy = retentionStrategy;
    }

    public RetentionStrategy getRetentionStrategy() {
        return this.retentionStrategy;
    }

    @NonNull
    public DockerComputerConnector getConnector() {
        return this.connector;
    }

    @CheckForNull
    public String getRemoteFs() {
        return Util.fixEmpty((String)this.remoteFs);
    }

    @DataBoundSetter
    public void setRemoteFs(String remoteFs) {
        this.remoteFs = Util.fixEmpty((String)remoteFs);
    }

    public String getInstanceCapStr() {
        if (this.instanceCap == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.instanceCap);
    }

    public int getInstanceCap() {
        return this.instanceCap;
    }

    @NonNull
    public Set<LabelAtom> getLabelSet() {
        return this.labelSet;
    }

    @NonNull
    public DockerImagePullStrategy getPullStrategy() {
        return this.pullStrategy != null ? this.pullStrategy : DockerImagePullStrategy.PULL_LATEST;
    }

    @DataBoundSetter
    public void setPullStrategy(DockerImagePullStrategy pullStrategy) {
        this.pullStrategy = pullStrategy == DockerImagePullStrategy.PULL_LATEST ? null : pullStrategy;
    }

    public int getPullTimeout() {
        return this.pullTimeout;
    }

    @DataBoundSetter
    public void setPullTimeout(int pullTimeout) {
        this.pullTimeout = pullTimeout;
    }

    @CheckForNull
    public List<? extends NodeProperty<?>> getNodeProperties() {
        List<? extends NodeProperty<?>> nullOrNotEmpty = JenkinsUtils.fixEmpty(this.nodeProperties);
        if (nullOrNotEmpty == null) {
            return null;
        }
        return Collections.unmodifiableList(nullOrNotEmpty);
    }

    @DataBoundSetter
    public void setNodeProperties(List<? extends NodeProperty<?>> nodeProperties) {
        this.nodeProperties = JenkinsUtils.fixEmpty(nodeProperties);
    }

    public DockerDisabled getDisabled() {
        return this.disabled == null ? new DockerDisabled() : this.disabled;
    }

    @DataBoundSetter
    public void setDisabled(DockerDisabled disabled) {
        this.disabled = disabled;
    }

    @DataBoundSetter
    public void setName(String name) {
        String trimmedName;
        this.name = name == null ? null : ((trimmedName = name.trim()).equals(DEFAULT_NAME) || trimmedName.isEmpty() ? null : trimmedName);
    }

    @NonNull
    public String getName() {
        if (this.name == null || this.name.trim().isEmpty()) {
            return DEFAULT_NAME;
        }
        return this.name.trim();
    }

    private void configDefaults() {
        if (this.mode == null) {
            this.mode = Node.Mode.NORMAL;
        }
        if (this.retentionStrategy == null) {
            this.retentionStrategy = new DockerOnceRetentionStrategy(10);
        }
    }

    protected Object readResolve() {
        try {
            if (this.configVersion < 2) {
                DockerOnceRetentionStrategy tmpStrategy;
                if (this.retentionStrategy instanceof DockerOnceRetentionStrategy && (tmpStrategy = (DockerOnceRetentionStrategy)this.retentionStrategy).getIdleMinutes() == 0) {
                    this.setRetentionStrategy(new DockerOnceRetentionStrategy(10));
                }
                this.configVersion = 2;
            } else {
                this.configDefaults();
            }
            try {
                this.labelSet = Label.parse((String)this.labelString);
            }
            catch (Throwable t) {
                LOGGER.error("Can't parse labels: ", t);
            }
            if (this.connector == null) {
                this.connector = this.launcher != null ? this.launcher.convertToConnector() : new DockerComputerJNLPConnector();
            }
        }
        catch (Throwable t) {
            LOGGER.error("Can't convert old values to new (double conversion?): ", t);
        }
        return this;
    }

    @Restricted(value={NoExternalUse.class})
    public DockerTemplate cloneWithLabel(String label) {
        DockerTemplate template = new DockerTemplate(this.dockerTemplateBase, this.connector, label, this.remoteFs, "1");
        template.setMode(Node.Mode.EXCLUSIVE);
        template.setPullStrategy(this.getPullStrategy());
        template.setRemoveVolumes(this.removeVolumes);
        template.setStopTimeout(this.stopTimeout);
        template.setRetentionStrategy((DockerOnceRetentionStrategy)this.retentionStrategy);
        template.setNodeProperties(JenkinsUtils.makeCopyOfList(this.getNodeProperties()));
        return template;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DockerTemplate other = (DockerTemplate)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.labelString, other.labelString) && this.configVersion == other.configVersion && this.instanceCap == other.instanceCap && this.mode == other.mode && this.pullTimeout == other.pullTimeout && this.removeVolumes == other.removeVolumes && this.stopTimeout == other.stopTimeout && Objects.equals((Object)this.connector, (Object)other.connector) && Objects.equals(this.remoteFs, other.remoteFs) && Objects.equals(this.dockerTemplateBase, other.dockerTemplateBase) && Objects.equals(this.retentionStrategy, other.retentionStrategy) && Objects.equals(this.getNodeProperties(), other.getNodeProperties()) && this.getPullStrategy() == other.getPullStrategy() && Objects.equals(this.getDisabled(), other.getDisabled());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.labelString, this.configVersion, this.instanceCap, this.mode, this.pullTimeout, this.removeVolumes, this.stopTimeout, this.connector, this.remoteFs, this.dockerTemplateBase, this.retentionStrategy, this.getNodeProperties(), this.getPullStrategy(), this.getDisabled()});
    }

    public String toString() {
        StringBuilder sb = JenkinsUtils.startToString(this);
        JenkinsUtils.bldToString(sb, "configVersion", this.configVersion);
        JenkinsUtils.bldToString(sb, "labelString", this.labelString);
        JenkinsUtils.bldToString(sb, "connector", (Object)this.connector);
        JenkinsUtils.bldToString(sb, "remoteFs", this.remoteFs);
        JenkinsUtils.bldToString(sb, "instanceCap", this.instanceCap);
        JenkinsUtils.bldToString(sb, "mode", this.mode);
        JenkinsUtils.bldToString(sb, "retentionStrategy", this.retentionStrategy);
        JenkinsUtils.bldToString(sb, "dockerTemplateBase", this.dockerTemplateBase);
        JenkinsUtils.bldToString(sb, "removeVolumes", this.removeVolumes);
        JenkinsUtils.bldToString(sb, "stopTimeout", this.stopTimeout);
        JenkinsUtils.bldToString(sb, "pullStrategy", (Object)this.getPullStrategy());
        JenkinsUtils.bldToString(sb, "pullTimeout", this.pullTimeout);
        JenkinsUtils.bldToString(sb, "nodeProperties", this.getNodeProperties());
        JenkinsUtils.bldToString(sb, "disabled", this.getDisabled());
        JenkinsUtils.bldToString(sb, "name", this.name);
        JenkinsUtils.endToString(sb);
        return sb.toString();
    }

    public String getShortDescription() {
        return "DockerTemplate{image=" + this.dockerTemplateBase.getImage() + "}";
    }

    public Descriptor<DockerTemplate> getDescriptor() {
        return Jenkins.get().getDescriptor(this.getClass());
    }

    @NonNull
    InspectImageResponse pullImage(DockerAPI api, final TaskListener listener) throws IOException, InterruptedException {
        InspectImageResponse result;
        boolean shouldPullImage;
        String image = this.getFullImageId();
        try (DockerClient client = api.getClient();){
            shouldPullImage = this.getPullStrategy().shouldPullImage(client, image);
        }
        if (shouldPullImage) {
            LOGGER.info("Pulling image '{}'. This may take awhile...", (Object)image);
            long startTime = System.currentTimeMillis();
            try (DockerClient client = api.getClient(this.pullTimeout);){
                PullImageCmd cmd = client.pullImageCmd(image);
                DockerRegistryEndpoint registry = this.getRegistry();
                DockerCloud.setRegistryAuthentication(cmd, registry, (ItemGroup)Jenkins.get());
                (cmd.exec((ResultCallback)new PullImageResultCallback(){

                    public void onNext(PullResponseItem item) {
                        super.onNext(item);
                        listener.getLogger().println(item.getStatus());
                    }
                })).awaitCompletion();
            }
            long pullTime = System.currentTimeMillis() - startTime;
            LOGGER.info("Finished pulling image '{}', took {} ms", (Object)image, (Object)pullTime);
        }
        try (DockerClient client = api.getClient();){
            result = client.inspectImageCmd(image).exec();
        }
        catch (NotFoundException e) {
            throw new DockerClientException("Could not pull image: " + image, (Throwable)e);
        }
        return result;
    }

    @Restricted(value={NoExternalUse.class})
    public DockerTransientNode provisionNode(DockerAPI api, TaskListener listener) throws IOException, Descriptor.FormException, InterruptedException {
        DockerTransientNode dockerTransientNode;
        block9: {
            InspectImageResponse image = this.pullImage(api, listener);
            String effectiveRemoteFsDir = this.getEffectiveRemoteFs(image);
            DockerClient client = api.getClient();
            try {
                dockerTransientNode = this.doProvisionNode(api, client, effectiveRemoteFsDir, listener);
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Descriptor.FormException | IOException | InterruptedException | RuntimeException ex) {
                    long milliseconds;
                    DockerCloud ourCloud = DockerCloud.findCloudForTemplate(this);
                    long l = milliseconds = ourCloud == null ? 0L : ourCloud.getEffectiveErrorDurationInMilliseconds();
                    if (milliseconds > 0L) {
                        String reason = "Template provisioning failed.";
                        DockerDisabled reasonForDisablement = this.getDisabled();
                        reasonForDisablement.disableBySystem("Template provisioning failed.", milliseconds, ex);
                        this.setDisabled(reasonForDisablement);
                    }
                    throw ex;
                }
            }
            client.close();
        }
        return dockerTransientNode;
    }

    @NonNull
    private String getEffectiveRemoteFs(InspectImageResponse image) {
        String containerWorkingDir;
        String remoteFsOrNull = this.getRemoteFs();
        if (remoteFsOrNull != null) {
            return remoteFsOrNull;
        }
        ContainerConfig containerConfig = image.getContainerConfig();
        String string = containerWorkingDir = containerConfig == null ? null : containerConfig.getWorkingDir();
        if (containerWorkingDir == null || containerWorkingDir.isBlank()) {
            ContainerConfig config = image.getConfig();
            String string2 = containerWorkingDir = config == null ? null : config.getWorkingDir();
        }
        if (!StringUtils.isBlank((String)containerWorkingDir)) {
            return containerWorkingDir;
        }
        return "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DockerTransientNode doProvisionNode(DockerAPI api, DockerClient client, String effectiveRemoteFsDir, TaskListener listener) throws IOException, Descriptor.FormException, InterruptedException {
        String ourImage = this.getImage();
        LOGGER.info("Trying to run container for image \"{}\"", (Object)ourImage);
        DockerComputerConnector ourConnector = this.getConnector();
        CreateContainerCmd cmd = client.createContainerCmd(ourImage);
        this.fillContainerConfig(cmd);
        ourConnector.beforeContainerCreated(api, effectiveRemoteFsDir, cmd);
        String nodeName = DockerTemplate.getNodeNameFromContainerConfig(cmd);
        LOGGER.info("Trying to run container for node {} from image: {}", (Object)nodeName, (Object)ourImage);
        boolean finallyRemoveTheContainer = true;
        String containerId = cmd.exec().getId();
        LOGGER.info("Started container ID {} for node {} from image: {}", new Object[]{containerId, nodeName, ourImage});
        try {
            DockerTransientNode node = new DockerTransientNode(nodeName, containerId, effectiveRemoteFsDir);
            node.setNodeDescription("Docker Agent [" + ourImage + " on " + api.getDockerHost().getUri() + " ID " + containerId + "]");
            node.setMode(this.getMode());
            node.setLabelString(this.getLabelString());
            node.setRetentionStrategy(JenkinsUtils.makeCopy(this.getRetentionStrategy()));
            DockerTemplate.robustlySetNodeProperties(node, JenkinsUtils.makeCopyOfList(this.getNodeProperties()));
            node.setRemoveVolumes(this.isRemoveVolumes());
            node.setStopTimeout(this.getStopTimeout());
            node.setDockerAPI(api);
            ourConnector.beforeContainerStarted(api, effectiveRemoteFsDir, node);
            client.startContainerCmd(containerId).exec();
            ourConnector.afterContainerStarted(api, effectiveRemoteFsDir, node);
            ComputerLauncher nodeLauncher = ourConnector.createLauncher(api, containerId, effectiveRemoteFsDir, listener);
            node.setLauncher(nodeLauncher);
            finallyRemoveTheContainer = false;
            DockerTransientNode dockerTransientNode = node;
            return dockerTransientNode;
        }
        finally {
            if (finallyRemoveTheContainer) {
                try {
                    client.removeContainerCmd(containerId).withForce(Boolean.valueOf(true)).exec();
                }
                catch (NotFoundException handledByCode) {
                    LOGGER.info("Unable to remove container '" + containerId + "' as it had already gone.");
                }
                catch (Throwable ex) {
                    LOGGER.error("Unable to remove container '" + containerId + "' due to exception:", ex);
                }
            }
        }
    }

    private static String calcUnusedNodeName(String templateName) {
        String nodeName;
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        do {
            String uniqueId = ID_GENERATOR.getUniqueId();
            nodeName = templateName + "-" + uniqueId;
        } while (jenkins != null && jenkins.getNode(nodeName) != null);
        return nodeName;
    }

    private static void robustlySetNodeProperties(DockerTransientNode node, List<? extends NodeProperty<?>> nodeProperties) throws IOException {
        if (nodeProperties == null || nodeProperties.isEmpty()) {
            return;
        }
        int maxAttempts = 10;
        int attempt = 1;
        while (true) {
            try {
                node.setNodeProperties(nodeProperties);
                return;
            }
            catch (IOException | RuntimeException ex) {
                if (attempt > 10) {
                    throw ex;
                }
                long delayInMilliseconds = 100L * (long)attempt;
                try {
                    Thread.sleep(delayInMilliseconds);
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                ++attempt;
                continue;
            }
            break;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<DockerTemplate> {
        public List<NodePropertyDescriptor> getNodePropertiesDescriptors() {
            ArrayList<NodePropertyDescriptor> result = new ArrayList<NodePropertyDescriptor>();
            DescriptorExtensionList list = Jenkins.get().getDescriptorList(NodeProperty.class);
            for (NodePropertyDescriptor npd : DescriptorVisibilityFilter.applyType(DockerTransientNode.class, (Iterable)list)) {
                if (!npd.isApplicable(DockerTransientNode.class)) continue;
                result.add(npd);
            }
            result.removeIf(de -> "org.jenkinsci.plugins.matrixauth.AuthorizationMatrixNodeProperty".equals(de.getKlass().toJavaClass().getName()));
            return result;
        }

        public Descriptor getRetentionStrategyDescriptor() {
            return Jenkins.get().getDescriptor(DockerOnceRetentionStrategy.class);
        }

        public FormValidation doCheckPullTimeout(@QueryParameter String value) {
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        public FormValidation doCheckStopTimeout(@QueryParameter String value) {
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        public String getDisplayName() {
            return "Docker Template";
        }

        public Class getDockerTemplateBase() {
            return DockerTemplateBase.class;
        }
    }
}

