/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.github.dockerjava.api.DockerClient;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerManagement;
import com.nirima.jenkins.plugins.docker.utils.JenkinsUtils;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import io.jenkins.docker.client.DockerAPI;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class DockerManagementServer
implements Describable<DockerManagementServer> {
    final String name;
    final DockerCloud theCloud;

    public Descriptor<DockerManagementServer> getDescriptor() {
        return Jenkins.get().getDescriptorByType(DescriptorImpl.class);
    }

    public String getUrl() {
        return DockerManagement.get().getUrlName() + "/server/" + this.name;
    }

    public DockerManagementServer(String name) {
        this.name = name;
        this.theCloud = JenkinsUtils.getCloudByNameOrThrow(name);
    }

    public Collection getImages() {
        Collection collection;
        block9: {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return Collections.emptyList();
            }
            DockerAPI dockerApi = this.theCloud.getDockerApi();
            DockerClient client = dockerApi.getClient();
            try {
                collection = (Collection)client.listImagesCmd().exec();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            client.close();
        }
        return collection;
    }

    public Collection getProcesses() {
        Collection collection;
        block9: {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return Collections.emptyList();
            }
            DockerAPI dockerApi = this.theCloud.getDockerApi();
            DockerClient client = dockerApi.getClient();
            try {
                collection = (Collection)client.listContainersCmd().exec();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            client.close();
        }
        return collection;
    }

    public String asTime(Long time) {
        if (time == null) {
            return "";
        }
        long when = System.currentTimeMillis() - time;
        Date dt = new Date(when);
        return dt.toString();
    }

    @RequirePOST
    public void doControlSubmit(@QueryParameter(value="stopId") String stopId, StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        DockerAPI dockerApi = this.theCloud.getDockerApi();
        try (DockerClient client = dockerApi.getClient();){
            client.stopContainerCmd(stopId).exec();
        }
        rsp.sendRedirect(".");
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<DockerManagementServer> {
        public String getDisplayName() {
            return "server ";
        }
    }
}

