/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.github.dockerjava.api.DockerClient;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerManagementServer;
import com.nirima.jenkins.plugins.docker.Messages;
import com.nirima.jenkins.plugins.docker.utils.JenkinsUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ManagementLink;
import hudson.model.Saveable;
import io.jenkins.docker.client.DockerAPI;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerProxy;

@Extension
public class DockerManagement
extends ManagementLink
implements StaplerProxy,
Describable<DockerManagement>,
Saveable {
    public String getIconFileName() {
        return "symbol-logo-docker plugin-ionicons-api";
    }

    public String getUrlName() {
        return "docker-plugin";
    }

    public String getDisplayName() {
        return Messages.displayName();
    }

    public String getDescription() {
        return Messages.pluginDescription();
    }

    public static DockerManagement get() {
        return (DockerManagement)((Object)ManagementLink.all().get(DockerManagement.class));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
    }

    public void save() throws IOException {
    }

    public DockerManagementServer getServer(String serverName) {
        return new DockerManagementServer(serverName);
    }

    public Object getTarget() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        return this;
    }

    @NonNull
    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.CONFIGURATION;
    }

    public Collection<String> getServerNames() {
        return JenkinsUtils.getServerNames();
    }

    public Collection<ServerDetail> getServers() {
        return DockerCloud.instances().stream().map(ServerDetail::new).collect(Collectors.toList());
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<DockerManagement> {
        public String getDisplayName() {
            return DockerManagement.class.getSimpleName();
        }
    }

    public static class ServerDetail {
        final DockerCloud cloud;

        public ServerDetail(DockerCloud cloud) {
            this.cloud = cloud;
        }

        public String getName() {
            return this.cloud.getDisplayName();
        }

        public String getActiveHosts() {
            try {
                List containers;
                DockerAPI dockerApi = this.cloud.getDockerApi();
                try (DockerClient client = dockerApi.getClient();){
                    containers = (List)client.listContainersCmd().exec();
                }
                return "(" + containers.size() + ")";
            }
            catch (Exception ex) {
                return "Error: " + String.valueOf(ex);
            }
        }
    }
}

