/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.Version;
import com.nirima.jenkins.plugins.docker.DockerContainerLabelKeys;
import com.nirima.jenkins.plugins.docker.DockerDisabled;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import com.nirima.jenkins.plugins.docker.DockerTemplateBase;
import com.nirima.jenkins.plugins.docker.utils.JenkinsUtils;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import io.jenkins.docker.DockerTransientNode;
import io.jenkins.docker.client.DockerAPI;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedPlannedNode;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryToken;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerEndpoint;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerCloud
extends Cloud {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerCloud.class);
    private static final int ERROR_DURATION_DEFAULT_SECONDS = 300;
    @CheckForNull
    private List<DockerTemplate> templates;
    @CheckForNull
    private transient Map<Long, DockerTemplate> jobTemplates;
    @Deprecated
    private transient DockerServerEndpoint dockerHost;
    @Deprecated
    private transient String serverUrl;
    @Deprecated
    public transient String credentialsId;
    @Deprecated
    private transient int connectTimeout;
    @Deprecated
    private transient int readTimeout;
    @Deprecated
    private transient String version;
    @Deprecated
    private transient String dockerHostname;
    private DockerAPI dockerApi;
    private int containerCap = 100;
    private transient Boolean _isTriton;
    @Restricted(value={NoExternalUse.class})
    static final Map<String, Map<String, Integer>> CONTAINERS_IN_PROGRESS = new HashMap<String, Map<String, Integer>>();
    private boolean exposeDockerHost;
    @CheckForNull
    private DockerDisabled disabled;
    @CheckForNull
    private Integer errorDuration;

    @DataBoundConstructor
    public DockerCloud(String name, DockerAPI dockerApi, List<DockerTemplate> templates) {
        super(name);
        this.dockerApi = dockerApi;
        this.templates = templates;
        if (name == null || name.isBlank()) {
            LOGGER.warn("Docker cloud requires a non-blank name after Jenkins 2.402");
        }
    }

    public DockerCloud(@NonNull String name, @NonNull DockerCloud source) {
        super(name);
        this.dockerApi = source.dockerApi;
        this.templates = source.templates;
    }

    @Deprecated
    public DockerCloud(String name, List<DockerTemplate> templates, DockerServerEndpoint dockerHost, int containerCap, int connectTimeout, int readTimeout, String version, String dockerHostname) {
        this(name, new DockerAPI(dockerHost, connectTimeout, readTimeout, version, dockerHostname), templates);
        this.setContainerCap(containerCap);
    }

    @Deprecated
    public DockerCloud(String name, List<DockerTemplate> templates, String serverUrl, int containerCap, int connectTimeout, int readTimeout, String credentialsId, String version, String dockerHostname) {
        this(name, templates, new DockerServerEndpoint(serverUrl, credentialsId), containerCap, connectTimeout, readTimeout, version, dockerHostname);
    }

    @Deprecated
    public DockerCloud(String name, List<DockerTemplate> templates, String serverUrl, String containerCapStr, int connectTimeout, int readTimeout, String credentialsId, String version, String dockerHostname) {
        this(name, templates, serverUrl, containerCapStr.equals("") ? Integer.MAX_VALUE : Integer.parseInt(containerCapStr), connectTimeout, readTimeout, credentialsId, version, dockerHostname);
    }

    public DockerAPI getDockerApi() {
        return this.dockerApi;
    }

    @Deprecated
    public int getConnectTimeout() {
        return this.dockerApi.getConnectTimeout();
    }

    @Deprecated
    public DockerServerEndpoint getDockerHost() {
        return this.dockerApi.getDockerHost();
    }

    @Deprecated
    public String getServerUrl() {
        return this.getDockerHost().getUri();
    }

    @Deprecated
    public String getDockerHostname() {
        return this.dockerApi.getHostname();
    }

    @Deprecated
    public String getContainerCapStr() {
        if (this.containerCap == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.containerCap);
    }

    public int getContainerCap() {
        return this.containerCap;
    }

    @DataBoundSetter
    public void setContainerCap(int containerCap) {
        this.containerCap = containerCap;
    }

    protected String sanitizeUrl(String url) {
        if (url == null) {
            return null;
        }
        return url.replace("http:", "tcp:").replace("https:", "tcp:");
    }

    @Deprecated
    public DockerClient getClient() {
        try {
            DockerClient client = this.dockerApi.getClient();
            client.close();
            return client;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    void decrementContainersInProgress(DockerTemplate template) {
        DockerCloud.adjustContainersInProgress(this, template, -1);
    }

    void incrementContainersInProgress(DockerTemplate template) {
        DockerCloud.adjustContainersInProgress(this, template, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void adjustContainersInProgress(DockerCloud cloud, DockerTemplate template, int adjustment) {
        String cloudId = cloud.name;
        String templateId = DockerCloud.getTemplateId(template);
        Map<String, Map<String, Integer>> map = CONTAINERS_IN_PROGRESS;
        synchronized (map) {
            Map mapForThisCloud = CONTAINERS_IN_PROGRESS.computeIfAbsent(cloudId, unused -> new HashMap());
            Integer oldValue = (Integer)mapForThisCloud.get(templateId);
            int oldNumber = oldValue == null ? 0 : oldValue;
            int newNumber = oldNumber + adjustment;
            if (newNumber != 0) {
                mapForThisCloud.put(templateId, newNumber);
            } else {
                mapForThisCloud.remove(templateId);
                if (mapForThisCloud.isEmpty()) {
                    CONTAINERS_IN_PROGRESS.remove(cloudId);
                }
            }
        }
    }

    private static String getTemplateId(DockerTemplate template) {
        String templateId = template.getImage();
        return templateId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={NoExternalUse.class})
    public int countContainersInProgress(DockerTemplate template) {
        String cloudId = this.name;
        String templateId = DockerCloud.getTemplateId(template);
        Map<String, Map<String, Integer>> map = CONTAINERS_IN_PROGRESS;
        synchronized (map) {
            Map<String, Integer> allInProgressOrNull = CONTAINERS_IN_PROGRESS.get(cloudId);
            Integer templateInProgressOrNull = allInProgressOrNull == null ? null : allInProgressOrNull.get(templateId);
            int templateInProgress = templateInProgressOrNull == null ? 0 : templateInProgressOrNull;
            return templateInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int countContainersInProgress() {
        String cloudId = this.name;
        Map<String, Map<String, Integer>> map = CONTAINERS_IN_PROGRESS;
        synchronized (map) {
            Map<String, Integer> allInProgressOrNull = CONTAINERS_IN_PROGRESS.get(cloudId);
            int totalInProgressForCloud = 0;
            if (allInProgressOrNull != null) {
                for (int count : allInProgressOrNull.values()) {
                    totalInProgressForCloud += count;
                }
            }
            return totalInProgressForCloud;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<NodeProvisioner.PlannedNode> provision(Label label, int numberOfExecutorsRequired) {
        if (this.getDisabled().isDisabled()) {
            return Collections.emptyList();
        }
        try {
            LOGGER.debug("Asked to provision {} agent(s) for: {}", (Object)numberOfExecutorsRequired, (Object)label);
            ArrayList<NodeProvisioner.PlannedNode> r = new ArrayList<NodeProvisioner.PlannedNode>();
            List<DockerTemplate> matchingTemplates = this.getTemplates(label);
            int remainingWorkload = numberOfExecutorsRequired;
            for (DockerTemplate t : matchingTemplates) {
                int numberOfContainersInProgress = this.countContainersInProgress(t);
                int numberOfExecutorsInProgress = t.getNumExecutors() * numberOfContainersInProgress;
                remainingWorkload -= numberOfExecutorsInProgress;
            }
            if (remainingWorkload != numberOfExecutorsRequired) {
                int numberOfExecutorsInProgress = numberOfExecutorsRequired - remainingWorkload;
                if (remainingWorkload <= 0) {
                    LOGGER.debug("Not provisioning additional agents for {}; we have {} executors being started already", (Object)label, (Object)numberOfExecutorsInProgress);
                } else {
                    LOGGER.debug("Only provisioning {} agents for {}; we have {} executors being started already", new Object[]{remainingWorkload, label, numberOfExecutorsInProgress});
                }
            }
            while (remainingWorkload > 0 && !matchingTemplates.isEmpty()) {
                final DockerTemplate t = matchingTemplates.get(0);
                boolean thereIsCapacityToProvisionFromThisTemplate = this.canAddProvisionedAgent(t);
                if (!thereIsCapacityToProvisionFromThisTemplate) {
                    matchingTemplates.remove(t);
                    continue;
                }
                LOGGER.info("Will provision '{}', for label: '{}', in cloud: '{}'", new Object[]{t.getImage(), label, this.getDisplayName()});
                final ProvisioningActivity.Id id = new ProvisioningActivity.Id(this.name, t.getName() + " (" + t.getImage() + ")", null);
                final CompletableFuture plannedNode = new CompletableFuture();
                r.add((NodeProvisioner.PlannedNode)new TrackedPlannedNode(id, t.getNumExecutors(), plannedNode));
                Runnable taskToCreateNewAgent = new Runnable(){

                    @Override
                    public void run() {
                        DockerTransientNode agent = null;
                        try {
                            DockerAPI api = DockerCloud.this.getDockerApi();
                            agent = t.provisionNode(api, TaskListener.NULL);
                            agent.setDockerAPI(api);
                            agent.setCloudId(DockerCloud.this.name);
                            agent.setProvisioningId(id);
                            plannedNode.complete(agent);
                            agent.robustlyAddToJenkins();
                        }
                        catch (Exception ex) {
                            LOGGER.error("Error in provisioning; template='{}' for cloud='{}'", new Object[]{t, DockerCloud.this.getDisplayName(), ex});
                            plannedNode.completeExceptionally(ex);
                            if (agent != null) {
                                agent.terminate(LOGGER);
                            }
                            if (ex instanceof RuntimeException) {
                                throw (RuntimeException)ex;
                            }
                            if (ex instanceof IOException) {
                                throw new UncheckedIOException((IOException)ex);
                            }
                            throw new RuntimeException(ex);
                        }
                        finally {
                            DockerCloud.this.decrementContainersInProgress(t);
                        }
                    }
                };
                boolean taskToCreateAgentHasBeenQueuedSoItWillDoTheDecrement = false;
                this.incrementContainersInProgress(t);
                try {
                    Computer.threadPoolForRemoting.submit(taskToCreateNewAgent);
                    taskToCreateAgentHasBeenQueuedSoItWillDoTheDecrement = true;
                }
                finally {
                    if (!taskToCreateAgentHasBeenQueuedSoItWillDoTheDecrement) {
                        this.decrementContainersInProgress(t);
                    }
                }
                remainingWorkload -= t.getNumExecutors();
            }
            return r;
        }
        catch (Exception e) {
            LOGGER.error("Exception while provisioning for label: '{}', cloud='{}'", new Object[]{label, this.getDisplayName(), e});
            long milliseconds = this.getEffectiveErrorDurationInMilliseconds();
            if (milliseconds > 0L) {
                DockerDisabled reasonForDisablement = this.getDisabled();
                reasonForDisablement.disableBySystem("Cloud provisioning failure", milliseconds, e);
                this.setDisabled(reasonForDisablement);
            }
            return Collections.emptyList();
        }
    }

    public static String runContainer(DockerTemplateBase dockerTemplateBase, DockerClient dockerClient) {
        CreateContainerCmd containerConfig = dockerClient.createContainerCmd(dockerTemplateBase.getImage());
        dockerTemplateBase.fillContainerConfig(containerConfig);
        CreateContainerResponse response = containerConfig.exec();
        String containerId = response.getId();
        StartContainerCmd startCommand = dockerClient.startContainerCmd(containerId);
        startCommand.exec();
        return containerId;
    }

    public boolean canProvision(Label label) {
        if (this.getDisabled().isDisabled()) {
            return false;
        }
        return this.getTemplate(label) != null;
    }

    @CheckForNull
    public DockerTemplate getTemplate(String template) {
        for (DockerTemplate t : this.getTemplates()) {
            if (!t.getImage().equals(template)) continue;
            return t;
        }
        return null;
    }

    @CheckForNull
    public DockerTemplate getTemplate(Label label) {
        List<DockerTemplate> matchingTemplates = this.getTemplates(label);
        if (!matchingTemplates.isEmpty()) {
            return matchingTemplates.get(0);
        }
        return null;
    }

    public synchronized void addTemplate(DockerTemplate t) {
        if (this.templates == null) {
            this.templates = new ArrayList<DockerTemplate>();
        }
        this.templates.add(t);
    }

    public synchronized void addJobTemplate(long jobId, DockerTemplate template) {
        this.getJobTemplates().put(jobId, template);
    }

    public synchronized void removeJobTemplate(long jobId) {
        if (this.getJobTemplates().remove(jobId) == null) {
            LOGGER.warn("Couldn't remove template for job with id: {}", (Object)jobId);
        }
    }

    public List<DockerTemplate> getTemplates() {
        return this.templates == null ? Collections.emptyList() : this.templates;
    }

    public List<DockerTemplate> getTemplates(Label label) {
        ArrayList<DockerTemplate> dockerTemplates = new ArrayList<DockerTemplate>();
        for (DockerTemplate t : this.getTemplates()) {
            if (t.getDisabled().isDisabled()) continue;
            if (label == null && t.getMode() == Node.Mode.NORMAL) {
                dockerTemplates.add(t);
            }
            if (label == null || !label.matches(t.getLabelSet())) continue;
            dockerTemplates.add(t);
        }
        for (DockerTemplate template : this.getJobTemplates().values()) {
            if (label == null || !label.matches(template.getLabelSet())) continue;
            dockerTemplates.add(template);
        }
        return dockerTemplates;
    }

    private Map<Long, DockerTemplate> getJobTemplates() {
        if (this.jobTemplates == null) {
            this.jobTemplates = new HashMap<Long, DockerTemplate>();
        }
        return this.jobTemplates;
    }

    public synchronized void removeTemplate(DockerTemplate t) {
        if (this.templates != null) {
            this.templates.remove(t);
        }
    }

    public int countContainersInDocker(String imageName) throws Exception {
        List containers;
        HashMap<String, String> labelFilter = new HashMap<String, String>();
        labelFilter.put(DockerContainerLabelKeys.JENKINS_INSTANCE_ID, DockerTemplateBase.getJenkinsInstanceIdForContainerLabel());
        if (imageName != null) {
            labelFilter.put(DockerContainerLabelKeys.CONTAINER_IMAGE, imageName);
        }
        try (DockerClient client = this.dockerApi.getClient();){
            containers = (List)client.listContainersCmd().withLabelFilter(labelFilter).exec();
        }
        int count = containers.size();
        return count;
    }

    private boolean canAddProvisionedAgent(DockerTemplate t) throws Exception {
        int estimatedTemplateAgents;
        int estimatedTotalAgents;
        boolean haveTemplateContainerCap;
        String templateImage = t.getImage();
        int templateContainerCap = t.instanceCap;
        int cloudContainerCap = this.getContainerCap();
        boolean haveCloudContainerCap = cloudContainerCap > 0 && cloudContainerCap != Integer.MAX_VALUE;
        boolean bl = haveTemplateContainerCap = templateContainerCap > 0 && templateContainerCap != Integer.MAX_VALUE;
        if (haveCloudContainerCap) {
            int containersInProgress;
            int totalContainersInCloud = this.countContainersInDocker(null);
            estimatedTotalAgents = totalContainersInCloud + (containersInProgress = this.countContainersInProgress());
            if (estimatedTotalAgents >= cloudContainerCap) {
                LOGGER.debug("Not Provisioning '{}'; Cloud '{}' full with '{}' container(s)", new Object[]{templateImage, this.name, cloudContainerCap});
                return false;
            }
        } else {
            estimatedTotalAgents = -1;
        }
        if (haveTemplateContainerCap) {
            int containersInProgress;
            int totalContainersOfThisTemplateInCloud = this.countContainersInDocker(templateImage);
            estimatedTemplateAgents = totalContainersOfThisTemplateInCloud + (containersInProgress = this.countContainersInProgress(t));
            if (estimatedTemplateAgents >= templateContainerCap) {
                LOGGER.debug("Not Provisioning '{}'. Template instance limit of '{}' reached on cloud '{}'", new Object[]{templateImage, templateContainerCap, this.name});
                return false;
            }
        } else {
            estimatedTemplateAgents = -1;
        }
        if (haveCloudContainerCap) {
            if (haveTemplateContainerCap) {
                LOGGER.info("Provisioning '{}' number {} (of {}) on '{}'; Total containers: {} (of {})", new Object[]{templateImage, estimatedTemplateAgents + 1, templateContainerCap, this.name, estimatedTotalAgents, cloudContainerCap});
            } else {
                LOGGER.info("Provisioning '{}' on '{}'; Total containers: {} (of {})", new Object[]{templateImage, this.name, estimatedTotalAgents, cloudContainerCap});
            }
        } else if (haveTemplateContainerCap) {
            LOGGER.info("Provisioning '{}' number {} (of {}) on '{}'", new Object[]{templateImage, estimatedTemplateAgents + 1, templateContainerCap, this.name});
        } else {
            LOGGER.info("Provisioning '{}' on '{}'", (Object)templateImage, (Object)this.name);
        }
        return true;
    }

    @CheckForNull
    public static DockerCloud getCloudByName(String name) {
        return (DockerCloud)Jenkins.get().getCloud(name);
    }

    protected Object readResolve() {
        for (DockerTemplate template : this.getTemplates()) {
            template.readResolve();
        }
        if (this.dockerHost == null && this.serverUrl != null) {
            this.serverUrl = this.sanitizeUrl(this.serverUrl);
            this.dockerHost = new DockerServerEndpoint(this.serverUrl, this.credentialsId);
        }
        if (this.dockerApi == null) {
            this.dockerApi = new DockerAPI(this.dockerHost, this.connectTimeout, this.readTimeout, this.version, this.dockerHostname);
        }
        if (this.name == null || this.name.isBlank()) {
            String newName = "docker-cloud-" + Integer.toHexString(this.hashCode());
            LOGGER.warn("Docker cloud requires a non-blank name after Jenkins 2.402, using '" + newName + "'");
            return new DockerCloud(newName, this);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = JenkinsUtils.startToString((Object)this);
        JenkinsUtils.bldToString(sb, "name", this.name);
        JenkinsUtils.bldToString(sb, "dockerApi", (Object)this.dockerApi);
        JenkinsUtils.bldToString(sb, "containerCap", this.containerCap);
        JenkinsUtils.bldToString(sb, "exposeDockerHost", this.exposeDockerHost);
        JenkinsUtils.bldToString(sb, "disabled", this.getDisabled());
        JenkinsUtils.bldToString(sb, "templates", this.templates);
        JenkinsUtils.endToString(sb);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.dockerApi == null ? 0 : this.dockerApi.hashCode());
        result = 31 * result + this.containerCap;
        result = 31 * result + (this.exposeDockerHost ? 1231 : 1237);
        result = 31 * result + this.getDisabled().hashCode();
        result = 31 * result + (this.templates == null ? 0 : this.templates.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DockerCloud that = (DockerCloud)((Object)o);
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals((Object)this.dockerApi, (Object)that.dockerApi)) {
            return false;
        }
        if (this.containerCap != that.containerCap) {
            return false;
        }
        if (this.exposeDockerHost != that.exposeDockerHost) {
            return false;
        }
        if (!this.getDisabled().equals(that.getDisabled())) {
            return false;
        }
        return Objects.equals(this.templates, that.templates);
    }

    public boolean isTriton() {
        if (this._isTriton == null) {
            Version remoteVersion;
            try (DockerClient client = this.dockerApi.getClient();){
                remoteVersion = (Version)client.versionCmd().exec();
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            this._isTriton = remoteVersion.getOperatingSystem().equals("solaris");
        }
        return this._isTriton;
    }

    public boolean isExposeDockerHost() {
        return this.exposeDockerHost;
    }

    @DataBoundSetter
    public void setExposeDockerHost(boolean exposeDockerHost) {
        this.exposeDockerHost = exposeDockerHost;
    }

    public DockerDisabled getDisabled() {
        return this.disabled == null ? new DockerDisabled() : this.disabled;
    }

    @DataBoundSetter
    public void setDisabled(DockerDisabled disabled) {
        this.disabled = disabled;
    }

    @CheckForNull
    public Integer getErrorDuration() {
        if (this.errorDuration != null && this.errorDuration < 0) {
            return null;
        }
        return this.errorDuration;
    }

    @DataBoundSetter
    public void setErrorDuration(Integer errorDuration) {
        this.errorDuration = errorDuration;
    }

    @Restricted(value={NoExternalUse.class})
    long getEffectiveErrorDurationInMilliseconds() {
        Integer configuredDurationOrNull = this.getErrorDuration();
        if (configuredDurationOrNull != null) {
            return TimeUnit.SECONDS.toMillis(configuredDurationOrNull.intValue());
        }
        return TimeUnit.SECONDS.toMillis(300L);
    }

    @NonNull
    public static List<DockerCloud> instances() {
        ArrayList<DockerCloud> instances = new ArrayList<DockerCloud>();
        for (Cloud cloud : Jenkins.get().clouds) {
            if (!(cloud instanceof DockerCloud)) continue;
            instances.add((DockerCloud)cloud);
        }
        return instances;
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    static DockerCloud findCloudForTemplate(DockerTemplate template) {
        for (DockerCloud cloud : DockerCloud.instances()) {
            if (!cloud.hasTemplate(template)) continue;
            return cloud;
        }
        return null;
    }

    private boolean hasTemplate(DockerTemplate template) {
        if (this.getTemplates().contains(template)) {
            return true;
        }
        return this.getJobTemplates().containsValue(template);
    }

    @Restricted(value={NoExternalUse.class})
    public static void setRegistryAuthentication(PullImageCmd cmd, DockerRegistryEndpoint registry, ItemGroup context) {
        if (registry != null && registry.getCredentialsId() != null) {
            AuthConfig auth = DockerCloud.getAuthConfig(registry, context);
            cmd.withAuthConfig(auth);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static void setRegistryAuthentication(PushImageCmd cmd, DockerRegistryEndpoint registry, ItemGroup context) {
        if (registry != null && registry.getCredentialsId() != null) {
            AuthConfig auth = DockerCloud.getAuthConfig(registry, context);
            cmd.withAuthConfig(auth);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static AuthConfig getAuthConfig(DockerRegistryEndpoint registry, ItemGroup context) {
        DockerRegistryToken t;
        AuthConfig auth = new AuthConfig();
        Credentials c = CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(IdCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, List.of()), (CredentialsMatcher)CredentialsMatchers.withId((String)registry.getCredentialsId()));
        DockerRegistryToken dockerRegistryToken = t = c == null ? null : (DockerRegistryToken)AuthenticationTokens.convert(DockerRegistryToken.class, (Credentials)c);
        if (t == null) {
            throw new IllegalArgumentException("Invalid Credential ID " + registry.getCredentialsId());
        }
        String token = t.getToken();
        String decode = new String(Base64.getDecoder().decode(token), StandardCharsets.UTF_8);
        int i = decode.indexOf(58);
        if (i > 0) {
            String username = decode.substring(0, i);
            auth.withUsername(username);
        }
        auth.withPassword(decode.substring(i + 1));
        if (registry.getUrl() != null) {
            auth.withRegistryAddress(registry.getUrl());
        }
        return auth;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        public FormValidation doCheckErrorDuration(@QueryParameter String value) {
            if (value == null || value.isEmpty()) {
                return FormValidation.ok((String)"Default = %d", (Object[])new Object[]{300});
            }
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        public String getDisplayName() {
            return "Docker";
        }
    }
}

