/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.jaxrs.JerseyDockerCmdExecFactory;
import com.github.dockerjava.jaxrs.JerseyDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerClientBuilder {
    private final DockerClientConfig dockerClientConfig;
    private DockerCmdExecFactory dockerCmdExecFactory = null;
    private DockerHttpClient dockerHttpClient = null;

    private DockerClientBuilder(DockerClientConfig dockerClientConfig) {
        this.dockerClientConfig = dockerClientConfig;
    }

    public static DockerClientBuilder getInstance() {
        return new DockerClientBuilder((DockerClientConfig)DefaultDockerClientConfig.createDefaultConfigBuilder().build());
    }

    @Deprecated
    public static DockerClientBuilder getInstance(DefaultDockerClientConfig.Builder dockerClientConfigBuilder) {
        return DockerClientBuilder.getInstance((DockerClientConfig)dockerClientConfigBuilder.build());
    }

    public static DockerClientBuilder getInstance(DockerClientConfig dockerClientConfig) {
        return new DockerClientBuilder(dockerClientConfig);
    }

    @Deprecated
    public static DockerClientBuilder getInstance(String serverUrl) {
        return new DockerClientBuilder((DockerClientConfig)DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost(serverUrl).build());
    }

    @Deprecated
    public static DockerCmdExecFactory getDefaultDockerCmdExecFactory() {
        return new JerseyDockerCmdExecFactory();
    }

    @Deprecated
    public DockerClientBuilder withDockerCmdExecFactory(DockerCmdExecFactory dockerCmdExecFactory) {
        this.dockerCmdExecFactory = dockerCmdExecFactory;
        this.dockerHttpClient = null;
        return this;
    }

    public DockerClientBuilder withDockerHttpClient(DockerHttpClient dockerHttpClient) {
        this.dockerCmdExecFactory = null;
        this.dockerHttpClient = dockerHttpClient;
        return this;
    }

    public DockerClient build() {
        if (this.dockerHttpClient != null) {
            return DockerClientImpl.getInstance((DockerClientConfig)this.dockerClientConfig, (DockerHttpClient)this.dockerHttpClient);
        }
        if (this.dockerCmdExecFactory != null) {
            return DockerClientImpl.getInstance((DockerClientConfig)this.dockerClientConfig).withDockerCmdExecFactory(this.dockerCmdExecFactory);
        }
        Logger log = LoggerFactory.getLogger(DockerClientBuilder.class);
        log.warn("'dockerHttpClient' should be set. Falling back to Jersey, will be an error in future releases.");
        return DockerClientImpl.getInstance((DockerClientConfig)this.dockerClientConfig, (DockerHttpClient)new JerseyDockerHttpClient.Builder().dockerHost(this.dockerClientConfig.getDockerHost()).sslConfig((SSLConfig)this.dockerClientConfig.getSSLConfig()).build());
    }
}

