/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.model.DockerObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import lombok.Generated;

public class Device
extends DockerObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="CgroupPermissions")
    private String cGroupPermissions = "";
    @JsonProperty(value="PathOnHost")
    private String pathOnHost = null;
    @JsonProperty(value="PathInContainer")
    private String pathInContainer = null;

    public Device() {
    }

    public Device(String cGroupPermissions, String pathInContainer, String pathOnHost) {
        Objects.requireNonNull(cGroupPermissions, "cGroupPermissions is null");
        Objects.requireNonNull(pathInContainer, "pathInContainer is null");
        Objects.requireNonNull(pathOnHost, "pathOnHost is null");
        this.cGroupPermissions = cGroupPermissions;
        this.pathInContainer = pathInContainer;
        this.pathOnHost = pathOnHost;
    }

    public String getcGroupPermissions() {
        return this.cGroupPermissions;
    }

    public String getPathInContainer() {
        return this.pathInContainer;
    }

    public String getPathOnHost() {
        return this.pathOnHost;
    }

    @Nonnull
    public static Device parse(@Nonnull String deviceStr) {
        String src = "";
        String dst = "";
        String permissions = "rwm";
        String[] arr = deviceStr.trim().split(":");
        switch (new StringTokenizer(deviceStr, ":").countTokens()) {
            case 3: {
                if (Device.validDeviceMode(arr[2])) {
                    permissions = arr[2];
                } else {
                    throw new IllegalArgumentException("Invalid device specification: " + deviceStr);
                }
            }
            case 2: {
                if (Device.validDeviceMode(arr[1])) {
                    permissions = arr[1];
                } else {
                    dst = arr[1];
                }
            }
            case 1: {
                src = arr[0];
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid device specification: " + deviceStr);
            }
        }
        if (dst == null || dst.length() == 0) {
            dst = src;
        }
        return new Device(permissions, dst, src);
    }

    private static boolean validDeviceMode(String deviceMode) {
        HashMap<String, Boolean> validModes = new HashMap<String, Boolean>(3);
        validModes.put("r", true);
        validModes.put("w", true);
        validModes.put("m", true);
        if (deviceMode == null || deviceMode.length() == 0) {
            return false;
        }
        for (char ch : deviceMode.toCharArray()) {
            String mode = String.valueOf(ch);
            if (!Boolean.TRUE.equals(validModes.get(mode))) {
                return false;
            }
            validModes.put(mode, false);
        }
        return true;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Device)) {
            return false;
        }
        Device other = (Device)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$cGroupPermissions = this.getcGroupPermissions();
        String other$cGroupPermissions = other.getcGroupPermissions();
        if (this$cGroupPermissions == null ? other$cGroupPermissions != null : !this$cGroupPermissions.equals(other$cGroupPermissions)) {
            return false;
        }
        String this$pathOnHost = this.getPathOnHost();
        String other$pathOnHost = other.getPathOnHost();
        if (this$pathOnHost == null ? other$pathOnHost != null : !this$pathOnHost.equals(other$pathOnHost)) {
            return false;
        }
        String this$pathInContainer = this.getPathInContainer();
        String other$pathInContainer = other.getPathInContainer();
        return !(this$pathInContainer == null ? other$pathInContainer != null : !this$pathInContainer.equals(other$pathInContainer));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Device;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cGroupPermissions = this.getcGroupPermissions();
        result = result * 59 + ($cGroupPermissions == null ? 43 : $cGroupPermissions.hashCode());
        String $pathOnHost = this.getPathOnHost();
        result = result * 59 + ($pathOnHost == null ? 43 : $pathOnHost.hashCode());
        String $pathInContainer = this.getPathInContainer();
        result = result * 59 + ($pathInContainer == null ? 43 : $pathInContainer.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Device(cGroupPermissions=" + this.getcGroupPermissions() + ", pathOnHost=" + this.getPathOnHost() + ", pathInContainer=" + this.getPathInContainer() + ")";
    }
}

