/*
 * Decompiled with CFR 0.152.
 */
package io.superstudios.plugins.diversion;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.util.ListBoxModel;
import io.superstudios.plugins.diversion.DiversionApiClient;
import io.superstudios.plugins.diversion.DiversionChangeLogParser;
import io.superstudios.plugins.diversion.DiversionCommit;
import io.superstudios.plugins.diversion.DiversionFile;
import io.superstudios.plugins.diversion.DiversionRepository;
import io.superstudios.plugins.diversion.DiversionSCMRevisionState;
import io.superstudios.plugins.diversion.DiversionUIHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class DiversionSCM
extends SCM {
    private final String repositoryId;
    private final String credentialsId;
    private String branch = "main";
    private String scriptPath;
    private String libraryPath;

    @DataBoundConstructor
    public DiversionSCM(String repositoryId, String credentialsId) {
        this.repositoryId = repositoryId;
        this.credentialsId = credentialsId;
    }

    @DataBoundSetter
    public void setBranch(String branch) {
        this.branch = branch;
    }

    @DataBoundSetter
    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    @DataBoundSetter
    public void setLibraryPath(String libraryPath) {
        this.libraryPath = libraryPath;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }

    private String getScriptPathFromJob(Run<?, ?> build) {
        if (this.scriptPath != null && !this.scriptPath.isEmpty()) {
            return this.scriptPath;
        }
        String jobName = build.getParent().getName();
        String expectedFileName = jobName + ".groovy";
        try {
            String[] commonPaths;
            DiversionApiClient client = new DiversionApiClient(this.credentialsId);
            List<DiversionFile> files = client.getFileTree(this.repositoryId, this.branch);
            for (DiversionFile file : files) {
                String path = file.getPath();
                if (!path.endsWith("/" + expectedFileName) && !path.equals(expectedFileName)) continue;
                return path;
            }
            for (String path : commonPaths = new String[]{"Meta/Jenkins/" + expectedFileName, "Jenkins/" + expectedFileName, "scripts/" + expectedFileName, "pipeline/" + expectedFileName, expectedFileName}) {
                try {
                    client.getFileContent(this.repositoryId, this.branch, path);
                    return path;
                }
                catch (IOException | InterruptedException e) {
                }
            }
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        return expectedFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkout(@NonNull Run<?, ?> build, @NonNull Launcher launcher, @NonNull FilePath workspace, @NonNull TaskListener listener, File changelogFile, @CheckForNull SCMRevisionState baseline) throws IOException, InterruptedException {
        listener.getLogger().println("Checking out from Diversion repository: " + this.repositoryId);
        listener.getLogger().println("Using credentials ID: " + this.credentialsId);
        try {
            Run<?, ?> content;
            if (this.credentialsId == null || this.credentialsId.trim().isEmpty()) {
                throw new IOException("Credentials ID is null or empty. Please configure Diversion credentials in Jenkins.");
            }
            StandardCredentials credentials = (StandardCredentials)CredentialsProvider.findCredentialById((String)this.credentialsId, StandardCredentials.class, build, Collections.emptyList());
            if (credentials != null) {
                CredentialsProvider.track(build, (Credentials)credentials);
            }
            DiversionApiClient client = new DiversionApiClient(this.credentialsId, build);
            listener.getLogger().println("Getting repository details...");
            DiversionRepository repo = client.getRepository(this.repositoryId);
            listener.getLogger().println("Repository: " + repo.getName());
            String workspacePath = workspace.getRemote();
            boolean isLibraryCheckout = workspacePath.contains("@libs");
            if (isLibraryCheckout) {
                listener.getLogger().println("Library checkout detected - downloading library files");
                String libPath = this.libraryPath != null && !this.libraryPath.isEmpty() ? this.libraryPath : "Meta/Jenkins/SharedLibs";
                listener.getLogger().println("Using library path: " + libPath);
                List<DiversionFile> files = client.getFileTree(this.repositoryId, this.branch);
                int downloadedCount = 0;
                for (DiversionFile file : files) {
                    String filePath = file.getPath();
                    if (filePath == null || !filePath.startsWith(libPath + "/")) continue;
                    try {
                        String content2 = client.getFileContent(this.repositoryId, this.branch, filePath);
                        String relativePath = filePath.substring(libPath.length() + 1);
                        FilePath targetFile = workspace.child(relativePath);
                        FilePath parent = targetFile.getParent();
                        if (parent != null) {
                            parent.mkdirs();
                        }
                        targetFile.write(content2, "UTF-8");
                        ++downloadedCount;
                    }
                    catch (IOException | InterruptedException e) {
                        listener.getLogger().println("Warning: Could not download " + filePath + ": " + e.getMessage());
                    }
                }
                listener.getLogger().println("Downloaded " + downloadedCount + " library files");
            } else {
                String scriptPath = this.getScriptPathFromJob(build);
                listener.getLogger().println("Script path: " + scriptPath);
                content = client.getFileContent(this.repositoryId, this.branch, scriptPath);
                FilePath targetFile = workspace.child(scriptPath);
                FilePath parent = targetFile.getParent();
                if (parent != null) {
                    parent.mkdirs();
                }
                targetFile.write((String)content, "UTF-8");
                listener.getLogger().println("Downloaded: " + scriptPath);
            }
            if (changelogFile != null) {
                boolean shouldWriteChangelog = false;
                content = build;
                synchronized (content) {
                    String changelogKey = "diversion.changelog.written";
                    Action changelogWritten = build.getAction(ParametersAction.class);
                    String buildKey = build.getExternalizableId();
                    String alreadyWritten = System.getProperty(buildKey + ".changelog");
                    if (alreadyWritten == null) {
                        if (!isLibraryCheckout) {
                            shouldWriteChangelog = true;
                            System.setProperty(buildKey + ".changelog", "script");
                            listener.getLogger().println("Creating changelog (script checkout)...");
                        } else {
                            shouldWriteChangelog = true;
                            System.setProperty(buildKey + ".changelog", "library");
                            listener.getLogger().println("Creating changelog (library checkout)...");
                        }
                    } else if (alreadyWritten.equals("library") && !isLibraryCheckout) {
                        shouldWriteChangelog = true;
                        System.setProperty(buildKey + ".changelog", "script");
                        listener.getLogger().println("Updating changelog (script checkout - preferred over library)...");
                    } else {
                        listener.getLogger().println("Skipping changelog (already written for this build)");
                    }
                }
                if (shouldWriteChangelog) {
                    try {
                        DiversionCommit latestCommit = client.getLatestCommit(this.repositoryId, this.branch);
                        String currentCommitId = latestCommit.getCommitId();
                        String previousCommitId = null;
                        Run previousBuild = build.getPreviousBuild();
                        if (previousBuild != null) {
                            SCMRevisionState previousState = (SCMRevisionState)previousBuild.getAction(SCMRevisionState.class);
                            if (previousState != null && previousState.getClass().getName().contains("MultiSCMRevisionState")) {
                                try {
                                    Field statesField = previousState.getClass().getDeclaredField("revisionStates");
                                    statesField.setAccessible(true);
                                    Map states = (Map)statesField.get(previousState);
                                    for (Object state : states.values()) {
                                        if (!(state instanceof DiversionSCMRevisionState)) continue;
                                        previousCommitId = ((DiversionSCMRevisionState)((Object)state)).getCommitId();
                                    }
                                }
                                catch (ReflectiveOperationException statesField) {}
                            } else if (previousState instanceof DiversionSCMRevisionState) {
                                previousCommitId = ((DiversionSCMRevisionState)previousState).getCommitId();
                            }
                        }
                        ArrayList<DiversionCommit> commits = new ArrayList<DiversionCommit>();
                        if (previousCommitId != null && previousCommitId.equals(currentCommitId)) {
                            listener.getLogger().println("No new commits since last build");
                        } else if (previousCommitId != null) {
                            listener.getLogger().println("Finding commits between " + previousCommitId + " and " + currentCommitId);
                            List<DiversionCommit> allCommits = client.listCommits(this.repositoryId, 100);
                            boolean foundCurrent = false;
                            for (DiversionCommit commit : allCommits) {
                                if (commit.getCommitId().equals(currentCommitId)) {
                                    foundCurrent = true;
                                }
                                if (!foundCurrent) continue;
                                if (commit.getCommitId().equals(previousCommitId)) break;
                                commits.add(commit);
                            }
                            listener.getLogger().println("Found " + commits.size() + " new commits");
                        } else {
                            listener.getLogger().println("First build - showing latest commit");
                            commits.add(latestCommit);
                        }
                        try (FileWriter writer = new FileWriter(changelogFile, StandardCharsets.UTF_8);){
                            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                            writer.write("<changelog>\n");
                            for (DiversionCommit commit : commits) {
                                writer.write("  <entry>\n");
                                writer.write("    <commitId>" + this.escapeXml(commit.getCommitId()) + "</commitId>\n");
                                writer.write("    <msg>" + this.escapeXml(commit.getCommitMessage()) + "</msg>\n");
                                writer.write("    <author>" + this.escapeXml(commit.getAuthor().getName()) + "</author>\n");
                                writer.write("    <timestamp>" + commit.getCreatedTs() + "</timestamp>\n");
                                if (commit.getChangedFiles() != null && !commit.getChangedFiles().isEmpty()) {
                                    writer.write("    <files>\n");
                                    for (String file : commit.getChangedFiles()) {
                                        writer.write("      <file>" + this.escapeXml(file) + "</file>\n");
                                    }
                                    writer.write("    </files>\n");
                                }
                                writer.write("  </entry>\n");
                            }
                            writer.write("</changelog>\n");
                        }
                        listener.getLogger().println("Changelog file created with " + commits.size() + " commits");
                    }
                    catch (IOException e) {
                        listener.getLogger().println("Warning: Could not create changelog file: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
            listener.getLogger().println("Checkout completed successfully");
            try {
                if (build.getClass().getName().contains("WorkflowRun")) {
                    Run<?, ?> workflowRun = build;
                    Class<?> workflowRunClass = workflowRun.getClass();
                    Class<?> scmCheckoutClass = Class.forName("org.jenkinsci.plugins.workflow.job.WorkflowRun$SCMCheckout");
                    Object scmCheckout = scmCheckoutClass.getConstructor(SCM.class).newInstance(new Object[]{this});
                    List actions = (List)workflowRunClass.getMethod("getActions", new Class[0]).invoke(workflowRun, new Object[0]);
                    actions.add(scmCheckout);
                    listener.getLogger().println("Created SCM checkout action for change detection");
                }
            }
            catch (ReflectiveOperationException e) {
                listener.getLogger().println("Note: Could not create SCM checkout action: " + e.getMessage());
            }
        }
        catch (IOException | InterruptedException e) {
            listener.getLogger().println("Error during checkout: " + e.getMessage());
            if (e.getCause() != null) {
                listener.getLogger().println("Caused by: " + e.getCause().getMessage());
            }
            e.printStackTrace();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException("Failed to checkout from Diversion: " + e.getMessage(), e);
        }
    }

    public SCMRevisionState calcRevisionsFromBuild(@NonNull Run<?, ?> build, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener listener) throws IOException, InterruptedException {
        try {
            DiversionApiClient client = new DiversionApiClient(this.credentialsId);
            DiversionCommit latestCommit = client.getLatestCommit(this.repositoryId, this.branch);
            return new DiversionSCMRevisionState(latestCommit.getCommitId(), latestCommit.getCreatedTs());
        }
        catch (Exception e) {
            listener.getLogger().println("Warning: Could not calculate revision state: " + e.getMessage());
            return new SCMRevisionState(){};
        }
    }

    public ChangeLogParser createChangeLogParser() {
        return new DiversionChangeLogParser();
    }

    private String escapeXml(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;");
    }

    @Extension
    public static class DescriptorImpl
    extends SCMDescriptor<DiversionSCM> {
        public DescriptorImpl() {
            super(DiversionSCM.class, null);
        }

        public String getDisplayName() {
            return "Diversion";
        }

        public boolean isApplicable(Job project) {
            return true;
        }

        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String credentialsId) {
            return DiversionUIHelper.fillCredentialsIdItems(context, credentialsId);
        }

        @RequirePOST
        public ListBoxModel doFillRepositoryIdItems(@AncestorInPath Item context, @QueryParameter String credentialsId) {
            if (context == null ? !Jenkins.get().hasPermission(Jenkins.MANAGE) : !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                return new ListBoxModel();
            }
            return DiversionUIHelper.fillRepositoryIdItems(credentialsId, "Error");
        }

        @RequirePOST
        public ListBoxModel doFillBranchItems(@AncestorInPath Item context, @QueryParameter String credentialsId, @QueryParameter String repositoryId) {
            if (context == null ? !Jenkins.get().hasPermission(Jenkins.MANAGE) : !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                return new ListBoxModel();
            }
            return DiversionUIHelper.fillBranchItems(credentialsId, repositoryId, "Error");
        }

        @RequirePOST
        public ListBoxModel doFillScriptPathItems(@AncestorInPath Item context, @QueryParameter String credentialsId, @QueryParameter String repositoryId, @QueryParameter String branch) {
            if (context == null ? !Jenkins.get().hasPermission(Jenkins.MANAGE) : !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                return new ListBoxModel();
            }
            ListBoxModel items = new ListBoxModel();
            items.add("(Auto-detect from job name)", "");
            if (!(credentialsId == null || credentialsId.isEmpty() || repositoryId == null || repositoryId.isEmpty() || branch == null || branch.isEmpty())) {
                try {
                    DiversionApiClient client = new DiversionApiClient(credentialsId);
                    List<DiversionFile> files = client.getFileTree(repositoryId, branch);
                    items.add("- Pipeline Scripts -", "");
                    for (DiversionFile file : files) {
                        if (!file.getPath().endsWith(".groovy")) continue;
                        items.add("\ud83d\udcc4 " + file.getPath(), file.getPath());
                    }
                }
                catch (Exception e) {
                    items.add("(Could not load files: " + e.getMessage() + ")", "");
                }
            }
            return items;
        }
    }
}

