/*
 * Decompiled with CFR 0.152.
 */
package nz.co.jammehcow.jenkinsdiscord.util;

import hudson.model.Run;
import hudson.scm.ChangeLogSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.scm.RunWithSCM;
import org.apache.commons.lang.StringUtils;

public class EmbedDescription {
    private static final int maxEmbedStringLength = 2048;
    private LinkedList<String> changesList = new LinkedList();
    private LinkedList<String> artifactsList = new LinkedList();
    private String prefix;
    private String finalDescription;

    public EmbedDescription(Run build, JenkinsLocationConfiguration globalConfig, String prefix, boolean enableArtifactsList, boolean showChangeset, String scmWebUrl) {
        String artifactsURL = globalConfig.getUrl() + build.getUrl() + "artifact/";
        this.prefix = StringUtils.trimToNull((String)prefix);
        if (showChangeset) {
            ArrayList<Object> changes = new ArrayList<Object>();
            List changeSets = ((RunWithSCM)build).getChangeSets();
            for (ChangeLogSet i : changeSets) {
                changes.addAll(Arrays.asList(i.getItems()));
            }
            if (changes.isEmpty()) {
                this.changesList.add("\n*No changes.*\n");
            } else {
                boolean withLinks;
                this.changesList.add("\n**Changes:**\n");
                try {
                    String dummy = String.format(scmWebUrl, "");
                    withLinks = true;
                }
                catch (Exception ex) {
                    withLinks = false;
                }
                for (Object e : changes) {
                    ChangeLogSet.Entry entry = (ChangeLogSet.Entry)e;
                    String commitID = entry.getCommitId();
                    String commitDisplayStr = commitID == null ? "null  " : (commitID.length() < 6 ? commitID : commitID.substring(0, 6));
                    String msg = entry.getMsg().trim();
                    int nl = msg.indexOf("\n");
                    if (nl >= 0) {
                        msg = msg.substring(0, nl).trim();
                    }
                    msg = EmbedDescription.escapeMarkdown(msg);
                    String author = entry.getAuthor().getFullName();
                    if (withLinks) {
                        String url = String.format(scmWebUrl, commitID);
                        this.changesList.add(String.format("- [`%s`](%s) *%s - %s*%n", commitDisplayStr, url, msg, author));
                        continue;
                    }
                    this.changesList.add(String.format("- `%s` *%s - %s*%n", commitDisplayStr, msg, author));
                }
            }
        }
        if (enableArtifactsList) {
            this.artifactsList.add("\n**Artifacts:**\n");
            List artifacts = build.getArtifacts();
            if (artifacts.isEmpty()) {
                this.artifactsList.add("\n*No artifacts saved.*");
            } else {
                for (Run.Artifact artifact : artifacts) {
                    this.artifactsList.add("- " + artifactsURL + artifact.getHref() + "\n");
                }
            }
        }
        while (this.getCurrentDescription().length() > 2048) {
            if (this.changesList.size() > 5) {
                while (this.changesList.size() != 5) {
                    this.changesList.removeLast();
                }
                continue;
            }
            if (this.artifactsList.size() > 1) {
                this.artifactsList.clear();
                this.artifactsList.add(artifactsURL);
                continue;
            }
            this.finalDescription = this.getCurrentDescription().substring(0, 2047);
            return;
        }
        this.finalDescription = this.getCurrentDescription();
    }

    private String getCurrentDescription() {
        StringBuilder description = new StringBuilder();
        if (this.prefix != null) {
            description.append(this.prefix);
        }
        for (String changeEntry : this.changesList) {
            description.append(changeEntry);
        }
        for (String artifact : this.artifactsList) {
            description.append(artifact);
        }
        return description.toString().trim();
    }

    public String toString() {
        return this.finalDescription;
    }

    private static String escapeMarkdown(String text) {
        return text.replace("\\", "\\\\").replace("*", "\\*").replace("_", "\\_").replace("~", "\\~").replace("`", "\\`");
    }
}

