/*
 * Decompiled with CFR 0.152.
 */
package nz.co.jammehcow.jenkinsdiscord;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Plugin;
import hudson.matrix.MatrixConfiguration;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import nz.co.jammehcow.jenkinsdiscord.DiscordWebhook;
import nz.co.jammehcow.jenkinsdiscord.DynamicFieldContainer;
import nz.co.jammehcow.jenkinsdiscord.exception.WebhookException;
import nz.co.jammehcow.jenkinsdiscord.util.EmbedDescription;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

@SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Requires triage")
public class WebhookPublisher
extends Notifier {
    private final String webhookURL;
    private final String branchName;
    private final String statusTitle;
    private final String thumbnailURL;
    private final String notes;
    private final String customAvatarUrl;
    private final String customUsername;
    private DynamicFieldContainer dynamicFieldContainer;
    private final boolean sendOnStateChange;
    private final boolean sendOnlyFailed;
    private boolean enableUrlLinking;
    private final boolean enableArtifactList;
    private final boolean enableFooterInfo;
    private boolean showChangeset;
    private boolean sendLogFile;
    private boolean sendStartNotification;
    private static final String NAME = "Discord Notifier";
    private static final String SHORT_NAME = "discord-notifier";
    private final String scmWebUrl;

    @DataBoundConstructor
    public WebhookPublisher(String webhookURL, String thumbnailURL, boolean sendOnStateChange, String statusTitle, String notes, String branchName, String customAvatarUrl, String customUsername, boolean sendOnStateFailed, boolean sendOnlyFailed, boolean enableUrlLinking, boolean enableArtifactList, boolean enableFooterInfo, boolean showChangeset, boolean sendLogFile, boolean sendStartNotification, String scmWebUrl) {
        this.webhookURL = webhookURL;
        this.thumbnailURL = thumbnailURL;
        this.sendOnStateChange = sendOnStateChange;
        this.sendOnlyFailed = sendOnlyFailed;
        this.enableUrlLinking = enableUrlLinking;
        this.enableArtifactList = enableArtifactList;
        this.enableFooterInfo = enableFooterInfo;
        this.showChangeset = showChangeset;
        this.branchName = branchName;
        this.statusTitle = statusTitle;
        this.notes = notes;
        this.customAvatarUrl = customAvatarUrl;
        this.customUsername = customUsername;
        this.sendLogFile = sendLogFile;
        this.sendStartNotification = sendStartNotification;
        this.scmWebUrl = scmWebUrl;
    }

    public String getWebhookURL() {
        return this.webhookURL;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public String getStatusTitle() {
        return this.statusTitle;
    }

    public String getCustomAvatarUrl() {
        return this.customAvatarUrl;
    }

    public String getCustomUsername() {
        return this.customUsername;
    }

    @DataBoundSetter
    public void setDynamicFieldContainer(String fieldsString) {
        this.dynamicFieldContainer = DynamicFieldContainer.of(fieldsString);
    }

    public String getDynamicFieldContainer() {
        if (this.dynamicFieldContainer == null) {
            return "";
        }
        return this.dynamicFieldContainer.toString();
    }

    public String getNotes() {
        return this.notes;
    }

    public String getThumbnailURL() {
        return this.thumbnailURL;
    }

    public boolean isSendOnStateChange() {
        return this.sendOnStateChange;
    }

    public boolean isSendOnlyFailed() {
        return this.sendOnlyFailed;
    }

    public boolean isEnableUrlLinking() {
        return this.enableUrlLinking;
    }

    public boolean isEnableArtifactList() {
        return this.enableArtifactList;
    }

    public boolean isEnableFooterInfo() {
        return this.enableFooterInfo;
    }

    public boolean isShowChangeset() {
        return this.showChangeset;
    }

    public boolean isSendLogFile() {
        return this.sendLogFile;
    }

    public boolean isSendStartNotification() {
        return this.sendStartNotification;
    }

    public String getScmWebUrl() {
        return this.scmWebUrl;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        listener.getLogger().println(this.sendStartNotification);
        if (this.sendStartNotification) {
            try {
                String description;
                EnvVars env = build.getEnvironment((TaskListener)listener);
                DiscordWebhook wh = new DiscordWebhook(env.expand(this.webhookURL));
                AbstractProject project = build.getProject();
                JenkinsLocationConfiguration globalConfig = JenkinsLocationConfiguration.get();
                wh.setStatus(DiscordWebhook.StatusColor.GREEN);
                if (this.statusTitle != null && !this.statusTitle.isEmpty()) {
                    wh.setTitle("Build started: " + env.expand(this.statusTitle));
                } else {
                    wh.setTitle("Build started: " + project.getDisplayName() + " #" + build.getId());
                }
                Object branchNameString = "";
                if (this.branchName != null && !this.branchName.isEmpty()) {
                    branchNameString = "**Branch:** " + env.expand(this.branchName) + "\n";
                }
                if (this.enableUrlLinking) {
                    String url = globalConfig.getUrl() + build.getUrl();
                    description = (String)branchNameString + "**Build:** " + WebhookPublisher.getMarkdownHyperlink(build.getId(), url);
                    wh.setURL(url);
                } else {
                    description = (String)branchNameString + "**Build:** " + build.getId();
                }
                wh.setDescription(new EmbedDescription((Run)build, globalConfig, description, false, false, null).toString());
                this.addDynamicFieldsToWebhook(this.dynamicFieldContainer, wh, env);
                wh.send();
            }
            catch (IOException | InterruptedException | WebhookException e1) {
                e1.printStackTrace(listener.getLogger());
            }
        }
        return true;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        String descriptionPrefix;
        EnvVars env = build.getEnvironment((TaskListener)listener);
        JenkinsLocationConfiguration globalConfig = JenkinsLocationConfiguration.get();
        if (build.getResult() == null) {
            listener.getLogger().println("[Discord Notifier] build.getResult() is null!");
            return true;
        }
        DiscordWebhook wh = new DiscordWebhook(env.expand(this.webhookURL));
        if (this.webhookURL.isEmpty()) {
            listener.getLogger().println("The Discord webhook is not set!");
            return true;
        }
        if (this.enableUrlLinking && (globalConfig.getUrl() == null || globalConfig.getUrl().isEmpty())) {
            listener.getLogger().println("Your Jenkins URL is not set (or is set to localhost)! Disabling linking.");
            this.enableUrlLinking = false;
        }
        if (this.sendOnStateChange && build.getPreviousBuild() != null && build.getResult().equals(build.getPreviousBuild().getResult())) {
            return true;
        }
        if (this.sendOnlyFailed && !build.getResult().equals(Result.FAILURE)) {
            return true;
        }
        if (this.sendLogFile) {
            wh.setFile(build.getLogInputStream(), "build" + build.getNumber() + ".log");
        }
        DiscordWebhook.StatusColor statusColor = DiscordWebhook.StatusColor.GREEN;
        Result buildresult = build.getResult();
        if (!buildresult.isCompleteBuild()) {
            return true;
        }
        if (buildresult.isBetterOrEqualTo(Result.SUCCESS)) {
            statusColor = DiscordWebhook.StatusColor.GREEN;
        }
        if (buildresult.isWorseThan(Result.SUCCESS)) {
            statusColor = DiscordWebhook.StatusColor.YELLOW;
        }
        if (buildresult.isWorseThan(Result.UNSTABLE)) {
            statusColor = DiscordWebhook.StatusColor.RED;
        }
        AbstractProject project = build.getProject();
        StringBuilder combinationString = new StringBuilder();
        if (this.statusTitle != null && !this.statusTitle.isEmpty()) {
            wh.setTitle(env.expand(this.statusTitle));
        } else {
            wh.setTitle(project.getDisplayName() + " #" + build.getId());
        }
        if (project instanceof MatrixConfiguration) {
            wh.setTitle(project.getParent().getDisplayName() + " #" + build.getId());
            combinationString.append("**Configuration matrix:**\n");
            for (Map.Entry e : ((MatrixConfiguration)project).getCombination().entrySet()) {
                combinationString.append(" - ").append(e.getKey()).append(": ").append(e.getValue()).append("\n");
            }
        }
        Object branchNameString = "";
        if (this.branchName != null && !this.branchName.isEmpty()) {
            branchNameString = "**Branch:** " + env.expand(this.branchName) + "\n";
        }
        if (this.enableUrlLinking) {
            String url = globalConfig.getUrl() + build.getUrl();
            descriptionPrefix = (String)branchNameString + "**Build:** " + WebhookPublisher.getMarkdownHyperlink(build.getId(), url) + "\n**Status:** " + WebhookPublisher.getMarkdownHyperlink(build.getResult().toString().toLowerCase(Locale.ENGLISH), url) + "\n";
            wh.setURL(url);
        } else {
            descriptionPrefix = (String)branchNameString + "**Build:** " + build.getId() + "\n**Status:** " + build.getResult().toString().toLowerCase(Locale.ENGLISH) + "\n";
        }
        descriptionPrefix = descriptionPrefix + String.valueOf(combinationString);
        if (this.notes != null && !this.notes.isEmpty()) {
            wh.setContent(env.expand(this.notes));
        }
        if (this.customAvatarUrl != null && !this.customAvatarUrl.isEmpty()) {
            wh.setCustomAvatarUrl(this.customAvatarUrl);
        }
        if (this.customUsername != null && !this.customUsername.isEmpty()) {
            wh.setCustomUsername(this.customUsername);
        }
        wh.setThumbnail(this.thumbnailURL);
        wh.setDescription(new EmbedDescription((Run)build, globalConfig, descriptionPrefix, this.enableArtifactList, this.showChangeset, this.scmWebUrl).toString());
        this.addDynamicFieldsToWebhook(this.dynamicFieldContainer, wh, env);
        wh.setStatus(statusColor);
        if (this.enableFooterInfo) {
            wh.setFooter("Jenkins v" + build.getHudsonVersion() + ", " + this.getDescriptor().getDisplayName() + " v" + this.getDescriptor().getPluginVersion());
        }
        try {
            listener.getLogger().println("Sending notification to Discord.");
            wh.send();
        }
        catch (WebhookException e) {
            e.printStackTrace(listener.getLogger());
        }
        return true;
    }

    private void addDynamicFieldsToWebhook(DynamicFieldContainer dynamicFieldContainer, DiscordWebhook wh, EnvVars env) {
        if (dynamicFieldContainer == null) {
            return;
        }
        dynamicFieldContainer.getFields().forEach(pair -> wh.addField(pair.getKey() + ":", env.expand(pair.getValue())));
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private static String getMarkdownHyperlink(String content, String url) {
        url = url.replaceAll("\\)", "\\\\\\)");
        return "[" + content + "](" + url + ")";
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        final Plugin p = Jenkins.get().getPlugin("discord-notifier");

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public FormValidation doCheckWebhookURL(@QueryParameter String value) {
            if (!value.matches("https://(canary\\.|ptb\\.|)discord(app)*\\.com/api/webhooks/\\d{18,19}/(\\w|-|_)*(/?)")) {
                return FormValidation.error((String)"Please enter a valid Discord webhook URL.");
            }
            return FormValidation.ok();
        }

        @NonNull
        public String getDisplayName() {
            if (this.p == null) {
                return WebhookPublisher.NAME;
            }
            return this.p.getWrapper().getDisplayName();
        }

        public String getPluginVersion() {
            if (this.p == null) {
                return "";
            }
            return this.p.getWrapper().getVersion();
        }
    }
}

