/*
 * Decompiled with CFR 0.152.
 */
package nz.co.jammehcow.jenkinsdiscord;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.PatternSyntaxException;

public class DynamicFieldContainer {
    private final List<DynamicField> fields = new ArrayList<DynamicField>();

    public List<DynamicField> getFields() {
        return this.fields;
    }

    public DynamicFieldContainer addField(String key, String value) {
        this.fields.add(new DynamicField(key, value));
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.fields.size(); ++i) {
            builder.append(this.fields.get(i).toString());
            if (i + 1 >= this.fields.size()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public static DynamicFieldContainer of(String fieldsString) {
        DynamicFieldContainer fieldContainer = new DynamicFieldContainer();
        if (fieldsString.length() == 0) {
            return fieldContainer;
        }
        try {
            for (String s : fieldsString.split(",\\s*")) {
                String[] pair = s.split(":", 2);
                fieldContainer.addField(pair[0], pair[1]);
            }
        }
        catch (PatternSyntaxException e) {
            throw new RuntimeException("Dynamic fields string is in a wrong format. Using empty container as fallback", e);
        }
        return fieldContainer;
    }

    public static class DynamicField {
        private final String key;
        private final String value;

        public DynamicField(String key, String value) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("%s:%s", this.key, this.value);
        }
    }
}

