/*
 * Decompiled with CFR 0.152.
 */
package nz.co.jammehcow.jenkinsdiscord;

import java.io.InputStream;
import jenkins.model.Jenkins;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.Proxy;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import nz.co.jammehcow.jenkinsdiscord.exception.WebhookException;
import org.json.JSONArray;
import org.json.JSONObject;

class DiscordWebhook {
    private String webhookUrl;
    private JSONObject obj;
    private JSONObject embed;
    private JSONArray fields;
    private InputStream file;
    private String filename;
    static final int TITLE_LIMIT = 256;
    static final int DESCRIPTION_LIMIT = 2048;
    static final int FOOTER_LIMIT = 2048;

    DiscordWebhook(String url) {
        this.webhookUrl = url;
        this.obj = new JSONObject();
        this.obj.put("username", (Object)"Jenkins");
        this.obj.put("avatar_url", (Object)"https://get.jenkins.io/art/jenkins-logo/1024x1024/headshot.png");
        this.embed = new JSONObject();
        this.fields = new JSONArray();
    }

    public DiscordWebhook setTitle(String title) {
        this.embed.put("title", (Object)title);
        return this;
    }

    public DiscordWebhook setCustomUsername(String username) {
        if (username != null && !username.isEmpty()) {
            this.obj.put("username", (Object)username);
        } else {
            this.obj.remove("username");
        }
        return this;
    }

    public DiscordWebhook setCustomAvatarUrl(String url) {
        if (url != null && !url.isEmpty()) {
            this.obj.put("avatar_url", (Object)url);
        } else {
            this.obj.remove("avatar_url");
        }
        return this;
    }

    public DiscordWebhook setURL(String buildUrl) {
        this.embed.put("url", (Object)buildUrl);
        return this;
    }

    public DiscordWebhook setStatus(StatusColor isSuccess) {
        this.embed.put("color", isSuccess.code);
        return this;
    }

    public DiscordWebhook setDescription(String content) {
        this.embed.put("description", (Object)content);
        return this;
    }

    public DiscordWebhook setContent(String content) {
        this.obj.put("content", (Object)content);
        return this;
    }

    public DiscordWebhook setImage(String url) {
        JSONObject image = new JSONObject();
        image.put("url", (Object)url);
        this.embed.put("image", (Object)image);
        return this;
    }

    public DiscordWebhook setThumbnail(String url) {
        JSONObject thumbnail = new JSONObject();
        thumbnail.put("url", (Object)url);
        this.embed.put("thumbnail", (Object)thumbnail);
        return this;
    }

    public DiscordWebhook addField(String name, String value) {
        JSONObject field = new JSONObject();
        field.put("name", (Object)name);
        field.put("value", (Object)value);
        this.fields.put((Object)field);
        return this;
    }

    public DiscordWebhook setFooter(String text) {
        this.embed.put("footer", (Object)new JSONObject().put("text", (Object)text));
        return this;
    }

    DiscordWebhook setFile(InputStream is, String filename) {
        this.file = is;
        this.filename = filename;
        return this;
    }

    public void send() throws WebhookException {
        this.embed.put("fields", (Object)this.fields);
        if (this.embed.toString().length() > 6000) {
            throw new WebhookException("Embed object larger than the limit (" + this.embed.toString().length() + ">6000).");
        }
        this.obj.put("embeds", (Object)new JSONArray().put((Object)this.embed));
        try {
            HttpResponse response;
            Jenkins instance = Jenkins.getInstanceOrNull();
            if (instance != null && instance.proxy != null && !Unirest.config().isRunning()) {
                String proxyIP = instance.proxy.name;
                int proxyPort = instance.proxy.port;
                if (!proxyIP.equals("")) {
                    Unirest.config().proxy(new Proxy(proxyIP, Integer.valueOf(proxyPort)));
                }
            }
            if ((response = this.file != null ? Unirest.post((String)this.webhookUrl).field("payload_json", (Object)this.obj.toString()).field("file", this.file, this.filename).asJson() : Unirest.post((String)this.webhookUrl).field("payload_json", (Object)this.obj.toString()).asJson()).getStatus() < 200 || response.getStatus() >= 300) {
                throw new WebhookException(((JsonNode)response.getBody()).getObject().toString(2));
            }
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
    }

    static enum StatusColor {
        GREEN(1681177),
        YELLOW(0xFFFF0A),
        RED(11278871),
        GREY(0xCDCDCD);

        private long code;

        private StatusColor(int code) {
            this.code = code;
        }
    }
}

