/*
 * Decompiled with CFR 0.152.
 */
package nz.co.jammehcow.jenkinsdiscord;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.InvalidPathException;
import javax.inject.Inject;
import jenkins.model.JenkinsLocationConfiguration;
import nz.co.jammehcow.jenkinsdiscord.DiscordWebhook;
import nz.co.jammehcow.jenkinsdiscord.DynamicFieldContainer;
import nz.co.jammehcow.jenkinsdiscord.exception.WebhookException;
import nz.co.jammehcow.jenkinsdiscord.util.EmbedDescription;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DiscordPipelineStep
extends AbstractStepImpl {
    private final String webhookURL;
    private String title;
    private String link;
    private String description;
    private String footer;
    private String image;
    private String thumbnail;
    private String result;
    private String notes;
    private String customAvatarUrl;
    private String customUsername;
    private String customFile;
    private DynamicFieldContainer dynamicFieldContainer;
    private boolean successful;
    private boolean unstable;
    private boolean enableArtifactsList;
    private boolean showChangeset;
    private String scmWebUrl;

    @DataBoundConstructor
    public DiscordPipelineStep(String webhookURL) {
        this.webhookURL = webhookURL;
    }

    public String getWebhookURL() {
        return this.webhookURL;
    }

    public String getTitle() {
        return this.title;
    }

    @DataBoundSetter
    public void setTitle(String title) {
        this.title = title;
    }

    public String getLink() {
        return this.link;
    }

    @DataBoundSetter
    public void setLink(String link) {
        this.link = link;
    }

    public String getDescription() {
        return this.description;
    }

    @DataBoundSetter
    public void setDescription(String description) {
        this.description = description;
    }

    public String getFooter() {
        return this.footer;
    }

    @DataBoundSetter
    public void setFooter(String footer) {
        this.footer = footer;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    @DataBoundSetter
    public void setSuccessful(boolean successful) {
        this.successful = successful;
    }

    public boolean isUnstable() {
        return this.unstable;
    }

    @DataBoundSetter
    public void setUnstable(boolean unstable) {
        this.unstable = unstable;
    }

    @DataBoundSetter
    public void setImage(String url) {
        this.image = url;
    }

    public String getImage() {
        return this.image;
    }

    @DataBoundSetter
    public void setThumbnail(String url) {
        this.thumbnail = url;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    @DataBoundSetter
    public void setResult(String result) {
        this.result = result;
    }

    public String getResult() {
        return this.result;
    }

    @DataBoundSetter
    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getNotes() {
        return this.notes;
    }

    @DataBoundSetter
    public void setCustomAvatarUrl(String customAvatarUrl) {
        this.customAvatarUrl = customAvatarUrl;
    }

    public String getCustomAvatarUrl() {
        return this.customAvatarUrl;
    }

    @DataBoundSetter
    public void setCustomUsername(String customUsername) {
        this.customUsername = customUsername;
    }

    public String getCustomUsername() {
        return this.customUsername;
    }

    @DataBoundSetter
    public void setCustomFile(String customFile) {
        this.customFile = customFile;
    }

    public String getCustomFile() {
        return this.customFile;
    }

    @DataBoundSetter
    public void setEnableArtifactsList(boolean enable) {
        this.enableArtifactsList = enable;
    }

    public boolean getEnableArtifactsList() {
        return this.enableArtifactsList;
    }

    @DataBoundSetter
    public void setShowChangeset(boolean show) {
        this.showChangeset = show;
    }

    public boolean getShowChangeset() {
        return this.showChangeset;
    }

    @DataBoundSetter
    public void setScmWebUrl(String url) {
        this.scmWebUrl = url;
    }

    public String getScmWebUrl() {
        return this.scmWebUrl;
    }

    @DataBoundSetter
    public void setDynamicFieldContainer(String fieldsString) {
        this.dynamicFieldContainer = DynamicFieldContainer.of(fieldsString);
    }

    public String getDynamicFieldContainer() {
        if (this.dynamicFieldContainer == null) {
            return "";
        }
        return this.dynamicFieldContainer.toString();
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(DiscordPipelineStepExecution.class);
        }

        public String getFunctionName() {
            return "discordSend";
        }

        @NonNull
        public String getDisplayName() {
            return "Send an embed message to Webhook URL";
        }
    }

    public static class DiscordPipelineStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        @Inject
        transient DiscordPipelineStep step;
        @StepContextParameter
        transient TaskListener listener;
        private static final long serialVersionUID = 1L;

        protected Void run() throws Exception {
            this.listener.getLogger().println("Sending notification to Discord.");
            DiscordWebhook.StatusColor statusColor = DiscordWebhook.StatusColor.YELLOW;
            if (this.step.getResult() == null) {
                if (this.step.isSuccessful()) {
                    statusColor = DiscordWebhook.StatusColor.GREEN;
                }
                if (this.step.isSuccessful() && this.step.isUnstable()) {
                    statusColor = DiscordWebhook.StatusColor.YELLOW;
                }
                if (!this.step.isSuccessful() && !this.step.isUnstable()) {
                    statusColor = DiscordWebhook.StatusColor.RED;
                }
            } else if (this.step.getResult().equals(Result.SUCCESS.toString())) {
                statusColor = DiscordWebhook.StatusColor.GREEN;
            } else if (this.step.getResult().equals(Result.UNSTABLE.toString())) {
                statusColor = DiscordWebhook.StatusColor.YELLOW;
            } else if (this.step.getResult().equals(Result.FAILURE.toString())) {
                statusColor = DiscordWebhook.StatusColor.RED;
            } else if (this.step.getResult().equals(Result.ABORTED.toString())) {
                statusColor = DiscordWebhook.StatusColor.GREY;
            } else {
                this.listener.getLogger().println(this.step.getResult() + " is not a valid result");
            }
            DiscordWebhook wh = new DiscordWebhook(this.step.getWebhookURL());
            wh.setTitle(this.checkLimitAndTruncate("title", this.step.getTitle(), 256));
            wh.setURL(this.step.getLink());
            wh.setThumbnail(this.step.getThumbnail());
            if (this.step.getEnableArtifactsList() || this.step.getShowChangeset()) {
                JenkinsLocationConfiguration globalConfig = JenkinsLocationConfiguration.get();
                Run build = (Run)this.getContext().get(Run.class);
                wh.setDescription(new EmbedDescription(build, globalConfig, this.step.getDescription(), this.step.getEnableArtifactsList(), this.step.getShowChangeset(), this.step.getScmWebUrl()).toString());
            } else {
                wh.setDescription(this.checkLimitAndTruncate("description", this.step.getDescription(), 2048));
            }
            wh.setImage(this.step.getImage());
            wh.setFooter(this.checkLimitAndTruncate("footer", this.step.getFooter(), 2048));
            wh.setStatus(statusColor);
            wh.setContent(this.step.getNotes());
            if (this.step.getCustomAvatarUrl() != null) {
                wh.setCustomAvatarUrl(this.step.getCustomAvatarUrl());
            }
            if (this.step.getCustomUsername() != null) {
                wh.setCustomUsername(this.step.getCustomUsername());
            }
            if (this.step.getCustomFile() != null) {
                InputStream fis = this.getFileInputStream(this.step.getCustomFile());
                wh.setFile(fis, this.step.getCustomFile());
            }
            this.addDynamicFieldsToWebhook(wh);
            try {
                wh.send();
            }
            catch (WebhookException e) {
                e.printStackTrace(this.listener.getLogger());
            }
            return null;
        }

        private InputStream getFileInputStream(String file) throws IOException, InterruptedException {
            FilePath ws = (FilePath)this.getContext().get(FilePath.class);
            if (ws == null) {
                throw new IllegalStateException("Could not acquire FilePath");
            }
            FilePath fp = ws.child(file);
            if (fp.exists()) {
                try {
                    return fp.read();
                }
                catch (InvalidPathException var3) {
                    throw new IOException(var3);
                }
            }
            String message = "No such file: " + file;
            return new ByteArrayInputStream(message.getBytes(Charset.defaultCharset()));
        }

        private void addDynamicFieldsToWebhook(DiscordWebhook wh) {
            if (this.step.dynamicFieldContainer == null) {
                return;
            }
            this.step.dynamicFieldContainer.getFields().forEach(pair -> wh.addField(pair.getKey(), pair.getValue()));
        }

        private String checkLimitAndTruncate(String fieldName, String value, int limit) {
            if (value == null) {
                return "";
            }
            if (value.length() > limit) {
                this.listener.getLogger().printf("Warning: '%s' field has more than %d characters (%d). It will be truncated.%n", fieldName, limit, value.length());
                return value.substring(0, limit);
            }
            return value;
        }
    }
}

