/*
 * Decompiled with CFR 0.152.
 */
package com.myjeeva.digitalocean.pojo;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.myjeeva.digitalocean.common.ImageStatus;
import com.myjeeva.digitalocean.common.ImageType;
import com.myjeeva.digitalocean.pojo.Base;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class Image
extends Base {
    private static final long serialVersionUID = 1321111459154107563L;
    private String id;
    @Expose
    private String name;
    @Expose
    private String distribution;
    private String slug;
    @SerializedName(value="public")
    private boolean availablePublic;
    private List<String> regions;
    @SerializedName(value="created_at")
    private Date createdDate;
    @SerializedName(value="min_disk_size")
    private Integer minDiskSize;
    @SerializedName(value="size_gigabytes")
    private Double size;
    private ImageType type;
    @Expose
    private String url;
    @Expose
    private String region;
    @Expose
    private String description;
    @Expose
    private List<String> tags;
    private ImageStatus status;
    @SerializedName(value="error_message")
    private String errorMessage;

    public Image() {
    }

    public Image(String id) {
        this.id = id;
    }

    public Image(String name, String url, String region) {
        this.name = name;
        this.url = url;
        this.region = region;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public boolean isSnapshot() {
        return ImageType.SNAPSHOT == this.type;
    }

    public boolean isBackup() {
        return ImageType.BACKUP == this.type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDistribution() {
        return this.distribution;
    }

    public void setDistribution(String distribution) {
        this.distribution = distribution;
    }

    public String getSlug() {
        return this.slug;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public boolean isAvailablePublic() {
        return this.availablePublic;
    }

    public void setAvailablePublic(boolean availablePublic) {
        this.availablePublic = availablePublic;
    }

    public List<String> getRegions() {
        return this.regions;
    }

    public void setRegions(List<String> regions) {
        this.regions = regions;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public ImageType getType() {
        return this.type;
    }

    public void setType(ImageType type) {
        this.type = type;
    }

    public Integer getMinDiskSize() {
        return this.minDiskSize;
    }

    public void setMinDiskSize(Integer minDiskSize) {
        this.minDiskSize = minDiskSize;
    }

    public Double getSize() {
        return this.size;
    }

    public void setSize(Double size) {
        this.size = size;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ImageStatus getStatus() {
        return this.status;
    }

    public void setStatus(ImageStatus status) {
        this.status = status;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

