/*
 * Decompiled with CFR 0.152.
 */
package com.myjeeva.digitalocean.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.myjeeva.digitalocean.DigitalOcean;
import com.myjeeva.digitalocean.common.ActionType;
import com.myjeeva.digitalocean.common.ApiAction;
import com.myjeeva.digitalocean.common.Constants;
import com.myjeeva.digitalocean.common.RequestMethod;
import com.myjeeva.digitalocean.exception.DigitalOceanException;
import com.myjeeva.digitalocean.exception.RequestUnsuccessfulException;
import com.myjeeva.digitalocean.http.client.methods.CustomHttpDelete;
import com.myjeeva.digitalocean.impl.ApiRequest;
import com.myjeeva.digitalocean.impl.ApiResponse;
import com.myjeeva.digitalocean.pojo.Account;
import com.myjeeva.digitalocean.pojo.Action;
import com.myjeeva.digitalocean.pojo.Actions;
import com.myjeeva.digitalocean.pojo.Backups;
import com.myjeeva.digitalocean.pojo.Certificate;
import com.myjeeva.digitalocean.pojo.Certificates;
import com.myjeeva.digitalocean.pojo.Delete;
import com.myjeeva.digitalocean.pojo.Domain;
import com.myjeeva.digitalocean.pojo.DomainRecord;
import com.myjeeva.digitalocean.pojo.DomainRecords;
import com.myjeeva.digitalocean.pojo.Domains;
import com.myjeeva.digitalocean.pojo.Droplet;
import com.myjeeva.digitalocean.pojo.DropletAction;
import com.myjeeva.digitalocean.pojo.Droplets;
import com.myjeeva.digitalocean.pojo.Firewall;
import com.myjeeva.digitalocean.pojo.Firewalls;
import com.myjeeva.digitalocean.pojo.FloatingIP;
import com.myjeeva.digitalocean.pojo.FloatingIPAction;
import com.myjeeva.digitalocean.pojo.FloatingIPs;
import com.myjeeva.digitalocean.pojo.ForwardingRules;
import com.myjeeva.digitalocean.pojo.HealthCheck;
import com.myjeeva.digitalocean.pojo.Image;
import com.myjeeva.digitalocean.pojo.ImageAction;
import com.myjeeva.digitalocean.pojo.Images;
import com.myjeeva.digitalocean.pojo.Kernels;
import com.myjeeva.digitalocean.pojo.Key;
import com.myjeeva.digitalocean.pojo.Keys;
import com.myjeeva.digitalocean.pojo.LoadBalancer;
import com.myjeeva.digitalocean.pojo.LoadBalancers;
import com.myjeeva.digitalocean.pojo.Neighbors;
import com.myjeeva.digitalocean.pojo.Project;
import com.myjeeva.digitalocean.pojo.Projects;
import com.myjeeva.digitalocean.pojo.Regions;
import com.myjeeva.digitalocean.pojo.Resource;
import com.myjeeva.digitalocean.pojo.Resources;
import com.myjeeva.digitalocean.pojo.Response;
import com.myjeeva.digitalocean.pojo.Sizes;
import com.myjeeva.digitalocean.pojo.Snapshot;
import com.myjeeva.digitalocean.pojo.Snapshots;
import com.myjeeva.digitalocean.pojo.Tag;
import com.myjeeva.digitalocean.pojo.Tags;
import com.myjeeva.digitalocean.pojo.Volume;
import com.myjeeva.digitalocean.pojo.VolumeAction;
import com.myjeeva.digitalocean.pojo.Volumes;
import com.myjeeva.digitalocean.serializer.DropletSerializer;
import com.myjeeva.digitalocean.serializer.FirewallSerializer;
import com.myjeeva.digitalocean.serializer.LoadBalancerSerializer;
import com.myjeeva.digitalocean.serializer.VolumeSerializer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigitalOceanClient
implements DigitalOcean,
Constants {
    private static final Logger log = LoggerFactory.getLogger(DigitalOceanClient.class);
    protected CloseableHttpClient httpClient;
    protected String authToken;
    protected String apiVersion;
    protected String apiHost = "api.digitalocean.com";
    private Gson deserialize;
    private Gson serialize;
    private Header[] requestHeaders;

    public DigitalOceanClient(String authToken) {
        this("v2", authToken);
    }

    public DigitalOceanClient(String apiVersion, String authToken) {
        this(apiVersion, authToken, null);
    }

    public DigitalOceanClient(String apiVersion, String authToken, CloseableHttpClient httpClient) {
        if (!"v2".equalsIgnoreCase(apiVersion)) {
            throw new IllegalArgumentException("Only API version 2 is supported.");
        }
        this.apiVersion = apiVersion;
        this.authToken = authToken;
        this.httpClient = httpClient;
        this.initialize();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Override
    public Droplets getAvailableDroplets(Integer pageNo, Integer perPage) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validatePageNo(pageNo);
        return (Droplets)this.perform(new ApiRequest(ApiAction.AVAILABLE_DROPLETS, pageNo, perPage)).getData();
    }

    @Override
    public Kernels getDropletKernels(Integer dropletId, Integer pageNo, Integer perPage) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletIdAndPageNo(dropletId, pageNo);
        Object[] params = new Object[]{dropletId};
        return (Kernels)this.perform(new ApiRequest(ApiAction.GET_DROPLETS_KERNELS, params, pageNo, perPage)).getData();
    }

    @Override
    public Snapshots getDropletSnapshots(Integer dropletId, Integer pageNo, Integer perPage) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletIdAndPageNo(dropletId, pageNo);
        Object[] params = new Object[]{dropletId};
        return (Snapshots)this.perform(new ApiRequest(ApiAction.GET_DROPLET_SNAPSHOTS, params, pageNo, perPage)).getData();
    }

    @Override
    public Backups getDropletBackups(Integer dropletId, Integer pageNo, Integer perPage) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletIdAndPageNo(dropletId, pageNo);
        Object[] params = new Object[]{dropletId};
        return (Backups)this.perform(new ApiRequest(ApiAction.GET_DROPLET_BACKUPS, params, pageNo, perPage)).getData();
    }

    @Override
    public Droplet getDropletInfo(Integer dropletId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        Object[] params = new Object[]{dropletId};
        return (Droplet)this.perform(new ApiRequest(ApiAction.GET_DROPLET_INFO, params)).getData();
    }

    @Override
    public Droplet createDroplet(Droplet droplet) throws DigitalOceanException, RequestUnsuccessfulException {
        if (null == droplet || StringUtils.isBlank((CharSequence)droplet.getName()) || null == droplet.getRegion() || null == droplet.getSize() || null == droplet.getImage() || null == droplet.getImage().getId() && null == droplet.getImage().getSlug()) {
            throw new IllegalArgumentException("Missing required parameters [Name, Region Slug, Size Slug, Image Id/Slug] for create droplet.");
        }
        return (Droplet)this.perform(new ApiRequest(ApiAction.CREATE_DROPLET, droplet)).getData();
    }

    @Override
    public Droplets createDroplets(Droplet droplet) throws DigitalOceanException, RequestUnsuccessfulException {
        if (null == droplet || null == droplet.getNames() || droplet.getNames().isEmpty() || null == droplet.getRegion() || null == droplet.getSize() || null == droplet.getImage() || null == droplet.getImage().getId() && null == droplet.getImage().getSlug()) {
            throw new IllegalArgumentException("Missing required parameters [Names, Region Slug, Size Slug, Image Id/Slug] for creating multiple droplets.");
        }
        if (StringUtils.isNotBlank((CharSequence)droplet.getName())) {
            throw new IllegalArgumentException("Name parameter is not allowed, while creating multiple droplet instead use 'names' attributes.");
        }
        return (Droplets)this.perform(new ApiRequest(ApiAction.CREATE_DROPLETS, droplet)).getData();
    }

    @Override
    public Delete deleteDroplet(Integer dropletId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        Object[] params = new Object[]{dropletId};
        return (Delete)this.perform(new ApiRequest(ApiAction.DELETE_DROPLET, params)).getData();
    }

    @Override
    public Delete deleteDropletByTagName(String tagName) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(tagName, "Missing required parameter - tagName.");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("tag_name", tagName);
        return (Delete)this.perform(new ApiRequest(ApiAction.DELETE_DROPLET_BY_TAG_NAME, null, queryParams, null)).getData();
    }

    @Override
    public Droplets getDropletNeighbors(Integer dropletId, Integer pageNo) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletIdAndPageNo(dropletId, pageNo);
        Object[] params = new Object[]{dropletId};
        return (Droplets)this.perform(new ApiRequest(ApiAction.GET_DROPLET_NEIGHBORS, params, pageNo, null)).getData();
    }

    @Override
    public Neighbors getAllDropletNeighbors(Integer pageNo) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validatePageNo(pageNo);
        return (Neighbors)this.perform(new ApiRequest(ApiAction.ALL_DROPLET_NEIGHBORS, pageNo)).getData();
    }

    @Override
    public Droplets getAvailableDropletsByTagName(String tagName, Integer pageNo, Integer perPage) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(tagName, "Missing required parameter - tagName.");
        this.validatePageNo(pageNo);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("tag_name", tagName);
        return (Droplets)this.perform(new ApiRequest(ApiAction.AVAILABLE_DROPLETS, pageNo, queryParams, perPage)).getData();
    }

    @Override
    public Action rebootDroplet(Integer dropletId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        Object[] params = new Object[]{dropletId};
        return (Action)this.perform(new ApiRequest(ApiAction.REBOOT_DROPLET, new DropletAction(ActionType.REBOOT), params)).getData();
    }

    @Override
    public Action powerCycleDroplet(Integer dropletId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        Object[] params = new Object[]{dropletId};
        return (Action)this.perform(new ApiRequest(ApiAction.POWER_CYCLE_DROPLET, new DropletAction(ActionType.POWER_CYCLE), params)).getData();
    }

    @Override
    public Action shutdownDroplet(Integer dropletId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        Object[] params = new Object[]{dropletId};
        return (Action)this.perform(new ApiRequest(ApiAction.SHUTDOWN_DROPLET, new DropletAction(ActionType.SHUTDOWN), params)).getData();
    }

    @Override
    public Action powerOffDroplet(Integer dropletId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        Object[] params = new Object[]{dropletId};
        return (Action)this.perform(new ApiRequest(ApiAction.POWER_OFF_DROPLET, new DropletAction(ActionType.POWER_OFF), params)).getData();
    }

    @Override
    public Action powerOnDroplet(Integer dropletId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        Object[] params = new Object[]{dropletId};
        return (Action)this.perform(new ApiRequest(ApiAction.POWER_ON_DROPLET, new DropletAction(ActionType.POWER_ON), params)).getData();
    }

    @Override
    public Action resetDropletPassword(Integer dropletId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        Object[] params = new Object[]{dropletId};
        return (Action)this.perform(new ApiRequest(ApiAction.RESET_DROPLET_PASSWORD, new DropletAction(ActionType.PASSWORD_RESET), params)).getData();
    }

    @Override
    public Action resizeDroplet(Integer dropletId, String size) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        Object[] params = new Object[]{dropletId};
        DropletAction action = new DropletAction(ActionType.RESIZE);
        action.setSize(size);
        return (Action)this.perform(new ApiRequest(ApiAction.RESIZE_DROPLET, action, params)).getData();
    }

    @Override
    public Action resizeDroplet(Integer dropletId, String size, Boolean disk) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        Object[] params = new Object[]{dropletId};
        DropletAction action = new DropletAction(ActionType.RESIZE);
        action.setSize(size);
        action.setDisk(disk);
        return (Action)this.perform(new ApiRequest(ApiAction.RESIZE_DROPLET, action, params)).getData();
    }

    @Override
    public Action takeDropletSnapshot(Integer dropletId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        Object[] params = new Object[]{dropletId};
        return (Action)this.perform(new ApiRequest(ApiAction.SNAPSHOT_DROPLET, new DropletAction(ActionType.SNAPSHOT), params)).getData();
    }

    @Override
    public Action takeDropletSnapshot(Integer dropletId, String snapshotName) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        Object[] params = new Object[]{dropletId};
        DropletAction action = new DropletAction(ActionType.SNAPSHOT);
        action.setName(snapshotName);
        return (Action)this.perform(new ApiRequest(ApiAction.SNAPSHOT_DROPLET, action, params)).getData();
    }

    @Override
    public Action restoreDroplet(Integer dropletId, Integer imageId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        Object[] params = new Object[]{dropletId};
        DropletAction action = new DropletAction(ActionType.RESTORE);
        action.setImage(imageId);
        return (Action)this.perform(new ApiRequest(ApiAction.RESTORE_DROPLET, action, params)).getData();
    }

    @Override
    public Action rebuildDroplet(Integer dropletId, Integer imageId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        Object[] params = new Object[]{dropletId};
        DropletAction action = new DropletAction(ActionType.REBUILD);
        action.setImage(imageId);
        return (Action)this.perform(new ApiRequest(ApiAction.REBUILD_DROPLET, action, params)).getData();
    }

    @Override
    public Action enableDropletBackups(Integer dropletId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        Object[] params = new Object[]{dropletId};
        return (Action)this.perform(new ApiRequest(ApiAction.ENABLE_DROPLET_BACKUPS, new DropletAction(ActionType.ENABLE_BACKUPS), params)).getData();
    }

    @Override
    public Action disableDropletBackups(Integer dropletId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        Object[] params = new Object[]{dropletId};
        return (Action)this.perform(new ApiRequest(ApiAction.DISABLE_DROPLET_BACKUPS, new DropletAction(ActionType.DISABLE_BACKUPS), params)).getData();
    }

    @Override
    public Action renameDroplet(Integer dropletId, String name) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        Object[] params = new Object[]{dropletId};
        DropletAction action = new DropletAction(ActionType.RENAME);
        action.setName(name);
        return (Action)this.perform(new ApiRequest(ApiAction.RENAME_DROPLET, action, params)).getData();
    }

    @Override
    public Action changeDropletKernel(Integer dropletId, Integer kernelId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        Object[] params = new Object[]{dropletId};
        DropletAction action = new DropletAction(ActionType.CHANGE_KERNEL);
        action.setKernel(kernelId);
        return (Action)this.perform(new ApiRequest(ApiAction.CHANGE_DROPLET_KERNEL, action, params)).getData();
    }

    @Override
    public Action enableDropletIpv6(Integer dropletId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        Object[] params = new Object[]{dropletId};
        return (Action)this.perform(new ApiRequest(ApiAction.ENABLE_DROPLET_IPV6, new DropletAction(ActionType.ENABLE_IPV6), params)).getData();
    }

    @Override
    public Action enableDropletPrivateNetworking(Integer dropletId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        Object[] params = new Object[]{dropletId};
        return (Action)this.perform(new ApiRequest(ApiAction.ENABLE_DROPLET_PRIVATE_NETWORKING, new DropletAction(ActionType.ENABLE_PRIVATE_NETWORKING), params)).getData();
    }

    @Override
    public Account getAccountInfo() throws DigitalOceanException, RequestUnsuccessfulException {
        return (Account)this.perform(new ApiRequest(ApiAction.GET_ACCOUNT_INFO)).getData();
    }

    @Override
    public Actions getAvailableActions(Integer pageNo, Integer perPage) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validatePageNo(pageNo);
        return (Actions)this.perform(new ApiRequest(ApiAction.AVAILABLE_ACTIONS, pageNo, perPage)).getData();
    }

    @Override
    public Action getActionInfo(Integer actionId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkNullAndThrowError(actionId, "Missing required parameter - actionId");
        Object[] params = new Object[]{actionId};
        return (Action)this.perform(new ApiRequest(ApiAction.GET_ACTION_INFO, params)).getData();
    }

    @Override
    public Actions getAvailableDropletActions(Integer dropletId, Integer pageNo, Integer perPage) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletIdAndPageNo(dropletId, pageNo);
        Object[] params = new Object[]{dropletId};
        return (Actions)this.perform(new ApiRequest(ApiAction.GET_DROPLET_ACTIONS, params, pageNo, perPage)).getData();
    }

    @Override
    public Actions getAvailableImageActions(Integer imageId, Integer pageNo, Integer perPage) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkNullAndThrowError(imageId, "Missing required parameter - imageId.");
        this.validatePageNo(pageNo);
        Object[] params = new Object[]{imageId};
        return (Actions)this.perform(new ApiRequest(ApiAction.GET_IMAGE_ACTIONS, params, pageNo, perPage)).getData();
    }

    @Override
    public Actions getAvailableFloatingIPActions(String ipAddress, Integer pageNo, Integer perPage) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(ipAddress, "Missing required parameter - ipAddress.");
        this.validatePageNo(pageNo);
        Object[] params = new Object[]{ipAddress};
        return (Actions)this.perform(new ApiRequest(ApiAction.GET_FLOATING_IP_ACTIONS, params, pageNo, perPage)).getData();
    }

    @Override
    public Action getFloatingIPActionInfo(String ipAddress, Integer actionId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(ipAddress, "Missing required parameter - ipAddress.");
        this.checkNullAndThrowError(actionId, "Missing required parameter - actionId.");
        Object[] params = new Object[]{ipAddress, actionId};
        return (Action)this.perform(new ApiRequest(ApiAction.GET_FLOATING_IP_ACTION_INFO, params)).getData();
    }

    @Override
    public Actions getAvailableVolumeActions(String volumeId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(volumeId, "Missing required parameter - volumeId.");
        Object[] params = new Object[]{volumeId};
        return (Actions)this.perform(new ApiRequest(ApiAction.GET_VOLUME_ACTIONS, params)).getData();
    }

    @Override
    public Action getVolumeAction(String volumeId, Integer actionId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(volumeId, "Missing required parameter - volumeId.");
        this.checkNullAndThrowError(actionId, "Missing required parameter - actionId.");
        Object[] params = new Object[]{volumeId, actionId};
        return (Action)this.perform(new ApiRequest(ApiAction.GET_VOLUME_ACTION, params)).getData();
    }

    @Override
    public Images getAvailableImages(Integer pageNo, Integer perPage) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validatePageNo(pageNo);
        return (Images)this.perform(new ApiRequest(ApiAction.AVAILABLE_IMAGES, pageNo, perPage)).getData();
    }

    @Override
    public Images getAvailableImages(Integer pageNo, Integer perPage, ActionType type) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validatePageNo(pageNo);
        if (!ActionType.DISTRIBUTION.equals((Object)type) && !ActionType.APPLICATION.equals((Object)type)) {
            throw new DigitalOceanException("Incorrect type value [Allowed: DISTRIBUTION or APPLICATION].");
        }
        HashMap<String, String> qp = new HashMap<String, String>();
        qp.put("type", type.toString());
        return (Images)this.perform(new ApiRequest(ApiAction.AVAILABLE_IMAGES, pageNo, qp, perPage)).getData();
    }

    @Override
    public Images getUserImages(Integer pageNo, Integer perPage) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validatePageNo(pageNo);
        HashMap<String, String> qp = new HashMap<String, String>();
        qp.put("private", "true");
        return (Images)this.perform(new ApiRequest(ApiAction.AVAILABLE_IMAGES, pageNo, qp, perPage)).getData();
    }

    @Override
    public Image getImageInfo(Integer imageId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkNullAndThrowError(imageId, "Missing required parameter - imageId.");
        Object[] params = new Object[]{imageId};
        return (Image)this.perform(new ApiRequest(ApiAction.GET_IMAGE_INFO, params)).getData();
    }

    @Override
    public Image getImageInfo(String slug) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(slug, "Missing required parameter - slug.");
        Object[] params = new Object[]{slug};
        return (Image)this.perform(new ApiRequest(ApiAction.GET_IMAGE_INFO, params)).getData();
    }

    @Override
    public Image createCustomImage(Image image) throws DigitalOceanException, RequestUnsuccessfulException {
        if (null == image || StringUtils.isBlank((CharSequence)image.getName()) || StringUtils.isBlank((CharSequence)image.getUrl()) || StringUtils.isBlank((CharSequence)image.getRegion())) {
            throw new IllegalArgumentException("Missing required parameter to create custom image [name, url, or region].");
        }
        return (Image)this.perform(new ApiRequest(ApiAction.CREATE_CUSTOM_IMAGE, image)).getData();
    }

    @Override
    public Image updateImage(Image image) throws DigitalOceanException, RequestUnsuccessfulException {
        if (null == image || null == image.getName()) {
            throw new IllegalArgumentException("Missing required parameter - image object.");
        }
        Object[] params = new Object[]{image.getId()};
        return (Image)this.perform(new ApiRequest(ApiAction.UPDATE_IMAGE_INFO, image, params)).getData();
    }

    @Override
    public Delete deleteImage(Integer imageId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkNullAndThrowError(imageId, "Missing required parameter - imageId.");
        Object[] params = new Object[]{imageId};
        return (Delete)this.perform(new ApiRequest(ApiAction.DELETE_IMAGE, params)).getData();
    }

    @Override
    public Action transferImage(Integer imageId, String regionSlug) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkNullAndThrowError(imageId, "Missing required parameter - imageId.");
        this.checkBlankAndThrowError(regionSlug, "Missing required parameter - regionSlug.");
        Object[] params = new Object[]{imageId};
        return (Action)this.perform(new ApiRequest(ApiAction.TRANSFER_IMAGE, new ImageAction(ActionType.TRANSFER, regionSlug), params)).getData();
    }

    @Override
    public Action convertImage(Integer imageId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkNullAndThrowError(imageId, "Missing required parameter - imageId.");
        Object[] params = new Object[]{imageId};
        return (Action)this.perform(new ApiRequest(ApiAction.CONVERT_IMAGE, new ImageAction(ActionType.CONVERT), params)).getData();
    }

    @Override
    public Regions getAvailableRegions(Integer pageNo) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validatePageNo(pageNo);
        return (Regions)this.perform(new ApiRequest(ApiAction.AVAILABLE_REGIONS, pageNo, 25)).getData();
    }

    @Override
    public Sizes getAvailableSizes(Integer pageNo) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validatePageNo(pageNo);
        return (Sizes)this.perform(new ApiRequest(ApiAction.AVAILABLE_SIZES, pageNo, 25)).getData();
    }

    @Override
    public Domains getAvailableDomains(Integer pageNo) throws DigitalOceanException, RequestUnsuccessfulException {
        return (Domains)this.perform(new ApiRequest(ApiAction.AVAILABLE_DOMAINS, pageNo, 25)).getData();
    }

    @Override
    public Domain getDomainInfo(String domainName) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(domainName, "Missing required parameter - domainName.");
        Object[] params = new Object[]{domainName};
        return (Domain)this.perform(new ApiRequest(ApiAction.GET_DOMAIN_INFO, params)).getData();
    }

    @Override
    public Domain createDomain(Domain domain) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(domain.getName(), "Missing required parameter - domainName.");
        return (Domain)this.perform(new ApiRequest(ApiAction.CREATE_DOMAIN, domain)).getData();
    }

    @Override
    public Delete deleteDomain(String domainName) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(domainName, "Missing required parameter - domainName.");
        Object[] params = new Object[]{domainName};
        return (Delete)this.perform(new ApiRequest(ApiAction.DELETE_DOMAIN, params)).getData();
    }

    @Override
    public DomainRecords getDomainRecords(String domainName, Integer pageNo, Integer perPage) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(domainName, "Missing required parameter - domainName.");
        Object[] params = new Object[]{domainName};
        return (DomainRecords)this.perform(new ApiRequest(ApiAction.GET_DOMAIN_RECORDS, params, pageNo, perPage)).getData();
    }

    @Override
    public DomainRecord getDomainRecordInfo(String domainName, Integer recordId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(domainName, "Missing required parameter - domainName.");
        this.checkNullAndThrowError(recordId, "Missing required parameter - recordId.");
        Object[] params = new Object[]{domainName, recordId};
        return (DomainRecord)this.perform(new ApiRequest(ApiAction.GET_DOMAIN_RECORD_INFO, params)).getData();
    }

    @Override
    public DomainRecord createDomainRecord(String domainName, DomainRecord domainRecord) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(domainName, "Missing required parameter - domainName.");
        this.checkNullAndThrowError(domainRecord, "Missing required parameter - domainRecord");
        Object[] params = new Object[]{domainName};
        return (DomainRecord)this.perform(new ApiRequest(ApiAction.CREATE_DOMAIN_RECORD, domainRecord, params)).getData();
    }

    @Override
    public DomainRecord updateDomainRecord(String domainName, Integer recordId, DomainRecord domainRecord) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(domainName, "Missing required parameter - domainName.");
        this.checkNullAndThrowError(recordId, "Missing required parameter - recordId.");
        this.checkNullAndThrowError(domainRecord, "Missing required parameter - domainRecord");
        Object[] params = new Object[]{domainName, recordId};
        return (DomainRecord)this.perform(new ApiRequest(ApiAction.UPDATE_DOMAIN_RECORD, domainRecord, params)).getData();
    }

    @Override
    public Delete deleteDomainRecord(String domainName, Integer recordId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(domainName, "Missing required parameter - domainName.");
        this.checkNullAndThrowError(recordId, "Missing required parameter - recordId.");
        Object[] params = new Object[]{domainName, recordId};
        return (Delete)this.perform(new ApiRequest(ApiAction.DELETE_DOMAIN_RECORD, params)).getData();
    }

    @Override
    public Keys getAvailableKeys(Integer pageNo) throws DigitalOceanException, RequestUnsuccessfulException {
        return (Keys)this.perform(new ApiRequest(ApiAction.AVAILABLE_KEYS, pageNo, 25)).getData();
    }

    @Override
    public Key getKeyInfo(Integer sshKeyId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkNullAndThrowError(sshKeyId, "Missing required parameter - sshKeyId.");
        Object[] params = new Object[]{sshKeyId};
        return (Key)this.perform(new ApiRequest(ApiAction.GET_KEY_INFO, params)).getData();
    }

    @Override
    public Key getKeyInfo(String fingerprint) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(fingerprint, "Missing required parameter - fingerprint.");
        Object[] params = new Object[]{fingerprint};
        return (Key)this.perform(new ApiRequest(ApiAction.GET_KEY_INFO, params)).getData();
    }

    @Override
    public Key createKey(Key newKey) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkNullAndThrowError(newKey, "Missing required parameter - newKey");
        this.checkBlankAndThrowError(newKey.getName(), "Missing required parameter - name.");
        this.checkBlankAndThrowError(newKey.getPublicKey(), "Missing required parameter - publicKey.");
        return (Key)this.perform(new ApiRequest(ApiAction.CREATE_KEY, newKey)).getData();
    }

    @Override
    public Key updateKey(Integer sshKeyId, String newSshKeyName) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkNullAndThrowError(sshKeyId, "Missing required parameter - sshKeyId.");
        this.checkBlankAndThrowError(newSshKeyName, "Missing required parameter - newSshKeyName.");
        Object[] params = new Object[]{sshKeyId};
        return (Key)this.perform(new ApiRequest(ApiAction.UPDATE_KEY, new Key(newSshKeyName), params)).getData();
    }

    @Override
    public Key updateKey(String fingerprint, String newSshKeyName) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(fingerprint, "Missing required parameter - fingerprint.");
        this.checkBlankAndThrowError(newSshKeyName, "Missing required parameter - newSshKeyName.");
        Object[] params = new Object[]{fingerprint};
        return (Key)this.perform(new ApiRequest(ApiAction.UPDATE_KEY, new Key(newSshKeyName), params)).getData();
    }

    @Override
    public Delete deleteKey(Integer sshKeyId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkNullAndThrowError(sshKeyId, "Missing required parameter - sshKeyId.");
        Object[] params = new Object[]{sshKeyId};
        return (Delete)this.perform(new ApiRequest(ApiAction.DELETE_KEY, params)).getData();
    }

    @Override
    public Delete deleteKey(String fingerprint) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(fingerprint, "Missing required parameter - fingerprint.");
        Object[] params = new Object[]{fingerprint};
        return (Delete)this.perform(new ApiRequest(ApiAction.DELETE_KEY, params)).getData();
    }

    @Override
    public FloatingIPs getAvailableFloatingIPs(Integer pageNo, Integer perPage) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validatePageNo(pageNo);
        return (FloatingIPs)this.perform(new ApiRequest(ApiAction.FLOATING_IPS, pageNo, perPage)).getData();
    }

    @Override
    public FloatingIP createFloatingIP(Integer dropletId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        return (FloatingIP)this.perform(new ApiRequest(ApiAction.CREATE_FLOATING_IP, new FloatingIPAction(dropletId))).getData();
    }

    @Override
    public FloatingIP createFloatingIP(String region) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(region, "Missing required parameter - region.");
        return (FloatingIP)this.perform(new ApiRequest(ApiAction.CREATE_FLOATING_IP, new FloatingIPAction(region))).getData();
    }

    @Override
    public FloatingIP getFloatingIPInfo(String ipAddress) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(ipAddress, "Missing required parameter - ipAddress.");
        Object[] params = new Object[]{ipAddress};
        return (FloatingIP)this.perform(new ApiRequest(ApiAction.GET_FLOATING_IP_INFO, params)).getData();
    }

    @Override
    public Delete deleteFloatingIP(String ipAddress) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(ipAddress, "Missing required parameter - ipAddress.");
        Object[] params = new Object[]{ipAddress};
        return (Delete)this.perform(new ApiRequest(ApiAction.DELETE_FLOATING_IP, params)).getData();
    }

    @Override
    public Action assignFloatingIP(Integer dropletId, String ipAddress) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        this.checkBlankAndThrowError(ipAddress, "Missing required parameter - ipAddress.");
        Object[] params = new Object[]{ipAddress};
        return (Action)this.perform(new ApiRequest(ApiAction.ASSIGN_FLOATING_IP, new FloatingIPAction(dropletId, "assign"), params)).getData();
    }

    @Override
    public Action unassignFloatingIP(String ipAddress) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(ipAddress, "Missing required parameter - ipAddress.");
        Object[] params = new Object[]{ipAddress};
        return (Action)this.perform(new ApiRequest(ApiAction.UNASSIGN_FLOATING_IP, new FloatingIPAction(null, "unassign"), params)).getData();
    }

    @Override
    public Tags getAvailableTags(Integer pageNo, Integer perPage) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validatePageNo(pageNo);
        return (Tags)this.perform(new ApiRequest(ApiAction.AVAILABLE_TAGS, pageNo, perPage)).getData();
    }

    @Override
    public Tag createTag(String name) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(name, "Missing required parameter - tag name");
        return (Tag)this.perform(new ApiRequest(ApiAction.CREATE_TAG, new Tag(name))).getData();
    }

    @Override
    public Tag getTag(String name) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(name, "Missing required parameter - tag name");
        Object[] params = new Object[]{name};
        return (Tag)this.perform(new ApiRequest(ApiAction.GET_TAG, params)).getData();
    }

    @Override
    public Delete deleteTag(String name) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(name, "Missing required parameter - tag name");
        Object[] params = new Object[]{name};
        return (Delete)this.perform(new ApiRequest(ApiAction.DELETE_TAG, params)).getData();
    }

    @Override
    public Response tagResources(String name, List<Resource> resources) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(name, "Missing required parameter - tag name");
        if (null == resources || resources.isEmpty()) {
            throw new IllegalArgumentException("Missing required parameter - list of resources for tag");
        }
        Object[] params = new Object[]{name};
        return (Response)this.perform(new ApiRequest(ApiAction.TAG_RESOURCE, new Resources(resources), params)).getData();
    }

    @Override
    public Response untagResources(String name, List<Resource> resources) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(name, "Missing required parameter - tag name");
        if (null == resources || resources.isEmpty()) {
            throw new IllegalArgumentException("Missing required parameter - list of resources for untag");
        }
        Object[] params = new Object[]{name};
        return (Response)this.perform(new ApiRequest(ApiAction.UNTAG_RESOURCE, new Resources(resources), params)).getData();
    }

    @Override
    public Volumes getAvailableVolumes(String regionSlug) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(regionSlug, "Missing required parameter - regionSlug.");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("region", regionSlug);
        return (Volumes)this.perform(new ApiRequest(ApiAction.AVAILABLE_VOLUMES, data)).getData();
    }

    @Override
    public Volume createVolume(Volume volume) throws DigitalOceanException, RequestUnsuccessfulException {
        if (null == volume || StringUtils.isBlank((CharSequence)volume.getName()) || null == volume.getRegion() || null == volume.getSize()) {
            throw new IllegalArgumentException("Missing required parameters [Name, Region Slug, Size] for create volume.");
        }
        return (Volume)this.perform(new ApiRequest(ApiAction.CREATE_VOLUME, volume)).getData();
    }

    @Override
    public Volume getVolumeInfo(String volumeId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(volumeId, "Missing required parameter - volumeId.");
        Object[] params = new Object[]{volumeId};
        return (Volume)this.perform(new ApiRequest(ApiAction.GET_VOLUME_INFO, params)).getData();
    }

    @Override
    public Volumes getVolumeInfo(String volumeName, String regionSlug) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(volumeName, "Missing required parameter - volumeName.");
        this.checkBlankAndThrowError(regionSlug, "Missing required parameter - regionSlug.");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("region", regionSlug);
        data.put("name", volumeName);
        return (Volumes)this.perform(new ApiRequest(ApiAction.GET_VOLUME_INFO_BY_NAME, data)).getData();
    }

    @Override
    public Delete deleteVolume(String volumeId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(volumeId, "Missing required parameter - volumeId.");
        Object[] params = new Object[]{volumeId};
        return (Delete)this.perform(new ApiRequest(ApiAction.DELETE_VOLUME, params)).getData();
    }

    @Override
    public Delete deleteVolume(String volumeName, String regionSlug) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(volumeName, "Missing required parameter - volumeName.");
        this.checkBlankAndThrowError(regionSlug, "Missing required parameter - regionSlug.");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("region", regionSlug);
        data.put("name", volumeName);
        return (Delete)this.perform(new ApiRequest(ApiAction.DELETE_VOLUME_BY_NAME, data)).getData();
    }

    @Override
    public Action attachVolume(Integer dropletId, String volumeId, String regionSlug) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        this.checkBlankAndThrowError(volumeId, "Missing required parameter - volumeId.");
        this.checkBlankAndThrowError(regionSlug, "Missing required parameter - regionSlug.");
        Object[] params = new Object[]{volumeId};
        return (Action)this.perform(new ApiRequest(ApiAction.ACTIONS_VOLUME, new VolumeAction(ActionType.ATTACH, dropletId, regionSlug), params)).getData();
    }

    @Override
    public Action attachVolumeByName(Integer dropletId, String volumeName, String regionSlug) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        this.checkBlankAndThrowError(volumeName, "Missing required parameter - volumeName.");
        this.checkBlankAndThrowError(regionSlug, "Missing required parameter - regionSlug.");
        return (Action)this.perform(new ApiRequest(ApiAction.ACTIONS_VOLUME_BY_NAME, new VolumeAction(ActionType.ATTACH, dropletId, regionSlug, volumeName, null))).getData();
    }

    @Override
    public Action detachVolume(Integer dropletId, String volumeId, String regionSlug) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        this.checkBlankAndThrowError(volumeId, "Missing required parameter - volumeId.");
        this.checkBlankAndThrowError(regionSlug, "Missing required parameter - regionSlug.");
        Object[] params = new Object[]{volumeId};
        return (Action)this.perform(new ApiRequest(ApiAction.ACTIONS_VOLUME, new VolumeAction(ActionType.DETACH, dropletId, regionSlug), params)).getData();
    }

    @Override
    public Action detachVolumeByName(Integer dropletId, String volumeName, String regionSlug) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateDropletId(dropletId);
        this.checkBlankAndThrowError(volumeName, "Missing required parameter - volumeName.");
        this.checkBlankAndThrowError(regionSlug, "Missing required parameter - regionSlug.");
        return (Action)this.perform(new ApiRequest(ApiAction.ACTIONS_VOLUME_BY_NAME, new VolumeAction(ActionType.DETACH, dropletId, regionSlug, volumeName, null))).getData();
    }

    @Override
    public Action resizeVolume(String volumeId, String regionSlug, Double sizeGigabytes) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(volumeId, "Missing required parameter - volumeId.");
        this.checkBlankAndThrowError(regionSlug, "Missing required parameter - regionSlug.");
        if (null == sizeGigabytes) {
            throw new IllegalArgumentException("Missing required parameter - sizeGigabytes.");
        }
        Object[] params = new Object[]{volumeId};
        return (Action)this.perform(new ApiRequest(ApiAction.ACTIONS_VOLUME, new VolumeAction(ActionType.RESIZE, regionSlug, sizeGigabytes), params)).getData();
    }

    @Override
    public Snapshots getVolumeSnapshots(String volumeId, Integer pageNo, Integer perPage) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validatePageNo(pageNo);
        this.checkBlankAndThrowError(volumeId, "Missing required parameter - volumeId.");
        Object[] params = new Object[]{volumeId};
        return (Snapshots)this.perform(new ApiRequest(ApiAction.GET_VOLUME_SNAPSHOTS, params, pageNo, perPage)).getData();
    }

    @Override
    public Snapshot takeVolumeSnapshot(String volumeId, String snapshotName) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(volumeId, "Missing required parameter - volumeId.");
        this.checkBlankAndThrowError(snapshotName, "Missing required parameter - snapshotName.");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", snapshotName);
        Object[] params = new Object[]{volumeId};
        return (Snapshot)this.perform(new ApiRequest(ApiAction.SNAPSHOT_VOLUME, data, params)).getData();
    }

    @Override
    public Snapshots getAvailableSnapshots(Integer pageNo, Integer perPage) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validatePageNo(pageNo);
        return (Snapshots)this.perform(new ApiRequest(ApiAction.AVAILABLE_SNAPSHOTS, pageNo, perPage)).getData();
    }

    @Override
    public Snapshots getAllDropletSnapshots(Integer pageNo, Integer perPage) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validatePageNo(pageNo);
        HashMap<String, String> qp = new HashMap<String, String>();
        qp.put("resource_type", "droplet");
        return (Snapshots)this.perform(new ApiRequest(ApiAction.ALL_DROPLET_SNAPSHOTS, pageNo, qp, perPage)).getData();
    }

    @Override
    public Snapshots getAllVolumeSnapshots(Integer pageNo, Integer perPage) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validatePageNo(pageNo);
        HashMap<String, String> qp = new HashMap<String, String>();
        qp.put("resource_type", "volume");
        return (Snapshots)this.perform(new ApiRequest(ApiAction.ALL_VOLUME_SNAPSHOTS, pageNo, qp, perPage)).getData();
    }

    @Override
    public Snapshot getSnaphotInfo(String snapshotId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateSnapshotId(snapshotId);
        Object[] params = new Object[]{snapshotId};
        return (Snapshot)this.perform(new ApiRequest(ApiAction.GET_SNAPSHOT_INFO, params)).getData();
    }

    @Override
    public Delete deleteSnapshot(String snapshotId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateSnapshotId(snapshotId);
        Object[] params = new Object[]{snapshotId};
        return (Delete)this.perform(new ApiRequest(ApiAction.DELETE_SNAPSHOT, params)).getData();
    }

    @Override
    public LoadBalancer createLoadBalancer(LoadBalancer loadBalancer) throws DigitalOceanException, RequestUnsuccessfulException {
        if (null == loadBalancer || StringUtils.isBlank((CharSequence)loadBalancer.getName()) || null == loadBalancer.getRegion()) {
            throw new IllegalArgumentException("Missing required parameters [Name, Region Slug] for create loadBalancer.");
        }
        this.validateForwardingRules(loadBalancer.getForwardingRules());
        this.validateHealthCheck(loadBalancer.getHealthCheck());
        return (LoadBalancer)this.perform(new ApiRequest(ApiAction.CREATE_LOAD_BALANCER, loadBalancer)).getData();
    }

    @Override
    public LoadBalancer getLoadBalancerInfo(String loadBalancerId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateLoadBalancerId(loadBalancerId);
        Object[] params = new Object[]{loadBalancerId};
        return (LoadBalancer)this.perform(new ApiRequest(ApiAction.GET_LOAD_BALANCER_INFO, params)).getData();
    }

    @Override
    public LoadBalancers getAvailableLoadBalancers(Integer pageNo, Integer perPage) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validatePageNo(pageNo);
        return (LoadBalancers)this.perform(new ApiRequest(ApiAction.AVAILABLE_LOAD_BALANCERS, pageNo, perPage)).getData();
    }

    @Override
    public LoadBalancer updateLoadBalancer(LoadBalancer loadBalancer) throws DigitalOceanException, RequestUnsuccessfulException {
        if (null == loadBalancer || StringUtils.isBlank((CharSequence)loadBalancer.getId()) || StringUtils.isBlank((CharSequence)loadBalancer.getName()) || null == loadBalancer.getRegion()) {
            throw new IllegalArgumentException("Missing required parameters [Id, Name, Region Slug] for update loadBalancer.");
        }
        this.validateForwardingRules(loadBalancer.getForwardingRules());
        this.validateHealthCheck(loadBalancer.getHealthCheck());
        Object[] params = new Object[]{loadBalancer.getId()};
        return (LoadBalancer)this.perform(new ApiRequest(ApiAction.UPDATE_LOAD_BALANCER, loadBalancer, params)).getData();
    }

    @Override
    public Response addDropletsToLoadBalancer(String loadBalancerId, List<Integer> dropletIds) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateLoadBalancerId(loadBalancerId);
        if (null == dropletIds || dropletIds.isEmpty()) {
            throw new IllegalArgumentException("Missing required parameters [dropletIds].");
        }
        Object[] params = new Object[]{loadBalancerId};
        HashMap<String, List<Integer>> data = new HashMap<String, List<Integer>>();
        data.put("droplet_ids", dropletIds);
        return (Response)this.perform(new ApiRequest(ApiAction.ADD_DROPLET_TO_LOAD_BALANCER, data, params)).getData();
    }

    @Override
    public Delete removeDropletsFromLoadBalancer(String loadBalancerId, List<Integer> dropletIds) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateLoadBalancerId(loadBalancerId);
        if (null == dropletIds || dropletIds.isEmpty()) {
            throw new IllegalArgumentException("Missing required parameters [dropletIds].");
        }
        Object[] params = new Object[]{loadBalancerId};
        HashMap<String, List<Integer>> data = new HashMap<String, List<Integer>>();
        data.put("droplet_ids", dropletIds);
        return (Delete)this.perform(new ApiRequest(ApiAction.REMOVE_DROPLET_FROM_LOAD_BALANCER, data, params)).getData();
    }

    @Override
    public Response addForwardingRulesToLoadBalancer(String loadBalancerId, List<ForwardingRules> forwardingRules) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateLoadBalancerId(loadBalancerId);
        if (null == forwardingRules || forwardingRules.isEmpty()) {
            throw new IllegalArgumentException("Missing required parameters [forwardingRules].");
        }
        Object[] params = new Object[]{loadBalancerId};
        HashMap<String, List<ForwardingRules>> data = new HashMap<String, List<ForwardingRules>>();
        data.put("forwarding_rules", forwardingRules);
        return (Response)this.perform(new ApiRequest(ApiAction.ADD_FORWARDING_RULES_TO_LOAD_BALANCER, data, params)).getData();
    }

    @Override
    public Delete removeForwardingRulesFromLoadBalancer(String loadBalancerId, List<ForwardingRules> forwardingRules) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateLoadBalancerId(loadBalancerId);
        if (null == forwardingRules || forwardingRules.isEmpty()) {
            throw new IllegalArgumentException("Missing required parameters [forwardingRules].");
        }
        Object[] params = new Object[]{loadBalancerId};
        HashMap<String, List<ForwardingRules>> data = new HashMap<String, List<ForwardingRules>>();
        data.put("forwarding_rules", forwardingRules);
        return (Delete)this.perform(new ApiRequest(ApiAction.REMOVE_FORWARDING_RULES_FROM_LOAD_BALANCER, data, params)).getData();
    }

    @Override
    public Delete deleteLoadBalancer(String loadBalancerId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateLoadBalancerId(loadBalancerId);
        Object[] params = new Object[]{loadBalancerId};
        return (Delete)this.perform(new ApiRequest(ApiAction.DELETE_LOAD_BALANCER, params)).getData();
    }

    @Override
    public Certificates getAvailableCertificates(Integer pageNo, Integer perPage) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validatePageNo(pageNo);
        return (Certificates)this.perform(new ApiRequest(ApiAction.AVAILABLE_CERTIFICATES, pageNo, perPage)).getData();
    }

    @Override
    public Certificate createCertificate(Certificate certificate) throws DigitalOceanException, RequestUnsuccessfulException {
        if (null == certificate || StringUtils.isBlank((CharSequence)certificate.getName()) || StringUtils.isBlank((CharSequence)certificate.getPrivateKey()) || StringUtils.isBlank((CharSequence)certificate.getLeafCertificate()) || StringUtils.isBlank((CharSequence)certificate.getCertificateChain())) {
            throw new IllegalArgumentException("Missing required parameters [Name, Private Key, Leaf Certificate, Certificate Chain] for create certificate.");
        }
        return (Certificate)this.perform(new ApiRequest(ApiAction.CREATE_CERTIFICATE, certificate)).getData();
    }

    @Override
    public Certificate createLetsEncryptCertificate(Certificate certificate) throws DigitalOceanException, RequestUnsuccessfulException {
        if (null == certificate || StringUtils.isBlank((CharSequence)certificate.getName()) || StringUtils.isBlank((CharSequence)certificate.getType()) || certificate.getType() != "lets_encrypt" || certificate.getDnsNames() == null || certificate.getDnsNames().isEmpty()) {
            throw new IllegalArgumentException("Missing required parameters [Name, Type(lets_encrypt), List of DNS Names] for create Let's Encrypt certificate.");
        }
        return (Certificate)this.perform(new ApiRequest(ApiAction.CREATE_CERTIFICATE, certificate)).getData();
    }

    @Override
    public Certificate getCertificateInfo(String certificateId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(certificateId, "Missing required parameter - certificateId.");
        Object[] params = new Object[]{certificateId};
        return (Certificate)this.perform(new ApiRequest(ApiAction.GET_CERTIFICATE_INFO, params)).getData();
    }

    @Override
    public Delete deleteCertificate(String certificateId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(certificateId, "Missing required parameter - certificateId.");
        Object[] params = new Object[]{certificateId};
        return (Delete)this.perform(new ApiRequest(ApiAction.DELETE_CERTIFICATE, params)).getData();
    }

    @Override
    public Firewall createFirewall(Firewall firewall) throws DigitalOceanException, RequestUnsuccessfulException {
        if (null == firewall || StringUtils.isBlank((CharSequence)firewall.getName()) || firewall.getInboundRules().isEmpty() || firewall.getOutboundRules().isEmpty()) {
            throw new IllegalArgumentException("Missing required parameters [Name, Inbound rules, Outbound rules] for create firewall.");
        }
        return (Firewall)this.perform(new ApiRequest(ApiAction.CREATE_FIREWALL, firewall)).getData();
    }

    @Override
    public Firewall getFirewallInfo(String firewallId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(firewallId, "Missing required parameters [FirewallID] for get firewall info.");
        Object[] params = new Object[]{firewallId};
        return (Firewall)this.perform(new ApiRequest(ApiAction.GET_FIREWALL_INFO, params)).getData();
    }

    @Override
    public Firewall updateFirewall(Firewall firewall) throws DigitalOceanException, RequestUnsuccessfulException {
        if (null == firewall || StringUtils.isBlank((CharSequence)firewall.getName()) || firewall.getInboundRules().isEmpty() || firewall.getOutboundRules().isEmpty()) {
            throw new IllegalArgumentException("Missing required parameters [Name, Inbound rules, Outbound rules] for update firewall info.");
        }
        Object[] params = new Object[]{firewall.getId()};
        return (Firewall)this.perform(new ApiRequest(ApiAction.UPDATE_FIREWALL, firewall, params)).getData();
    }

    @Override
    public Delete deleteFirewall(String firewallId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(firewallId, "Missing required parameters [ID] for delete firewall info.");
        Object[] params = new Object[]{firewallId};
        return (Delete)this.perform(new ApiRequest(ApiAction.DELETE_FIREWALL, params)).getData();
    }

    @Override
    public Response addDropletsToFirewall(String firewallId, List<Integer> dropletIds) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(firewallId, "Missing required parameter [firewallId].");
        if (null == dropletIds || dropletIds.isEmpty()) {
            throw new IllegalArgumentException("Missing required parameters [dropletIds].");
        }
        Object[] params = new Object[]{firewallId};
        HashMap<String, List<Integer>> data = new HashMap<String, List<Integer>>();
        data.put("droplet_ids", dropletIds);
        return (Response)this.perform(new ApiRequest(ApiAction.ADD_DROPLET_TO_FIREWALL, data, params)).getData();
    }

    @Override
    public Delete removeDropletsFromFirewall(String firewallId, List<Integer> dropletIds) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(firewallId, "Missing required parameter [firewallId].");
        if (null == dropletIds || dropletIds.isEmpty()) {
            throw new IllegalArgumentException("Missing required parameters [dropletIds].");
        }
        Object[] params = new Object[]{firewallId};
        HashMap<String, List<Integer>> data = new HashMap<String, List<Integer>>();
        data.put("droplet_ids", dropletIds);
        return (Delete)this.perform(new ApiRequest(ApiAction.REMOVE_DROPLET_FROM_FIREWALL, data, params)).getData();
    }

    @Override
    public Firewalls getAvailableFirewalls(Integer pageNo, Integer perPage) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validatePageNo(pageNo);
        return (Firewalls)this.perform(new ApiRequest(ApiAction.AVAILABLE_FIREWALLS, pageNo, perPage)).getData();
    }

    @Override
    public Project createProject(Project project) throws DigitalOceanException, RequestUnsuccessfulException {
        if (null == project || StringUtils.isBlank((CharSequence)project.getName()) || null == project.getPurpose()) {
            throw new IllegalArgumentException("Missing required parameters [Name, Purpose].");
        }
        return (Project)this.perform(new ApiRequest(ApiAction.CREATE_PROJECT, project)).getData();
    }

    @Override
    public Projects getAvailableProjects() throws DigitalOceanException, RequestUnsuccessfulException {
        return (Projects)this.perform(new ApiRequest(ApiAction.GET_ALL_PROJECTS)).getData();
    }

    @Override
    public Project updateProject(Project project) throws DigitalOceanException, RequestUnsuccessfulException {
        if (null == project || StringUtils.isBlank((CharSequence)project.getName()) || StringUtils.isBlank((CharSequence)project.getDescription()) || StringUtils.isBlank((CharSequence)project.getPurpose())) {
            throw new IllegalArgumentException("Missing required parameters [Name, Description, Purpose].");
        }
        Object[] params = new Object[]{project.getId()};
        return (Project)this.perform(new ApiRequest(ApiAction.UPDATE_PROJECT, project, params)).getData();
    }

    @Override
    public Project patchProject(Project project) throws DigitalOceanException, RequestUnsuccessfulException {
        if (null == project || StringUtils.isBlank((CharSequence)project.getName()) || StringUtils.isBlank((CharSequence)project.getDescription()) || StringUtils.isBlank((CharSequence)project.getPurpose())) {
            throw new IllegalArgumentException("Missing required parameters [Name, Description, Purpose].");
        }
        Object[] params = new Object[]{project.getId()};
        return (Project)this.perform(new ApiRequest(ApiAction.PATCH_PROJECT, project, params)).getData();
    }

    @Override
    public Project getProject(String projectId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.validateProjectId(projectId);
        Object[] params = new Object[]{projectId};
        return (Project)this.perform(new ApiRequest(ApiAction.GET_PROJECT, params)).getData();
    }

    @Override
    public Project getDefaultProject() throws DigitalOceanException, RequestUnsuccessfulException {
        return (Project)this.perform(new ApiRequest(ApiAction.GET_DEFAULT_PROJECT)).getData();
    }

    @Override
    public Project updateDefaultProject(Project project) throws DigitalOceanException, RequestUnsuccessfulException {
        if (null == project || StringUtils.isBlank((CharSequence)project.getName()) || StringUtils.isBlank((CharSequence)project.getDescription()) || StringUtils.isBlank((CharSequence)project.getPurpose())) {
            throw new IllegalArgumentException("Missing required parameters [Name, Description, Purpose].");
        }
        return (Project)this.perform(new ApiRequest(ApiAction.UPDATE_DEFAULT_PROJECT, project)).getData();
    }

    @Override
    public Project patchDefaultProject(Project project) throws DigitalOceanException, RequestUnsuccessfulException {
        if (null == project || StringUtils.isBlank((CharSequence)project.getName()) || StringUtils.isBlank((CharSequence)project.getDescription()) || StringUtils.isBlank((CharSequence)project.getPurpose())) {
            throw new IllegalArgumentException("Missing required parameters [Name, Description, Purpose].");
        }
        return (Project)this.perform(new ApiRequest(ApiAction.PATCH_DEFAULT_PROJECT, project)).getData();
    }

    @Override
    public Delete deleteProject(String projectId) throws DigitalOceanException, RequestUnsuccessfulException {
        this.checkBlankAndThrowError(projectId, "Missing required parameter - projectId.");
        Object[] params = new Object[]{projectId};
        return (Delete)this.perform(new ApiRequest(ApiAction.DELETE_PROJECT, params)).getData();
    }

    private ApiResponse perform(ApiRequest request) throws DigitalOceanException, RequestUnsuccessfulException {
        URI uri = this.createUri(request);
        String response = null;
        if (RequestMethod.GET == request.getMethod()) {
            response = this.doGet(uri);
        } else if (RequestMethod.POST == request.getMethod()) {
            response = this.doPost(uri, this.createRequestData(request));
        } else if (RequestMethod.PUT == request.getMethod()) {
            response = this.doPut(uri, this.createRequestData(request));
        } else if (RequestMethod.DELETE == request.getMethod()) {
            response = this.doDelete(uri, this.createRequestData(request));
        } else if (RequestMethod.PATCH == request.getMethod()) {
            response = this.doPatch(uri, this.createRequestData(request));
        }
        ApiResponse apiResponse = new ApiResponse(request.getApiAction(), true);
        try {
            if (request.isCollectionElement().booleanValue()) {
                apiResponse.setData(this.deserialize.fromJson(response, request.getClazz()));
            } else {
                JsonObject rootObject = JsonParser.parseString((String)response).getAsJsonObject();
                JsonObject elementObject = rootObject.get(request.getElementName()).getAsJsonObject();
                this.fetchAddElement("rate_limit", rootObject, elementObject);
                this.fetchAddElement("links", rootObject, elementObject);
                this.fetchAddElement("meta", rootObject, elementObject);
                apiResponse.setData(this.deserialize.fromJson((JsonElement)elementObject, request.getClazz()));
            }
        }
        catch (JsonSyntaxException jse) {
            log.error("Error occurred while parsing response", (Throwable)jse);
            apiResponse.setRequestSuccess(false);
        }
        log.debug("API Response:: " + apiResponse.toString());
        return apiResponse;
    }

    private void fetchAddElement(String key, JsonObject rootObject, JsonObject elementObject) {
        JsonElement ele = rootObject.get(key);
        if (null != ele) {
            elementObject.add(key, ele);
        }
    }

    private String doGet(URI uri) throws DigitalOceanException, RequestUnsuccessfulException {
        HttpGet get = new HttpGet(uri);
        get.setHeaders(this.requestHeaders);
        return this.executeHttpRequest((HttpUriRequest)get);
    }

    private String doPost(URI uri, HttpEntity entity) throws DigitalOceanException, RequestUnsuccessfulException {
        HttpPost post = new HttpPost(uri);
        post.setHeaders(this.requestHeaders);
        if (null != entity) {
            post.setEntity(entity);
        }
        return this.executeHttpRequest((HttpUriRequest)post);
    }

    private String doPut(URI uri, HttpEntity entity) throws DigitalOceanException, RequestUnsuccessfulException {
        HttpPut put = new HttpPut(uri);
        put.setHeaders(this.requestHeaders);
        if (null != entity) {
            put.setEntity(entity);
        }
        return this.executeHttpRequest((HttpUriRequest)put);
    }

    private String doDelete(URI uri, HttpEntity entity) throws DigitalOceanException, RequestUnsuccessfulException {
        if (null == entity) {
            HttpDelete delete = new HttpDelete(uri);
            delete.setHeaders(this.requestHeaders);
            delete.setHeader("Content-Type", "application/json");
            return this.executeHttpRequest((HttpUriRequest)delete);
        }
        CustomHttpDelete delete = new CustomHttpDelete(uri);
        delete.setHeaders(this.requestHeaders);
        delete.setEntity(entity);
        return this.executeHttpRequest((HttpUriRequest)delete);
    }

    private String doPatch(URI uri, HttpEntity entity) throws DigitalOceanException, RequestUnsuccessfulException {
        HttpPatch patch = new HttpPatch(uri);
        patch.setHeaders(this.requestHeaders);
        if (null != entity) {
            patch.setEntity(entity);
        }
        return this.executeHttpRequest((HttpUriRequest)patch);
    }

    private String executeHttpRequest(HttpUriRequest request) throws DigitalOceanException, RequestUnsuccessfulException {
        log.debug("HTTP Request:: {} {}", (Object)request.getMethod(), (Object)request.getURI());
        String response = "";
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = this.httpClient.execute(request);
            log.debug("HTTP Response Object:: {}", (Object)httpResponse);
            response = this.appendRateLimitValues(this.evaluateResponse((HttpResponse)httpResponse), (HttpResponse)httpResponse);
            log.debug("Parsed Response:: {}", (Object)response);
        }
        catch (IOException ioe) {
            throw new RequestUnsuccessfulException(ioe.getMessage(), ioe);
        }
        finally {
            try {
                if (null != httpResponse) {
                    httpResponse.close();
                }
            }
            catch (IOException e) {
                log.error("Error occurred while closing a response.", (Throwable)e);
            }
        }
        return response;
    }

    private String evaluateResponse(HttpResponse httpResponse) throws DigitalOceanException {
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        String response = "";
        if (200 == statusCode || 201 == statusCode || 202 == statusCode) {
            response = this.httpResponseToString(httpResponse);
        } else if (204 == statusCode) {
            response = String.format("{\"response\": {\"request_status\": true, \"status_code\": %s}}", statusCode);
        }
        if (statusCode >= 400 && statusCode < 510) {
            String jsonStr = this.httpResponseToString(httpResponse);
            log.debug("JSON Response: {}", (Object)jsonStr);
            JsonObject jsonObj = null;
            String errorMsg = "";
            String id = "";
            try {
                jsonObj = JsonParser.parseString((String)jsonStr).getAsJsonObject();
                id = jsonObj.get("id").getAsString();
                errorMsg = jsonObj.get("message").getAsString();
            }
            catch (JsonSyntaxException e) {
                errorMsg = "Digital Oceans server are on maintenance. Wait for official messages from digital ocean itself. Such as 'Cloud Control Panel, API & Support Ticket System Unavailable'";
            }
            String errorMsgFull = String.format("\nHTTP Status Code: %s\nError Id: %s\nError Message: %s", statusCode, id, errorMsg);
            log.debug(errorMsgFull);
            throw new DigitalOceanException(errorMsg, id, statusCode);
        }
        return response;
    }

    private String httpResponseToString(HttpResponse httpResponse) {
        String response = "";
        if (null != httpResponse.getEntity()) {
            try {
                response = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"utf-8");
            }
            catch (ParseException pe) {
                log.error(pe.getMessage(), (Throwable)pe);
            }
            catch (IOException ioe) {
                log.error(ioe.getMessage(), (Throwable)ioe);
            }
        }
        return response;
    }

    private URI createUri(ApiRequest request) {
        URIBuilder ub = new URIBuilder();
        ub.setScheme("https");
        ub.setHost(this.apiHost);
        ub.setPath(this.createPath(request));
        if (null != request.getPageNo()) {
            ub.setParameter("page", request.getPageNo().toString());
        }
        if (RequestMethod.GET == request.getMethod()) {
            if (null == request.getPerPage()) {
                ub.setParameter("per_page", String.valueOf(25));
            } else {
                ub.setParameter("per_page", request.getPerPage().toString());
            }
        }
        if (null != request.getQueryParams()) {
            for (Map.Entry<String, String> entry : request.getQueryParams().entrySet()) {
                ub.setParameter(entry.getKey(), entry.getValue());
            }
        }
        URI uri = null;
        try {
            uri = ub.build();
        }
        catch (URISyntaxException use) {
            log.error(use.getMessage(), (Throwable)use);
        }
        return uri;
    }

    private String createPath(ApiRequest request) {
        String path = "/" + this.apiVersion + request.getApiAction().getPath();
        return null == request.getPathParams() ? path : String.format(path, request.getPathParams());
    }

    private HttpEntity createRequestData(ApiRequest request) {
        StringEntity data = null;
        if (null != request.getData()) {
            String inputData = this.serialize.toJson(request.getData());
            try {
                data = new StringEntity(inputData);
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return data;
    }

    private String appendRateLimitValues(String response, HttpResponse httpResponse) {
        if (StringUtils.isBlank((CharSequence)response)) {
            return "";
        }
        String rateLimit = this.getSimpleHeaderValue("RateLimit-Limit", httpResponse);
        String rateRemaining = this.getSimpleHeaderValue("RateLimit-Remaining", httpResponse);
        String rateReset = this.getSimpleHeaderValue("RateLimit-Reset", httpResponse);
        if (rateLimit == null || rateRemaining == null || rateReset == null) {
            return response;
        }
        String rateLimitData = String.format("\"rate_limit\": { \"limit\": %s, \"remaining\": %s, \"reset\": \"%s\"}", rateLimit, rateRemaining, this.getDateString(rateReset, "yyyy-MM-dd'T'HH:mm:ssX"));
        log.debug("RateLimitData:: {}", (Object)rateLimitData);
        return StringUtils.substringBeforeLast((String)response, (String)"}") + ", " + rateLimitData + "}";
    }

    private String getDateString(String epochString, String dateFormat) {
        long epoch = Long.parseLong(epochString);
        Date expiry = new Date(epoch * 1000L);
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        String dateString = formatter.format(expiry);
        log.debug(dateString);
        return dateString;
    }

    private String getSimpleHeaderValue(String header, HttpResponse httpResponse, boolean first) {
        if (StringUtils.isBlank((CharSequence)header)) {
            return "";
        }
        Header h = first ? httpResponse.getFirstHeader(header) : httpResponse.getLastHeader(header);
        if (h == null) {
            return null;
        }
        return h.getValue();
    }

    private String getSimpleHeaderValue(String header, HttpResponse httpResponse) {
        return this.getSimpleHeaderValue(header, httpResponse, true);
    }

    private void validateDropletIdAndPageNo(Integer dropletId, Integer pageNo) {
        this.validateDropletId(dropletId);
        this.validatePageNo(pageNo);
    }

    private void validateSnapshotId(String snapshotId) {
        this.checkBlankAndThrowError(snapshotId, "Missing required parameter - snapshotId.");
    }

    private void validateDropletId(Integer dropletId) {
        this.checkNullAndThrowError(dropletId, "Missing required parameter - dropletId.");
    }

    private void validateLoadBalancerId(String loadBalancerId) {
        this.checkBlankAndThrowError(loadBalancerId, "Missing required parameter - loadBalancerId.");
    }

    private void validatePageNo(Integer pageNo) {
        this.checkNullAndThrowError(pageNo, "Missing required parameter - pageNo.");
    }

    private void validateProjectId(String projectId) {
        this.checkNullAndThrowError(projectId, "Missing required parameter - projectId.");
    }

    private void checkNullAndThrowError(Object obj, String msg) {
        if (null == obj) {
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
    }

    private void checkBlankAndThrowError(String str, String msg) {
        if (StringUtils.isBlank((CharSequence)str)) {
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
    }

    private void validateForwardingRules(List<ForwardingRules> rules) {
        if (null == rules || rules.isEmpty()) {
            throw new IllegalArgumentException("Missing required parameters [ForwardingRules]");
        }
        for (ForwardingRules rule : rules) {
            this.validateForwardingRule(rule);
        }
    }

    private void validateForwardingRule(ForwardingRules rule) {
        if (null == rule || null == rule.getEntryProtocol() || null == rule.getEntryPort() || null == rule.getTargetProtocol() || null == rule.getTargetPort()) {
            throw new IllegalArgumentException("Missing required parameters [Entry Protocol, Entry Port, Target Protocol, Target Port] for forwarding rules.");
        }
    }

    private void validateHealthCheck(HealthCheck healthCheck) {
        if (null != healthCheck && (null == healthCheck.getProtocol() || null == healthCheck.getPort())) {
            throw new IllegalArgumentException("Missing required parameters [Protocol, Port] for health check");
        }
    }

    private void initialize() {
        this.deserialize = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssX").create();
        this.serialize = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssX").registerTypeAdapter(Droplet.class, (Object)new DropletSerializer()).registerTypeAdapter(Volume.class, (Object)new VolumeSerializer()).registerTypeAdapter(LoadBalancer.class, (Object)new LoadBalancerSerializer()).registerTypeAdapter(Firewall.class, (Object)new FirewallSerializer()).excludeFieldsWithoutExposeAnnotation().create();
        Header[] headers = new Header[]{new BasicHeader("X-User-Agent", "DigitalOcean API Client by myjeeva.com"), new BasicHeader("Content-Type", "application/json"), new BasicHeader("Authorization", "Bearer " + this.authToken)};
        log.debug("API Request Headers:: " + headers);
        this.requestHeaders = headers;
        if (null == this.httpClient) {
            this.httpClient = HttpClients.createDefault();
        }
    }
}

