/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyCheck.tools;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.DownloadFromUrlInstaller;
import hudson.tools.ToolInstallation;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPOutputStream;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.DependencyCheck.Messages;
import org.jenkinsci.plugins.DependencyCheck.tools.DependencyCheckInstallation;
import org.jenkinsci.plugins.DependencyCheck.tools.Platform;
import org.kohsuke.stapler.DataBoundConstructor;

public class DependencyCheckInstaller
extends DownloadFromUrlInstaller {
    private static final boolean DISABLE_CACHE = Boolean.getBoolean(DependencyCheckInstaller.class.getName() + ".cache.disable");

    @DataBoundConstructor
    public DependencyCheckInstaller(String id) {
        super(id);
    }

    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
        FilePath expected = this.preferredLocation(tool, node);
        DownloadFromUrlInstaller.Installable installable = this.getInstallable();
        if (installable == null) {
            log.getLogger().println("Invalid tool ID " + this.id);
            return expected;
        }
        if (installable instanceof NodeSpecific) {
            installable = (DownloadFromUrlInstaller.Installable)((NodeSpecific)installable).forNode(node, log);
        }
        if (!this.isUpToDate(expected, installable)) {
            expected.deleteContents();
            FilePath cache = this.getLocalCacheFile(node);
            boolean skipInstall = false;
            if (!DISABLE_CACHE && cache.exists()) {
                if (this.isCacheValid(cache)) {
                    log.getLogger().println(Messages.Installer_installFromCache(cache, expected, node.getDisplayName()));
                    try {
                        cache.untar(expected, FilePath.TarCompression.GZIP);
                        skipInstall = true;
                    }
                    catch (IOException e) {
                        log.error("Use of caches failed: " + e.getMessage());
                    }
                } else {
                    log.getLogger().println(Messages.Installer_invalidMD5Cache(cache.getRemote()));
                }
            }
            if (!skipInstall) {
                expected = super.performInstallation(tool, node, log);
                if (!DISABLE_CACHE) {
                    this.buildCache(expected, cache);
                }
            }
        }
        return expected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildCache(FilePath expected, FilePath cache) throws IOException, InterruptedException {
        FilePath cacheParent = cache.getParent();
        if (cacheParent == null) {
            return;
        }
        cacheParent.mkdirs();
        FilePath tmp = cacheParent.createTempFile("cache-", null);
        try {
            try (GZIPOutputStream out = new GZIPOutputStream(tmp.write());){
                expected.tar((OutputStream)out, "**");
            }
            cache.delete();
            tmp.renameTo(cache);
            cacheParent.child(cache.getBaseName() + ".md5").write(cache.digest(), StandardCharsets.UTF_8.name());
        }
        finally {
            tmp.delete();
        }
    }

    @NonNull
    private FilePath getLocalCacheFile(@NonNull Node node) throws IOException {
        Platform platform = Platform.of(node);
        return Jenkins.get().getRootPath().child("caches").child("dependency-check").child(platform.toString()).child(this.id + ".tar.gz");
    }

    private boolean isCacheValid(@NonNull FilePath cache) throws IOException, InterruptedException {
        FilePath cacheParent = cache.getParent();
        if (cacheParent == null) {
            return false;
        }
        FilePath md5Cache = cacheParent.child(cache.getBaseName() + ".md5");
        if (md5Cache.exists()) {
            String md5 = cache.digest();
            return md5.equals(md5Cache.readToString());
        }
        return false;
    }

    @Extension
    public static final class DescriptorImpl
    extends DownloadFromUrlInstaller.DescriptorImpl<DependencyCheckInstaller> {
        public String getDisplayName() {
            return Messages.Installer_displayName();
        }

        public String getId() {
            return "org.jenkinsci.plugins.DependencyCheck.tools.DependencyCheckInstaller";
        }

        public boolean isApplicable(Class<? extends ToolInstallation> toolType) {
            return toolType == DependencyCheckInstallation.class;
        }
    }
}

