/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.todeclarative.converter.freestyle;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.FreeStyleProject;
import hudson.model.JobPropertyDescriptor;
import hudson.scm.SCM;
import io.jenkins.plugins.todeclarative.converter.api.BaseConverter;
import io.jenkins.plugins.todeclarative.converter.api.ConverterException;
import io.jenkins.plugins.todeclarative.converter.api.ConverterRequest;
import io.jenkins.plugins.todeclarative.converter.api.ConverterResult;
import io.jenkins.plugins.todeclarative.converter.api.SingleTypedConverter;
import io.jenkins.plugins.todeclarative.converter.api.Warning;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTAgent;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTKey;

@Extension
public class FreestyleToDeclarativeConverter
extends SingleTypedConverter<FreeStyleProject> {
    public boolean convert(ConverterRequest request, ConverterResult result, Object target) throws ConverterException {
        FreeStyleProject freeStyleProject = (FreeStyleProject)target;
        if (freeStyleProject.isDisabled()) {
            result.addWarning(new Warning("Current Freestyle project is disable", null));
        }
        if (!freeStyleProject.isConcurrentBuild()) {
            result.addWarning(new Warning("Current Freestyle project is marked as no concurrent build but it is default option for pipeline", null));
        }
        ExtensionList converterList = BaseConverter.all();
        this.convertTypeList(request, result, converterList, (Collection)freeStyleProject.getBuildWrappersList());
        final String label = freeStyleProject.getAssignedLabelString();
        ModelASTAgent agent = new ModelASTAgent((Object)this);
        final String customWorkspace = freeStyleProject.getCustomWorkspace();
        if (StringUtils.isBlank((String)label) && StringUtils.isBlank((String)customWorkspace)) {
            ModelASTKey agentKey = new ModelASTKey((Object)this);
            agentKey.setKey("any");
            agent.setAgentType(agentKey);
        } else {
            ModelASTKey agentType = new ModelASTKey((Object)this){

                public String toGroovy() {
                    StringBuilder groovy = new StringBuilder("{\n node { \n");
                    if (StringUtils.isNotBlank((String)label)) {
                        groovy.append("    label '" + label + "'\n");
                    } else {
                        groovy.append("    label ''\n");
                    }
                    if (StringUtils.isNotBlank((String)customWorkspace)) {
                        groovy.append("    customWorkspace \"" + customWorkspace + "\"\n");
                    }
                    groovy.append("    } \n}");
                    return groovy.toString();
                }
            };
            agent.setAgentType(agentType);
        }
        result.getModelASTPipelineDef().setAgent(agent);
        SCM scm = freeStyleProject.getScm();
        if (scm != null) {
            this.convertTypeList(request, result, converterList, Arrays.asList(scm));
        }
        this.convertTypeList(request, result, converterList, freeStyleProject.getTriggers().values());
        Map projectProperties = freeStyleProject.getProperties();
        projectProperties.entrySet().removeIf(entry -> ((JobPropertyDescriptor)entry.getKey()).clazz.getName().equals("hudson.plugins.jira.JiraProjectProperty"));
        this.convertTypeList(request, result, converterList, projectProperties.values());
        this.convertTypeList(request, result, converterList, freeStyleProject.getBuilders());
        this.convertTypeList(request, result, converterList, (Collection)freeStyleProject.getPublishersList());
        return true;
    }
}

