/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.todeclarative.converter.buildwrapper;

import hudson.Extension;
import io.jenkins.plugins.todeclarative.converter.api.ConverterRequest;
import io.jenkins.plugins.todeclarative.converter.api.ConverterResult;
import io.jenkins.plugins.todeclarative.converter.api.SingleTypedConverter;
import io.jenkins.plugins.todeclarative.converter.api.Warning;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.CertificateMultiBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.FileBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.SSHUserPrivateKeyBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.SecretBuildWrapper;
import org.jenkinsci.plugins.credentialsbinding.impl.StringBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.UsernamePasswordBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.UsernamePasswordMultiBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.ZipFileBinding;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTArgumentList;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTSingleArgument;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTTreeStep;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class SecretBuildWrapperConverter
extends SingleTypedConverter<SecretBuildWrapper> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecretBuildWrapperConverter.class);

    public boolean convert(ConverterRequest request, ConverterResult result, Object target) {
        SecretBuildWrapper secretBuildWrapper = (SecretBuildWrapper)SecretBuildWrapper.class.cast(target);
        if (secretBuildWrapper.getBindings() == null || secretBuildWrapper.getBindings().isEmpty()) {
            return true;
        }
        int numWarnings = result.getWarnings().size();
        result.addWrappingTreeStep(() -> this.build(request, secretBuildWrapper, result));
        return result.getWarnings().size() <= numWarnings;
    }

    private ModelASTTreeStep build(ConverterRequest request, SecretBuildWrapper secretBuildWrapper, ConverterResult converterResult) {
        ModelASTTreeStep withCredentials = new ModelASTTreeStep((Object)this);
        withCredentials.setName("withCredentials");
        ModelASTSingleArgument singleArgument = new ModelASTSingleArgument(null);
        withCredentials.setArgs((ModelASTArgumentList)singleArgument);
        for (MultiBinding binding : secretBuildWrapper.getBindings()) {
            String credentialId = binding.getCredentialsId();
            Symbol symbolAnn = binding.getDescriptor().getClass().getAnnotation(Symbol.class);
            List<String> symbols = Arrays.asList(symbolAnn.value());
            Iterator<String> iterator = symbols.iterator();
            while (iterator.hasNext()) {
                String symbol;
                switch (symbol = iterator.next()) {
                    case "usernamePassword": {
                        singleArgument.setValue(ModelASTValue.fromGString((String)this.generateUsernamePassword(binding, credentialId).get(), (Object)((Object)this)));
                        return withCredentials;
                    }
                    case "usernameColonPassword": {
                        singleArgument.setValue(ModelASTValue.fromGString((String)this.generateUsernameColonPassword(binding, credentialId).get(), (Object)((Object)this)));
                        return withCredentials;
                    }
                    case "string": {
                        singleArgument.setValue(ModelASTValue.fromGString((String)this.generateString(binding, credentialId).get(), (Object)((Object)this)));
                        return withCredentials;
                    }
                    case "file": {
                        singleArgument.setValue(ModelASTValue.fromGString((String)this.generateFile(binding, credentialId).get(), (Object)((Object)this)));
                        return withCredentials;
                    }
                    case "zip": {
                        singleArgument.setValue(ModelASTValue.fromGString((String)this.generateZip(binding, credentialId).get(), (Object)((Object)this)));
                        return withCredentials;
                    }
                    case "certificate": {
                        singleArgument.setValue(ModelASTValue.fromGString((String)this.generateCertificate(binding, credentialId).get(), (Object)((Object)this)));
                        return withCredentials;
                    }
                    case "sshUserPrivateKey": {
                        singleArgument.setValue(ModelASTValue.fromGString((String)this.generateSshUser(binding, credentialId).get(), (Object)((Object)this)));
                        return withCredentials;
                    }
                }
                LOGGER.warn("credential binding, ignore symbol: {}", (Object)symbol);
                converterResult.addWarning(new Warning("Cannot convert credential binding: '" + symbol + "'", secretBuildWrapper.getClass()));
            }
        }
        return null;
    }

    private Supplier<String> generateUsernamePassword(MultiBinding binding, String credentialId) {
        UsernamePasswordMultiBinding usernamePasswordMultiBinding = (UsernamePasswordMultiBinding)binding;
        StringBuilder userPMultiString = new StringBuilder("[usernamePassword(usernameVariable: '");
        userPMultiString.append(usernamePasswordMultiBinding.getUsernameVariable());
        userPMultiString.append("', passwordVariable: '");
        userPMultiString.append(usernamePasswordMultiBinding.getPasswordVariable());
        userPMultiString.append("', credentialsId: '");
        userPMultiString.append(credentialId);
        userPMultiString.append("')]");
        return () -> userPMultiString.toString();
    }

    private Supplier<String> generateUsernameColonPassword(MultiBinding binding, String credentialId) {
        UsernamePasswordBinding usernamePasswordBinding = (UsernamePasswordBinding)binding;
        StringBuilder userPwdString = new StringBuilder("[usernameColonPassword(credentialsId: '");
        userPwdString.append(credentialId);
        userPwdString.append("', variable: '");
        userPwdString.append(usernamePasswordBinding.getVariable());
        userPwdString.append("')]");
        return () -> userPwdString.toString();
    }

    private Supplier<String> generateString(MultiBinding binding, String credentialId) {
        StringBinding stringBinding = (StringBinding)binding;
        StringBuilder stringBindingString = new StringBuilder("[string(credentialsId: '");
        stringBindingString.append(credentialId);
        stringBindingString.append("', variable: '");
        stringBindingString.append(stringBinding.getVariable());
        stringBindingString.append("')]");
        return () -> stringBindingString.toString();
    }

    private Supplier<String> generateFile(MultiBinding binding, String credentialId) {
        FileBinding fileBinding = (FileBinding)binding;
        StringBuilder fileBindingString = new StringBuilder("[file(credentialsId: '");
        fileBindingString.append(credentialId);
        fileBindingString.append("', variable: '");
        fileBindingString.append(fileBinding.getVariable());
        fileBindingString.append("')]");
        return () -> fileBindingString.toString();
    }

    private Supplier<String> generateZip(MultiBinding binding, String credentialId) {
        ZipFileBinding zipFileBinding = (ZipFileBinding)binding;
        StringBuilder zipFileBindingString = new StringBuilder("[zip(credentialsId: '");
        zipFileBindingString.append(credentialId);
        zipFileBindingString.append("', variable: '");
        zipFileBindingString.append(zipFileBinding.getVariable());
        zipFileBindingString.append("')]");
        return () -> zipFileBindingString.toString();
    }

    private Supplier<String> generateCertificate(MultiBinding binding, String credentialId) {
        CertificateMultiBinding certificateMultiBinding = (CertificateMultiBinding)binding;
        StringBuilder generateString = new StringBuilder("[certificate(keystoreVariable: '");
        generateString.append(certificateMultiBinding.getKeystoreVariable());
        generateString.append("', aliasVariable: '");
        generateString.append(certificateMultiBinding.getAliasVariable());
        generateString.append("', passwordVariable: '");
        generateString.append(certificateMultiBinding.getPasswordVariable());
        generateString.append("', credentialsId: '");
        generateString.append(credentialId);
        generateString.append("')]");
        return () -> generateString.toString();
    }

    private Supplier<String> generateSshUser(MultiBinding binding, String credentialId) {
        SSHUserPrivateKeyBinding sshUserPrivateKeyBinding = (SSHUserPrivateKeyBinding)binding;
        StringBuilder generateString = new StringBuilder("[sshUserPrivateKey(keyFileVariable: '");
        generateString.append(sshUserPrivateKeyBinding.keyFileVariable);
        generateString.append("', passphraseVariable: '");
        generateString.append(sshUserPrivateKeyBinding.getPassphraseVariable());
        generateString.append("', usernameVariable: '");
        generateString.append(sshUserPrivateKeyBinding.getUsernameVariable());
        generateString.append("', credentialsId: '");
        generateString.append(credentialId);
        generateString.append("')]");
        return () -> generateString.toString();
    }
}

