/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.todeclarative.converter.builder;

import hudson.Extension;
import hudson.tasks.Shell;
import io.jenkins.plugins.todeclarative.converter.api.ConverterRequest;
import io.jenkins.plugins.todeclarative.converter.api.ConverterResult;
import io.jenkins.plugins.todeclarative.converter.api.ModelASTUtils;
import io.jenkins.plugins.todeclarative.converter.api.SingleTypedConverter;
import java.util.Arrays;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTArgumentList;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTBranch;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTPipelineDef;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTSingleArgument;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStage;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStep;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTValue;

@Extension
public class ShellConverter
extends SingleTypedConverter<Shell> {
    public static final String SHELL_NUMBER_KEY = ShellConverter.class.getName() + ".shell.number";

    public boolean convert(ConverterRequest request, ConverterResult result, Object target) {
        Shell shell = (Shell)target;
        ModelASTStage stage = new ModelASTStage((Object)this);
        int stageNumber = request.getAndIncrement(SHELL_NUMBER_KEY);
        stage.setName("Shell script " + stageNumber);
        ModelASTBranch branch = new ModelASTBranch((Object)this);
        stage.setBranches(Arrays.asList(branch));
        ModelASTStep step = new ModelASTStep((Object)this);
        step.setName("sh");
        ModelASTSingleArgument singleArgument = new ModelASTSingleArgument((Object)this);
        singleArgument.setValue(ModelASTValue.fromConstant((Object)shell.getCommand(), (Object)((Object)this)));
        step.setArgs((ModelASTArgumentList)singleArgument);
        ModelASTUtils.wrapBranch((ConverterResult)result, (ModelASTStep)step, (ModelASTBranch)branch);
        ModelASTUtils.addStage((ModelASTPipelineDef)result.getModelASTPipelineDef(), (ModelASTStage)stage);
        return true;
    }
}

