/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.todeclarative.actions;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Job;
import io.jenkins.plugins.prism.PrismConfiguration;
import io.jenkins.plugins.todeclarative.converter.api.ConverterRequest;
import io.jenkins.plugins.todeclarative.converter.api.ConverterResult;
import io.jenkins.plugins.todeclarative.converter.api.ToDeclarativeConverterListener;
import io.jenkins.plugins.todeclarative.converter.api.Warning;
import io.jenkins.plugins.todeclarative.converter.freestyle.FreestyleToDeclarativeConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.model.TransientActionFactory;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTPipelineDef;

public class ToDeclarativeAction
implements Action,
Describable<ToDeclarativeAction> {
    private FreeStyleProject job;
    private String jenkinsFile;
    private List<Warning> warnings;
    private Exception error;

    public ToDeclarativeAction(FreeStyleProject job) {
        this.job = job;
    }

    public String doConvert() throws Exception {
        this.job.checkPermission(Job.CONFIGURE);
        try {
            FreestyleToDeclarativeConverter converter = (FreestyleToDeclarativeConverter)((Object)Jenkins.get().getExtensionList(FreestyleToDeclarativeConverter.class).get(0));
            ConverterRequest converterRequest = new ConverterRequest().job((Job)this.job);
            ConverterResult converterResult = new ConverterResult().modelASTPipelineDef(new ModelASTPipelineDef(null));
            converter.convert(converterRequest, converterResult, this.job);
            this.jenkinsFile = converterResult.getModelASTPipelineDef().toPrettyGroovy();
            this.warnings = converterResult.getWarnings();
            ToDeclarativeConverterListener.fire((AbstractProject)this.job, (ConverterResult)converterResult);
            return this.jenkinsFile;
        }
        catch (Exception e) {
            this.error = e;
            return null;
        }
    }

    public Exception getError() {
        return this.error;
    }

    public List<Warning> getWarnings() {
        return this.warnings;
    }

    @CheckForNull
    public String getIconFileName() {
        return "new-document.png";
    }

    @CheckForNull
    public String getDisplayName() {
        return "To Declarative";
    }

    @CheckForNull
    public String getUrlName() {
        return "todeclarative";
    }

    public String getJenkinsFile() {
        return this.jenkinsFile;
    }

    public void setJenkinsFile(String jenkinsFile) {
        this.jenkinsFile = jenkinsFile;
    }

    public Descriptor<ToDeclarativeAction> getDescriptor() {
        return Jenkins.get().getDescriptorOrDie(this.getClass());
    }

    @Extension
    public static final class ToDeclarativeActionDescriptor
    extends Descriptor<ToDeclarativeAction> {
        public PrismConfiguration getPrismConfiguration() {
            return PrismConfiguration.getInstance();
        }
    }

    @Extension
    public static class ActionInjector
    extends TransientActionFactory<FreeStyleProject> {
        public Collection<ToDeclarativeAction> createFor(@NonNull FreeStyleProject p) {
            return Collections.singletonList(new ToDeclarativeAction(p));
        }

        public Class type() {
            return FreeStyleProject.class;
        }
    }
}

