/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.util.IgnoreFileFilter;
import org.netbeans.lib.cvsclient.util.SimpleStringPattern;
import org.netbeans.lib.cvsclient.util.StringPattern;

public class DefaultIgnoreFileFilter
implements IgnoreFileFilter {
    private static final long serialVersionUID = -5534031149474237036L;
    private final List<StringPattern> patterns = new LinkedList<StringPattern>();
    private final List<StringPattern> localPatterns = new LinkedList<StringPattern>();
    private boolean processGlobalPatterns = true;
    private boolean processLocalPatterns = false;
    private File lastDirectory = null;

    public DefaultIgnoreFileFilter() {
    }

    public DefaultIgnoreFileFilter(List<StringPattern> patternList) {
        for (StringPattern stringPattern : patternList) {
            String patternString = stringPattern.toString();
            SimpleStringPattern pattern = new SimpleStringPattern(patternString);
            this.addPattern(pattern);
        }
    }

    public void addPattern(StringPattern pattern) {
        if (pattern.toString().equals("!")) {
            this.clearPatterns();
        } else {
            this.patterns.add(pattern);
        }
    }

    public void addPattern(String pattern) {
        if (pattern.equals("!")) {
            this.clearPatterns();
        } else {
            this.patterns.add(new SimpleStringPattern(pattern));
        }
    }

    public void clearPatterns() {
        this.patterns.clear();
    }

    @Override
    public boolean shouldBeIgnored(File directory, String noneCvsFile) {
        StringPattern pattern;
        if (this.lastDirectory != directory) {
            this.lastDirectory = directory;
            this.processGlobalPatterns = true;
            this.processLocalPatterns = false;
            this.localPatterns.clear();
            String filename = directory.getPath() + File.separator + ".cvsignore";
            File cvsIgnoreFile = new File(filename);
            if (cvsIgnoreFile.exists()) {
                try {
                    List<String> list = DefaultIgnoreFileFilter.parseCvsIgnoreFile(cvsIgnoreFile);
                    for (String string : list) {
                        String s = string.toString();
                        if (s.equals("!")) {
                            this.processGlobalPatterns = false;
                            this.localPatterns.clear();
                            continue;
                        }
                        this.localPatterns.add(new SimpleStringPattern(s));
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            boolean bl = this.processLocalPatterns = this.localPatterns.size() > 0;
        }
        if (this.processGlobalPatterns) {
            for (StringPattern stringPattern : this.patterns) {
                pattern = stringPattern;
                if (!pattern.doesMatch(noneCvsFile)) continue;
                return true;
            }
        }
        if (this.processLocalPatterns) {
            for (StringPattern stringPattern : this.localPatterns) {
                pattern = stringPattern;
                if (!pattern.doesMatch(noneCvsFile)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> parseCvsIgnoreFile(File cvsIgnoreFile) throws IOException, FileNotFoundException {
        BufferedReader reader = null;
        LinkedList<String> toReturn = new LinkedList<String>();
        try {
            String line;
            reader = new BufferedReader(new FileReader(cvsIgnoreFile));
            while ((line = reader.readLine()) != null) {
                StringTokenizer token = new StringTokenizer(line, " ", false);
                while (token.hasMoreTokens()) {
                    String tok = token.nextToken();
                    toReturn.add(tok);
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return toReturn;
    }
}

