/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.response;

import java.io.EOFException;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.SimpleStringPattern;
import org.netbeans.lib.cvsclient.util.StringPattern;

public class WrapperSendResponse
implements Response {
    private static final long serialVersionUID = 6362147497769600071L;

    public static Map<StringPattern, KeywordSubstitutionOptions> parseWrappers(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line);
        SimpleStringPattern pattern = new SimpleStringPattern(tokenizer.nextToken());
        Map<SimpleStringPattern, KeywordSubstitutionOptions> wrappersMap = null;
        while (tokenizer.hasMoreTokens()) {
            String option = tokenizer.nextToken();
            String value = tokenizer.nextToken();
            if (!option.equals("-k")) continue;
            int first = value.indexOf(39);
            int last = value.lastIndexOf(39);
            if (first >= 0 && last >= 0) {
                value = value.substring(first + 1, last);
            }
            KeywordSubstitutionOptions keywordOption = KeywordSubstitutionOptions.findKeywordSubstOption(value);
            if (wrappersMap == null) {
                if (!tokenizer.hasMoreTokens()) {
                    wrappersMap = Collections.singletonMap(pattern, keywordOption);
                    continue;
                }
                wrappersMap = new LinkedHashMap<SimpleStringPattern, KeywordSubstitutionOptions>();
                wrappersMap.put(pattern, keywordOption);
                continue;
            }
            wrappersMap.put(pattern, keywordOption);
        }
        return wrappersMap;
    }

    @Override
    public void process(LoggedDataInputStream dis, ResponseServices services) throws ResponseException {
        try {
            String wrapperSettings = dis.readLine();
            Map<StringPattern, KeywordSubstitutionOptions> wrappers = WrapperSendResponse.parseWrappers(wrapperSettings);
            Iterator<StringPattern> i$ = wrappers.keySet().iterator();
            while (i$.hasNext()) {
                StringPattern stringPattern;
                StringPattern pattern = stringPattern = i$.next();
                KeywordSubstitutionOptions keywordOption = wrappers.get(pattern);
                services.addWrapper(pattern, keywordOption);
            }
        }
        catch (EOFException ex) {
            throw new ResponseException(ex, CommandException.getLocalMessage("CommandException.EndOfFile", null));
        }
        catch (IOException ex) {
            throw new ResponseException(ex);
        }
        catch (NoSuchElementException nse) {
            throw new ResponseException(nse);
        }
    }

    @Override
    public boolean isTerminalResponse() {
        return false;
    }
}

