/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.response;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.event.FileRemovedEvent;
import org.netbeans.lib.cvsclient.event.FileToRemoveEvent;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;

class RemovedResponse
implements Response {
    private static final long serialVersionUID = 6458998939668862430L;

    RemovedResponse() {
    }

    @Override
    public void process(LoggedDataInputStream dis, ResponseServices services) throws ResponseException {
        try {
            String localPath = dis.readLine();
            String repositoryPath = dis.readLine();
            String filePath = services.convertPathname(localPath, repositoryPath);
            filePath = new File(filePath).getAbsolutePath();
            if (services.getGlobalOptions().isExcluded(new File(filePath))) {
                return;
            }
            FileToRemoveEvent e1 = new FileToRemoveEvent(this, filePath);
            FileRemovedEvent e2 = new FileRemovedEvent(this, filePath);
            services.getEventManager().fireCVSEvent(e1);
            services.removeLocalFile(localPath, repositoryPath);
            services.getEventManager().fireCVSEvent(e2);
        }
        catch (EOFException ex) {
            throw new ResponseException(ex, CommandException.getLocalMessage("CommandException.EndOfFile", null));
        }
        catch (IOException ex) {
            throw new ResponseException(ex);
        }
    }

    @Override
    public boolean isTerminalResponse() {
        return false;
    }
}

