/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.response;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;

class CopyFileResponse
implements Response {
    private static final long serialVersionUID = -6109306986448646381L;

    CopyFileResponse() {
    }

    @Override
    public void process(LoggedDataInputStream dis, ResponseServices services) throws ResponseException {
        try {
            String localPath = dis.readLine();
            String repositoryPath = dis.readLine();
            String newname = dis.readLine();
            String absPath = services.convertPathname(localPath, repositoryPath);
            if (services.getGlobalOptions().isExcluded(new File(absPath))) {
                return;
            }
            if (!services.getGlobalOptions().isDoNoChanges()) {
                services.removeLocalFile(new File(new File(absPath).getParentFile(), newname).getAbsolutePath());
                services.copyLocalFile(absPath, newname);
            }
        }
        catch (EOFException ex) {
            throw new ResponseException(ex, CommandException.getLocalMessage("CommandException.EndOfFile", null));
        }
        catch (IOException ex) {
            throw new ResponseException(ex);
        }
    }

    @Override
    public boolean isTerminalResponse() {
        return false;
    }
}

