/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.response;

import java.io.File;
import java.io.IOException;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;

class ClearStaticDirectoryResponse
implements Response {
    private static final long serialVersionUID = -7812261789649978416L;

    ClearStaticDirectoryResponse() {
    }

    @Override
    public void process(LoggedDataInputStream dis, ResponseServices services) throws ResponseException {
        try {
            String localPath = dis.readLine();
            String repositoryPath = dis.readLine();
            String absPath = services.convertPathname(localPath, repositoryPath);
            if (services.getGlobalOptions().isExcluded(new File(absPath))) {
                return;
            }
            services.updateAdminData(localPath, repositoryPath, null);
            File absFile = new File(absPath, "CVS/Entries.Static");
            if (absFile.exists()) {
                absFile.delete();
            }
        }
        catch (IOException e) {
            throw new ResponseException(e);
        }
    }

    @Override
    public boolean isTerminalResponse() {
        return false;
    }
}

