/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.response;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;

class CheckedInResponse
implements Response {
    private static final long serialVersionUID = -4489238799861869876L;
    private DateFormat dateFormatter;

    CheckedInResponse() {
    }

    @Override
    public void process(LoggedDataInputStream dis, ResponseServices services) throws ResponseException {
        try {
            String localPath = dis.readLine();
            String repositoryPath = dis.readLine();
            String entriesLine = dis.readLine();
            String absPath = services.convertPathname(localPath, repositoryPath);
            if (services.getGlobalOptions().isExcluded(new File(absPath))) {
                return;
            }
            File theFile = new File(absPath);
            Date date = new Date(theFile.lastModified());
            Entry entry = new Entry(entriesLine);
            entry.setConflict(this.getDateFormatter().format(date));
            if (entry.isNewUserFile() || entry.isUserFileToBeRemoved()) {
                entry.setConflict("dummy timestamp");
            }
            services.setEntry(theFile, entry);
        }
        catch (IOException e) {
            throw new ResponseException((Exception)e.fillInStackTrace(), e.getLocalizedMessage());
        }
    }

    @Override
    public boolean isTerminalResponse() {
        return false;
    }

    protected DateFormat getDateFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = Entry.getLastModifiedDateFormatter();
        }
        return this.dateFormatter;
    }
}

