/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.request;

import org.netbeans.lib.cvsclient.request.Request;

public class ArgumentRequest
extends Request {
    private static final long serialVersionUID = -8082084447430405025L;
    private final String argument;
    private final boolean escapeLeadingDash;

    public ArgumentRequest(String argument) {
        this(argument, false);
    }

    public ArgumentRequest(String argument, boolean escapeLeadingDash) {
        this.escapeLeadingDash = escapeLeadingDash;
        if (argument == null) {
            throw new IllegalArgumentException("argument must not be null!");
        }
        this.argument = argument;
    }

    @Override
    public String getRequestString() {
        if (this.escapeLeadingDash && this.argument.startsWith("-")) {
            return "Argument --\nArgument " + this.argument + "\n";
        }
        return "Argument " + this.argument + "\n";
    }

    @Override
    public boolean isResponseExpected() {
        return false;
    }
}

