/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.event;

import org.netbeans.lib.cvsclient.event.CVSEvent;
import org.netbeans.lib.cvsclient.event.CVSListener;

public class MessageEvent
extends CVSEvent {
    private static final long serialVersionUID = -5353012567956443207L;
    private String message;
    private boolean error;
    private boolean tagged;
    private final byte[] raw;

    public MessageEvent(Object source, String message, byte[] raw, boolean isError) {
        super(source);
        this.setMessage(message);
        this.setError(isError);
        this.setTagged(false);
        this.raw = raw;
    }

    public MessageEvent(Object source, String message, boolean isError) {
        this(source, message, null, isError);
    }

    public MessageEvent(Object source) {
        this(source, null, false);
    }

    public String getMessage() {
        return this.message;
    }

    public byte[] getRawData() {
        return this.raw;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    @Override
    protected void fireEvent(CVSListener listener) {
        listener.messageSent(this);
    }

    public boolean isTagged() {
        return this.tagged;
    }

    public void setTagged(boolean tagged) {
        this.tagged = tagged;
    }

    public static String parseTaggedMessage(StringBuffer taggedLineBufferNotNull, String taggedMessage) {
        int index;
        String line = taggedMessage;
        if (line.charAt(0) == '+' || line.charAt(0) == '-') {
            return null;
        }
        String result = null;
        if (line.equals("newline")) {
            result = taggedLineBufferNotNull.toString();
            taggedLineBufferNotNull.setLength(0);
        }
        if ((index = line.indexOf(32)) > 0) {
            taggedLineBufferNotNull.append(line.substring(index + 1));
        }
        return result;
    }
}

