/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.connection;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.net.SocketFactory;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.connection.AbstractConnection;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.ConnectionIdentity;
import org.netbeans.lib.cvsclient.connection.ConnectionModifier;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;

public class SSHConnection
extends AbstractConnection {
    private static final long serialVersionUID = 8088416203833050235L;
    private static final String CVS_SERVER_COMMAND = System.getenv("CVS_SERVER") != null ? System.getenv("CVS_SERVER") + " server" : "cvs server";
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final ConnectionIdentity connectionIdentity;
    private transient Session session;
    private transient ChannelExec channel;

    public SSHConnection(CVSRoot root, ConnectionIdentity connectionIdentity) {
        this.host = root.getHostName();
        this.port = root.getPort() == 0 ? 22 : root.getPort();
        this.username = root.getUserName() != null ? root.getUserName() : System.getProperty("user.name");
        this.password = root.getPassword();
        this.setRepository(root.getRepository());
        this.connectionIdentity = connectionIdentity;
    }

    @Override
    public void open() throws AuthenticationException, CommandAbortedException {
        Properties props = new Properties();
        props.put("StrictHostKeyChecking", "no");
        props.put("PreferredAuthentications", "publickey,password");
        JSch jsch = new JSch();
        try {
            this.session = jsch.getSession(this.username, this.host, this.port);
            this.session.setUserInfo((UserInfo)new SSHUserInfo());
            String knownHostsFile = this.connectionIdentity.getKnownHostsFile();
            String privateKeyPath = this.connectionIdentity.getPrivateKeyPath();
            String separator = System.getProperty("file.separator");
            knownHostsFile = knownHostsFile.replace("/", separator).replace("\\", separator);
            privateKeyPath = privateKeyPath.replace("/", separator).replace("\\", separator);
            jsch.setKnownHosts(knownHostsFile);
            jsch.addIdentity(privateKeyPath, this.connectionIdentity.getPrivateKeyPassword());
            this.session.setSocketFactory((com.jcraft.jsch.SocketFactory)new SocketFactoryBridge(SocketFactory.getDefault()));
            this.session.setConfig(props);
            this.session.connect();
        }
        catch (JSchException e) {
            throw new AuthenticationException(e, "SSH connection failed.");
        }
        try {
            this.channel = (ChannelExec)this.session.openChannel("exec");
            this.channel.setCommand(CVS_SERVER_COMMAND);
            this.setInputStream(new LoggedDataInputStream(new SshChannelInputStream((Channel)this.channel)));
            this.setOutputStream(new LoggedDataOutputStream(this.channel.getOutputStream()));
            this.channel.connect();
        }
        catch (JSchException e) {
            IOException ioe = new IOException("SSH connection failed.");
            ioe.initCause(e);
            throw new AuthenticationException(ioe, "Opening SSH channel failed.");
        }
        catch (IOException e) {
            throw new AuthenticationException(e, "Opening SSH channel failed.");
        }
    }

    @Override
    public void verify() throws AuthenticationException {
        try {
            this.open();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.channel.getExitStatus() != -1) {
                throw new AuthenticationException(CVS_SERVER_COMMAND, "Error executing " + CVS_SERVER_COMMAND + " on server. Set CVS_SERVER environment variable properly.");
            }
            this.close();
        }
        catch (CommandAbortedException e) {
            throw new AuthenticationException(e, "Opening SSH connection failed.");
        }
        catch (IOException e) {
            throw new AuthenticationException(e, "SSH: close connection failed.");
        }
        finally {
            this.reset();
        }
    }

    private void reset() {
        this.session = null;
        this.channel = null;
        this.setInputStream(null);
        this.setOutputStream(null);
    }

    @Override
    public void close() throws IOException {
        if (this.session != null) {
            this.session.disconnect();
        }
        if (this.channel != null) {
            this.channel.disconnect();
        }
        this.reset();
    }

    @Override
    public boolean isOpen() {
        return this.channel != null && this.channel.isConnected();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void modifyInputStream(ConnectionModifier modifier) throws IOException {
        modifier.modifyInputStream(this.getInputStream());
    }

    @Override
    public void modifyOutputStream(ConnectionModifier modifier) throws IOException {
        modifier.modifyOutputStream(this.getOutputStream());
    }

    private static class SshChannelInputStream
    extends FilterInputStream {
        private final Channel channel;

        public SshChannelInputStream(Channel channel) throws IOException {
            super(channel.getInputStream());
            this.channel = channel;
        }

        @Override
        public int available() throws IOException {
            this.checkChannelState();
            return super.available();
        }

        private void checkChannelState() throws IOException {
            int exitStatus = this.channel.getExitStatus();
            if (exitStatus > 0 || exitStatus < -1) {
                throw new IOException("Error executing " + CVS_SERVER_COMMAND + " on server.\\\\nSet CVS_SERVER environment variable properly.");
            }
            if (exitStatus == 0 || this.channel.isEOF()) {
                throw new EOFException("EOF: SSH tunnel closed.");
            }
        }
    }

    private static class SocketFactoryBridge
    implements com.jcraft.jsch.SocketFactory {
        private SocketFactory socketFactory;

        public SocketFactoryBridge(SocketFactory socketFactory) {
            this.socketFactory = socketFactory;
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.socketFactory.createSocket(host, port);
        }

        public InputStream getInputStream(Socket socket) throws IOException {
            return socket.getInputStream();
        }

        public OutputStream getOutputStream(Socket socket) throws IOException {
            return socket.getOutputStream();
        }
    }

    private class SSHUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private SSHUserInfo() {
        }

        public String getPassphrase() {
            return null;
        }

        public String getPassword() {
            return SSHConnection.this.password;
        }

        public boolean promptPassword(String message) {
            return true;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptYesNo(String message) {
            return false;
        }

        public void showMessage(String message) {
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            String[] response = new String[prompt.length];
            if (prompt.length == 1) {
                response[0] = SSHConnection.this.password;
            }
            return response;
        }
    }
}

