/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.commandLine.command;

import java.io.File;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateCommand;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateInformation;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateLine;
import org.netbeans.lib.cvsclient.commandLine.GetOpt;
import org.netbeans.lib.cvsclient.commandLine.ListenerProvider;
import org.netbeans.lib.cvsclient.commandLine.command.CommandProvider;
import org.netbeans.lib.cvsclient.event.CVSAdapter;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.event.TerminationEvent;

public class locbundlecheck
extends CVSAdapter
implements CommandProvider {
    private static final long serialVersionUID = -9190064565949911055L;
    private PrintStream out;
    private int realEnd = 0;
    private HashMap<String, FileInfoContainer> originalBundles;
    private HashMap<String, FileInfoContainer> localizedBundles;
    private String local;
    private String workDir;

    public locbundlecheck() {
    }

    @Override
    public String getName() {
        return "locbundlecheck";
    }

    @Override
    public String[] getSynonyms() {
        return new String[]{"lbch", "lbcheck"};
    }

    @Override
    public String getUsage() {
        return ResourceBundle.getBundle(CommandProvider.class.getPackage().getName() + ".Bundle").getString("locbundlecheck.usage");
    }

    @Override
    public void printShortDescription(PrintStream out) {
        String msg = ResourceBundle.getBundle(CommandProvider.class.getPackage().getName() + ".Bundle").getString("locbundlecheck.shortDescription");
        out.print(msg);
    }

    @Override
    public void printLongDescription(PrintStream out) {
        String msg = ResourceBundle.getBundle(CommandProvider.class.getPackage().getName() + ".Bundle").getString("locbundlecheck.longDescription");
        out.println(msg);
    }

    @Override
    public Command createCommand(String[] args, int index, GlobalOptions gopt, String workDir) {
        LocBundleAnnotateCommand command = new LocBundleAnnotateCommand();
        String getOptString = command.getOptString();
        GetOpt go = new GetOpt(args, getOptString + "i:");
        int ch = -1;
        go.optIndexSet(index);
        boolean usagePrint = false;
        String localization = null;
        while ((ch = go.getopt()) != -1) {
            if (ch == 105) {
                localization = go.optArgGet();
                command.setLocalization(localization);
                continue;
            }
            boolean ok = command.setCVSCommand((char)ch, go.optArgGet());
            if (ok) continue;
            usagePrint = true;
        }
        if (usagePrint || localization == null) {
            throw new IllegalArgumentException(this.getUsage());
        }
        int fileArgsIndex = go.optIndexGet();
        if (fileArgsIndex < args.length) {
            ArrayList<File> fls = new ArrayList<File>();
            if (workDir == null) {
                workDir = System.getProperty("user.dir");
            }
            command.setWorkDir(workDir);
            File workingDir = new File(workDir);
            for (int i = fileArgsIndex; i < args.length; ++i) {
                File fl = new File(workingDir, args[i]);
                if (fl.exists() && fl.isDirectory()) {
                    locbundlecheck.addFilesInDir(fls, fl, localization);
                    continue;
                }
                if (fl.exists() && fl.getName().endsWith(".properties")) {
                    locbundlecheck.addFiles(fls, fl, localization);
                    continue;
                }
                throw new IllegalArgumentException();
            }
            if (fls.size() > 0) {
                File[] fileArgs = new File[fls.size()];
                fileArgs = fls.toArray(fileArgs);
                command.setFiles(fileArgs);
            } else {
                throw new IllegalArgumentException(ResourceBundle.getBundle("org/netbeans/lib/cvsclient/commandLine/command/Bundle").getString("locbundlecheck.no_file_spec"));
            }
        }
        return command;
    }

    private static void addFiles(Collection<File> fileList, File origFile, String localization) {
        String origPath = origFile.getAbsolutePath();
        String enarg = origPath.substring(0, origPath.length() - ".properties".length()) + "_" + localization + ".properties";
        File addfl = new File(enarg);
        fileList.add(origFile);
        if (addfl.exists()) {
            fileList.add(addfl);
        }
    }

    private static void addFilesInDir(Collection<File> fileList, File origFile, String localization) {
        File[] files = origFile.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (file.exists() && file.isDirectory()) {
                    locbundlecheck.addFilesInDir(fileList, file, localization);
                    continue;
                }
                if (!file.exists() || !"Bundle.properties".equals(file.getName())) continue;
                locbundlecheck.addFiles(fileList, file, localization);
            }
        }
    }

    locbundlecheck(PrintStream stdout, PrintStream stderr, String localization, String workDir) {
        this.out = stdout;
        this.originalBundles = new HashMap();
        this.localizedBundles = new HashMap();
        this.local = localization;
        this.workDir = workDir;
    }

    @Override
    public void fileInfoGenerated(FileInfoEvent e) {
        FileInfoContainer cont = e.getInfoContainer();
        if (cont.getFile().getName().indexOf("_" + this.local) >= 0) {
            this.localizedBundles.put(cont.getFile().getAbsolutePath(), cont);
        } else {
            this.originalBundles.put(cont.getFile().getAbsolutePath(), cont);
        }
        if (this.realEnd == 2) {
            this.generateOutput();
        }
    }

    @Override
    public void commandTerminated(TerminationEvent e) {
        if (this.realEnd == 0) {
            this.realEnd = 1;
            return;
        }
        this.realEnd = 2;
    }

    private void generateOutput() {
        for (String origPath : this.originalBundles.keySet()) {
            int dotIndex = origPath.lastIndexOf(".");
            if (dotIndex < 0) {
                throw new IllegalStateException(ResourceBundle.getBundle("org/netbeans/lib/cvsclient/commandLine/command/Bundle").getString("locbundlecheck.illegal_state"));
            }
            String locPath = origPath.substring(0, dotIndex) + "_" + this.local + origPath.substring(dotIndex);
            AnnotateInformation origInfo = (AnnotateInformation)this.originalBundles.get(origPath);
            AnnotateInformation locInfo = (AnnotateInformation)this.localizedBundles.get(locPath);
            if (locInfo == null) {
                this.out.println(MessageFormat.format(ResourceBundle.getBundle("org/netbeans/lib/cvsclient/commandLine/command/Bundle").getString("locbundlecheck.noLocalizedFile"), origPath));
                continue;
            }
            this.localizedBundles.remove(locPath);
            HashMap<String, AnnotateLine> origPropMap = this.createPropMap(origInfo);
            HashMap<String, AnnotateLine> locPropMap = this.createPropMap(locInfo);
            String printFile = origPath;
            if (origPath.startsWith(this.workDir) && ((printFile = origPath.substring(this.workDir.length())).startsWith("/") || printFile.startsWith("\\"))) {
                printFile = printFile.substring(1);
            }
            this.out.println(MessageFormat.format(ResourceBundle.getBundle("org/netbeans/lib/cvsclient/commandLine/command/Bundle").getString("locbundlecheck.File"), printFile));
            for (String prop : origPropMap.keySet()) {
                AnnotateLine origLine = origPropMap.get(prop);
                AnnotateLine locLine = locPropMap.get(prop);
                if (locLine == null) {
                    this.out.println(MessageFormat.format(ResourceBundle.getBundle("org/netbeans/lib/cvsclient/commandLine/command/Bundle").getString("locbundlecheck.propMissing"), prop));
                    continue;
                }
                if (origLine.getDate().compareTo(locLine.getDate()) <= 0) continue;
                this.out.println(MessageFormat.format(ResourceBundle.getBundle("org/netbeans/lib/cvsclient/commandLine/command/Bundle").getString("locbundlecheck.prop_updated"), prop));
            }
        }
        if (this.localizedBundles.size() > 0) {
            for (String prop : this.localizedBundles.keySet()) {
                this.out.println(MessageFormat.format(ResourceBundle.getBundle("org/netbeans/lib/cvsclient/commandLine/command/Bundle").getString("locbundlecheck.prop_removed"), prop));
            }
        }
    }

    private HashMap<String, AnnotateLine> createPropMap(AnnotateInformation info) {
        HashMap<String, AnnotateLine> propMap = new HashMap<String, AnnotateLine>();
        AnnotateLine line = info.getFirstLine();
        while (line != null) {
            String content = line.getContent();
            if (content.startsWith("#")) {
                line = info.getNextLine();
                continue;
            }
            int index = content.indexOf(61);
            if (index > 0) {
                String key = content.substring(0, index);
                propMap.put(key, line);
            }
            line = info.getNextLine();
        }
        return propMap;
    }

    private static class LocBundleAnnotateCommand
    extends AnnotateCommand
    implements ListenerProvider {
        private static final long serialVersionUID = -4579557097716639872L;
        private String loc;
        private String workDir;

        private LocBundleAnnotateCommand() {
        }

        @Override
        public CVSListener createCVSListener(PrintStream stdout, PrintStream stderr) {
            return new locbundlecheck(stdout, stderr, this.loc, this.workDir);
        }

        public void setLocalization(String loc) {
            this.loc = loc;
        }

        public void setWorkDir(String dir) {
            this.workDir = dir;
        }
    }
}

