/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.watchers;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.util.BugLog;

public class WatchersInformation
extends FileInfoContainer {
    public static final String WATCH_EDIT = "edit";
    public static final String WATCH_UNEDIT = "unedit";
    public static final String WATCH_COMMIT = "commit";
    public static final String WATCH_TEMP_EDIT = "tedit";
    public static final String WATCH_TEMP_UNEDIT = "tunedit";
    public static final String WATCH_TEMP_COMMIT = "tcommit";
    private final File file;
    private final List<Watcher> userList = new LinkedList<Watcher>();

    public WatchersInformation(File file) {
        this.file = file;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    void addWatcher(String watchingInfo) {
        String temp = watchingInfo.trim();
        int spaceIndex = (temp = temp.replace('\t', ' ')).indexOf(32);
        if (spaceIndex >= 0) {
            String user = temp.substring(0, spaceIndex);
            String watches = temp.substring(spaceIndex + 1);
            this.userList.add(new Watcher(user, watches));
        }
    }

    public Iterator<Watcher> getWatchersIterator() {
        return this.userList.iterator();
    }

    public static class Watcher {
        private final String userName;
        private final String watches;
        private boolean watchingEdit;
        private boolean watchingUnedit;
        private boolean watchingCommit;
        private boolean temporaryEdit;
        private boolean temporaryUnedit;
        private boolean temporaryCommit;

        Watcher(String userName, String watches) {
            this.userName = userName;
            this.watches = watches;
            StringTokenizer tok = new StringTokenizer(watches, " ", false);
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                if (WatchersInformation.WATCH_EDIT.equals(token)) {
                    this.watchingEdit = true;
                    continue;
                }
                if (WatchersInformation.WATCH_UNEDIT.equals(token)) {
                    this.watchingUnedit = true;
                    continue;
                }
                if (WatchersInformation.WATCH_COMMIT.equals(token)) {
                    this.watchingCommit = true;
                    continue;
                }
                if (WatchersInformation.WATCH_TEMP_COMMIT.equals(token)) {
                    this.temporaryCommit = true;
                    continue;
                }
                if (WatchersInformation.WATCH_TEMP_EDIT.equals(token)) {
                    this.temporaryEdit = true;
                    continue;
                }
                if (WatchersInformation.WATCH_TEMP_UNEDIT.equals(token)) {
                    this.temporaryUnedit = true;
                    continue;
                }
                BugLog.getInstance().bug("unknown = " + token);
            }
        }

        public String getUserName() {
            return this.userName;
        }

        public String getWatches() {
            return this.watches;
        }

        public boolean isWatchingCommit() {
            return this.watchingCommit;
        }

        public boolean isWatchingEdit() {
            return this.watchingEdit;
        }

        public boolean isWatchingUnedit() {
            return this.watchingUnedit;
        }

        public boolean isTempWatchingCommit() {
            return this.temporaryCommit;
        }

        public boolean isTempWatchingEdit() {
            return this.temporaryEdit;
        }

        public boolean isTempWatchingUnedit() {
            return this.temporaryUnedit;
        }
    }
}

