/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.watchers;

import java.io.File;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.watchers.WatchersInformation;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.util.BugLog;

public class WatchersBuilder
implements Builder {
    private static final String UNKNOWN_FILE = "? ";
    private WatchersInformation watchersInfo;
    private final EventManager eventManager;
    private final String localPath;

    public WatchersBuilder(EventManager eventManager, String localPath) {
        this.eventManager = eventManager;
        this.localPath = localPath;
    }

    @Override
    public void outputDone() {
        if (this.watchersInfo != null) {
            this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.watchersInfo));
            this.watchersInfo = null;
        }
    }

    @Override
    public void parseLine(String line, boolean isErrorMessage) {
        if (line.startsWith(UNKNOWN_FILE)) {
            File file = new File(this.localPath, line.substring(UNKNOWN_FILE.length()));
            this.watchersInfo = new WatchersInformation(file);
            this.outputDone();
            return;
        }
        if (isErrorMessage) {
            return;
        }
        if (line.startsWith(" ") || line.startsWith("\t")) {
            BugLog.getInstance().assertNotNull(this.watchersInfo);
            this.watchersInfo.addWatcher(line);
            return;
        }
        this.outputDone();
        String trimmedLine = line.trim().replace('\t', ' ');
        int spaceIndex = trimmedLine.indexOf(32);
        BugLog.getInstance().assertTrue(spaceIndex > 0, "Wrong line = " + line);
        File file = new File(this.localPath, trimmedLine.substring(0, spaceIndex));
        String watcher = trimmedLine.substring(spaceIndex + 1);
        this.watchersInfo = new WatchersInformation(file);
        this.watchersInfo.addWatcher(watcher);
    }

    @Override
    public void parseEnhancedMessage(String key, Object value) {
    }
}

